use Test::More tests => 752;

use IO::File 1.03;

BEGIN { use_ok Data::Entropy::Source; }

my $rawsource = IO::File->new("t/test0.entropy", "r") or die $!;
my $source = Data::Entropy::Source->new($rawsource, "getc");
ok $source;

while(<DATA>) {
	while(/(\d)/g) {
		is $source->get_prob(1000, 3), $1;
	}
}

__DATA__
000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000001000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000010000000000000000000000000000
000000000000000000000000000000000010000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000100000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000
