/* 
 * $Id: ctkprogressbar.c,v 1.8 2000/07/12 22:47:15 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"
#include "ctkcolor.h"

/* Initialize the Progress Bar */
void ctk_progress_bar_init(CtkProgressBar* progressbar)
{
	ctk_progress_init(&progressbar->progress);

	((CtkObject *)progressbar)->type = CtkTypeProgressBar;
	
	((CtkWidget *)progressbar)->width = 10;
	((CtkWidget *)progressbar)->orig_width = 10;
	((CtkWidget *)progressbar)->orig_height = 1;
	((CtkWidget *)progressbar)->height = 1;
	
	((CtkWidget *)progressbar)->main_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_BLUE);
	((CtkWidget *)progressbar)->inverse_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_RED);
	((CtkWidget *)progressbar)->selected_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_BLUE);
}

/* New Progress Bar */
CtkWidget* ctk_progress_bar_new(void)
{
	CtkProgressBar* progressbar;
	
	progressbar = g_malloc(sizeof(CtkProgressBar));
	
	ctk_progress_bar_init(progressbar);
	
	return ((CtkWidget *)progressbar);
}
