/* 
 * $Id: ctkframe.c,v 1.9 2000/07/12 22:47:15 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ctk.h"
#include "ctkcolor.h"

gpointer ctk_frame_destroy(CtkObject *object);

/* CTK Frame Initializer */

void ctk_frame_init(CtkFrame* frame)
{
	ctk_bin_init(&frame->bin);
       
	/* Initialize Other Variables */
	
	((CtkContainer*)frame)->border_width = 1;

	frame->label = NULL;
	
	((CtkWidget *)frame)->width = 2;
	((CtkWidget *)frame)->height = 2;
	((CtkWidget *)frame)->orig_width = 2;
	((CtkWidget *)frame)->orig_height = 2;	
	((CtkObject *)frame)->type = CtkTypeFrame;
	((CtkObject *)frame)->destroy_func = ctk_frame_destroy;

	/* Also setup Colors */
	((CtkWidget *)frame)->main_col = ctk_calculate_palette(CTK_COLOR_WHITE,CTK_COLOR_BLUE);
	((CtkWidget *)frame)->shadow_col = ctk_calculate_palette(CTK_COLOR_BLACK,CTK_COLOR_BLACK);
	((CtkWidget *)frame)->title_col = ctk_calculate_palette(CTK_COLOR_YELLOW,CTK_COLOR_BLUE);
}

/* CTK Frame New - Constructor */
CtkWidget* ctk_frame_new(const gchar* label)
{
	CtkFrame* frame;
	
	/* Init CtkBin */
		
	frame = g_malloc(sizeof(CtkFrame));

	ctk_frame_init(frame);
	ctk_frame_set_label(frame, label);
	
	return CTK_WIDGET(frame);
}

/* Set frame label */
void ctk_frame_set_label(CtkFrame* frame, const gchar* label)
{
	if (!frame)
	    return;
	
	if (frame->label)
	    g_free(frame->label);
	
	frame->label = NULL;
	
	if (label)
	    frame->label = g_strdup(label);
	
	ctk_size_mark_changed(CTK_WIDGET(frame));
}

/* Set frame label align */
void ctk_frame_set_label_align(CtkFrame* frame, gfloat xalign, gfloat yalign)
{
}

/* Frame Destroy Function */
gpointer ctk_frame_destroy(CtkObject* object)
{
	if (((CtkFrame *)object)->label)
	    g_free(((CtkFrame *)object)->label);
	
	return NULL;
}
