/* 
 * $Id: ctkcolor.h,v 1.5 2000/07/07 03:50:42 cbond Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/* 
 * $Id: ctkcolor.h,v 1.5 2000/07/07 03:50:42 cbond Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKCOLOR_H__

# define __CTKCOLOR_H__

#include <glib.h>
#include "ctkwidget.h"
#include "arr.h"

void       ctk_color_init();
CtkWidget* ctk_color_get_parent_widget(CtkWidget* widget);
gchar*     ctk_color_get_name(gint id);

/*
 * XXX this is more or less a temporary solution.  I just don't want to
 * XXX go around changing every occurance of CTK_COLOR_* and such, so this is
 * XXX a bit of a hack.  Check arr.h.
 */

#define ctk_calculate_palette(fg, bg)	(((fg & 0xF) * 0x10) | ((fg) & \
					 FGA_BOLD) | (bg))

#define CTK_COLOR_BLACK			BG_BLACK
#define CTK_COLOR_RED			BG_RED
#define CTK_COLOR_GREEN			BG_GREEN
#define CTK_COLOR_BROWN			BG_BROWN
#define CTK_COLOR_BLUE			BG_BLUE
#define CTK_COLOR_MAGENTA		BG_MAGENTA
#define CTK_COLOR_CYAN			BG_CYAN
#define CTK_COLOR_LIGHT_GRAY		BG_WHITE
#define CTK_COLOR_GRAY			(BG_BLACK | FGA_BOLD)
#define CTK_COLOR_BRIGHT_RED		(BG_RED | FGA_BOLD)
#define CTK_COLOR_BRIGHT_GREEN		(BG_GREEN | FGA_BOLD)
#define CTK_COLOR_YELLOW		(BG_BROWN | FGA_BOLD)
#define CTK_COLOR_BRIGHT_BLUE		(BG_BLUE | FGA_BOLD)
#define CTK_COLOR_BRIGHT_MAGENTA	(BG_MAGENTA | FGA_BOLD)
#define CTK_COLOR_BRIGHT_CYAN		(BG_CYAN | FGA_BOLD)
#define CTK_COLOR_WHITE			(BG_WHITE | FGA_BOLD)

#endif
