/* 
 * $Id: ctkscale.c,v 1.5 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the scale */
void ctk_scale_init(CtkScale* scale)
{
	ctk_range_init(&scale->range);
	scale->draw_value = TRUE;
	scale->value_pos = CTK_POS_TOP;
	CTK_WIDGET(scale)->sensitive = TRUE;
}

void ctk_scale_set_digits(CtkScale* scale, gint digits)
{
	if (!scale)
	    return;
	
	if (digits < 0)
	    digits = 0;
	
	((CtkRange *)scale)->digits = digits;
	
	ctk_draw_mark_changed(CTK_WIDGET(scale));
}

/* Set the draw_value flag */
void ctk_scale_set_draw_value(CtkScale* scale, gboolean draw_value)
{
	if (!scale)
	    return;
	
	scale->draw_value = draw_value;
	ctk_draw_mark_changed(CTK_WIDGET(scale));
}

/* Set Scale Value Position */
void ctk_scale_set_value_pos(CtkScale* scale, CtkPositionType pos)
{
	if (!scale)
	    return;
	    
	ctk_draw_mark_changed(CTK_WIDGET(scale));
}
