/* 
 * $Id: ctkprogress.c,v 1.7 2000/06/28 01:08:47 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the progress */
void ctk_progress_init(CtkProgress* progress)
{
	ctk_widget_init(&progress->widget);
	progress->min   = 0;
	progress->max   = 100;
	progress->value = 0;
	progress->show_text = TRUE;
}

/* Configure a progress widget */
void ctk_progress_configure(CtkProgress* progress, 
			   gfloat value,
			   gfloat min,
			   gfloat max)
{
	if (!progress)
	    return;
	
	if (value < min || value > max) {
		ctk_close();
		g_error("ctk_progress_configure: 'min <= value => max' check failed");
	}
	
	progress->value = value;
	progress->min = min;
	progress->max = max;
	
	ctk_draw_mark_changed(CTK_WIDGET(progress));
}

/* Mark set show text flag */
void  ctk_progress_set_show_text(CtkProgress* progress, gint show_text)
{
	if (!progress)
	    return;
	
	progress->show_text = show_text;
	ctk_size_mark_changed(CTK_WIDGET(progress));
}

/* Get Progress Value */
gfloat ctk_progress_get_value(CtkProgress* progress)
{
	if (!progress)
	    return 0;
	
	return progress->value;
}

/* Set Progress Value */
void ctk_progress_set_value(CtkProgress* progress, gfloat value)
{
	if (!progress)
	    return;

	if (value < progress->min)
	    value = progress->min;
	else if (value > progress->max)
	    value = progress->max;

	progress->value = value;
	
	ctk_draw_mark_changed(CTK_WIDGET(progress));
}

/* Set Progress Percentage */
void ctk_progress_set_percentage(CtkProgress* progress, gfloat percentage)
{
	if (!progress)
	    return;
	
	if (!progress)
	    return;

	percentage = percentage * 100;
	
	ctk_progress_set_value(progress, percentage);
}
