/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#ifndef _SERVERSTAT_H
#define _SERVERSTAT_H

#include <sys/time.h>
#include <netinet/in.h>

typedef struct {

  /* General information concerning the server and this structure */
  char hostname[40]; /* or truncated hostname as the case may be */
  time_t mtime;      /* last modification of this stat structure */
  struct sockaddr_in contact; /* the associated inet addr + port */

  /* Acual statistics for decision making */
  int arriba;   /* How fast is THIS machine */
  int aservers; /* Number of available servers */
  int nservers; /* Number of running servers */
  int load;   /* load times 1000 (keep floats off network) */
  int load_hwm; /* The supremim integral power of 2 of the load seen thus far */
  int cpu;    /* cpu idle time 1000 */
  int ncpu;   /* number of CPUs (load doesn't mean too much otherwise) */
  int tmem;   /* total memory installed (in bytes) */
  int amem;   /* available memory */
  int numbacked; /* Number of requests backhanded */
  int tatime; /* average ms to serve a request (backhanded) */
} serverstat;

/* NOTE!!!!! If we decide to add a short value into the serverstat
   structure, these macros will have to be rewritten to handle
   this... They only work for 32 bit variables... 
   ALSO: you need to add any variables up there down here!  */

#define serverstat_endian_convert(a, f) {\
    (a).arriba = f((a).arriba);\
    (a).aservers = f((a).aservers);\
    (a).nservers = f((a).nservers);\
    (a).load = f((a).load);\
    (a).load_hwm = f((a).load_hwm);\
    (a).cpu = f((a).cpu);\
    (a).ncpu = f((a).ncpu);\
    (a).tmem = f((a).tmem);\
    (a).amem = f((a).amem);\
    (a).numbacked = f((a).numbacked);\
    (a).tatime = f((a).tatime);\
}

/* These are like hton(s|l) and ntoh(s|l) except for serverstats You
   need to call these before sending out a serverstat and after recieving
   a serverstat, respectively */

#define htonss(a) serverstat_endian_convert(a,htonl)
#define ntohss(a) serverstat_endian_convert(a,ntohl)
#define is_alive(a,b,c) (((c) - serverstats[(a)].mtime)<(b))

#endif
