//LabPlot : FitListDialog.h

#ifndef FITLISTDIALOG_H
#define FITLISTDIALOG_H

#include <qtextedit.h>
#include "ListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_multifit_nlin.h>
int fun_f(const gsl_vector *x, void *params, gsl_vector *f);
int fun_df(const gsl_vector *x, void *params, gsl_matrix *J);
int fun_fdf(const gsl_vector *x, void *params, gsl_vector *f,gsl_matrix *J);
#endif

#define NR_PARS 9

class FitListDialog : public ListDialog
{
	Q_OBJECT
public:
	FitListDialog(MainWin *mw=0, const char *name=0);
private slots:
	void updateModel(int model);
	void updateParameter();
	void weightChanged();
	void saveSettings();
	int apply_clicked();
public slots:
	void setFunction(QString fun);									//!< set fit function
	void setNrParameter(int par);									//!< set number of fit parameter
	void setInitialValue(int par, double v);							//!< set initial value of fit parameter
	double initialValue(int par);									//!< get final fit value
	void showResult(bool b=true) { 	resultcb->setChecked(b); }		//!< show fit in plot
	void showLabel(bool b=true) { 	labelcb->setChecked(b); }		//!< show result in plot
	void setSteps(int v) { stepsni->setValue(v); }				//!< set number of fit steps
	void setTolerance(double t) { tolle->setText(QString::number(t)); }	//!< set fit tolerance
	void setWeight(int w) {	weightcb->setCurrentItem(w); }			//!< set weight
	void setWeightFunction(QString w);							//!< set weight function
	void setRegion(double a, double b);							//!< set and use only region
	void setNegateRegion(bool b=true) 
		{ regioncb->setChecked(b); negate_regioncb->setChecked(b); }			//!< set and use negated region
	void setBaseline(double b);									//!< set and use baseline
	void setNrPoints(int v) {	numberni->setValue(v); }		//!< set number of points for fit function
	void setRange(double a, double b);							//!< set range for fit function
	void showResiduals(bool b=true) { rescb->setChecked(b); }		//!< show residuals fo fit result 
	int Apply() { return apply_clicked(); }							//!< do the fit
private:
#ifdef HAVE_GSL
	void print_state(int iter, gsl_multifit_fdfsolver * s);
#endif
	void saveFunction();
	QTextEdit *infote;
	KComboBox *modelcb, *weightcb;
	QCheckBox *regioncb, *negate_regioncb, *baselinecb, *resultcb, *labelcb, *rescb;
	KIntNumInput *parni, *stepsni, *numberni;
	KLineEdit *funle, *tolle, *weightle;
	KLineEdit *parNle[NR_PARS];		// parameter line edits
	KLineEdit *regionminle, *regionmaxle, *baselinele;
	KLineEdit *minle, *maxle;
};

#endif // FITLISTDIALOG_H

