// LabPlot : AnnotateValues.h

#ifndef ANNOTATEVALUES_H
#define ANNOTATEVALUES_H

#include "Point.h"

class AnnotateValues
{
public:
	AnnotateValues(int t=0, int p=0, int d=10);
	void draw(QPainter *p,int X, int Y, double x, double y, double z=0);	// draw to p @ X,Y using values x,y,z
	void save(QTextStream *t);
	void open(QTextStream *t, int version);
	
	int Type() { return type; }
	void setType(int t) { type=t; }
	int Position() { return position; }
	void setPosition(int p) { position=p; }
	int Distance() { return distance; }
	void setDistance(int d) { distance=d; }
private:
	int type;		// 0: NONE, 1: x, 2: x, 3: z, 4: x,y, 5: x,y,z
	int position;	// 0:top,1:bottom,2:left,3:right
	int distance;	// distance from point
};

#endif //ANNOTATEVALUES_H
