/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Flags;

/**
 */
public class VFSFileFlags extends Flags {
    static final private int _NONE = 0;

    static final public VFSFileFlags NONE = new VFSFileFlags(_NONE);

    static final private int _SYMLINK = 1 << 0;

    static final public VFSFileFlags SYMLINK = new VFSFileFlags(_SYMLINK);

    static final private int _LOCAL = 1 << 1;

    static final public VFSFileFlags LOCAL = new VFSFileFlags(_LOCAL);

    static final private VFSFileFlags[] theInterned = new VFSFileFlags[] { 
    		NONE, SYMLINK, LOCAL
	};

    static private java.util.Hashtable theInternedExtras;

    static final private VFSFileFlags theSacrificialOne = new VFSFileFlags(0);

    static public VFSFileFlags intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSFileFlags already = (VFSFileFlags) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSFileFlags(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSFileFlags(int value) {
        value_ = value;
    }

    public VFSFileFlags or(VFSFileFlags other) {
        return intern(value_ | other.value_);
    }

    public VFSFileFlags and(VFSFileFlags other) {
        return intern(value_ & other.value_);
    }

    public VFSFileFlags xor(VFSFileFlags other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSFileFlags other) {
        return (value_ & other.value_) == other.value_;
    }
}
