/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvastextview.h - view for text item.
 */
#ifndef __GOO_CANVAS_TEXT_VIEW_H__
#define __GOO_CANVAS_TEXT_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvastext.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_TEXT_VIEW            (goo_canvas_text_view_get_type ())
#define GOO_CANVAS_TEXT_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_TEXT_VIEW, GooCanvasTextView))
#define GOO_CANVAS_TEXT_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_TEXT_VIEW, GooCanvasTextViewClass))
#define GOO_IS_CANVAS_TEXT_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_TEXT_VIEW))
#define GOO_IS_CANVAS_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_TEXT_VIEW))
#define GOO_CANVAS_TEXT_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_TEXT_VIEW, GooCanvasTextViewClass))


typedef struct _GooCanvasTextView       GooCanvasTextView;
typedef struct _GooCanvasTextViewClass  GooCanvasTextViewClass;

/**
 * GooCanvasTextView
 *
 * The #GooCanvasTextView-struct struct contains private data only.
 */
struct _GooCanvasTextView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasTextViewClass
{
  GooCanvasItemViewSimpleClass parent_class;

  /* The font options we always use. */
  cairo_font_options_t *font_options;
};


GType              goo_canvas_text_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_text_view_new      (GooCanvasView     *canvas_view,
						  GooCanvasItemView *parent_view,
						  GooCanvasText     *text);


G_END_DECLS

#endif /* __GOO_CANVAS_TEXT_VIEW_H__ */
