#!/usr/bin/perl -w
#
# Convert a single gnuplot demo script to a web page
# Usage:
#	webify xxx
#
# Reads xxx.dem and creates xxx.html along with associated 
# png images output to xxx.<n>.png 
#
# If gpsavediff is present also create a set of scripts
# xxx.<n>.gnu corresponding to the minimal set of commands 
# needed to generate that png image.
#
# If gnuplot_demo.css is present, link to it as a stylesheet.
#
# Ethan A Merritt <merritt@u.washington.edu>
# December 2003
#
# EAM Jan 2004
#   use gpsavediff if available
#   link to gnuplot_demo.css if available
#
# EAM Aug 2005
# If DEMOTERM is present as an environmental variable, then use
#    set term DEMOTERM
# rather than the default terminal settings
# E.g. (for image demo)
#    setenv DEMOTERM "png truecolor enhanced font arial 8 transparent size 420,320"
#    ./webify.pl image
#
use Env qw(DEMOTERM GNUPLOT_LIB);

use HTML::Entities;

require "ctime.pl";

# Use the in-tree copy of gnuplot if there is one
	my $gnuplot = ( -x "../../src/gnuplot" ) ? "../../src/gnuplot" : "gnuplot" ;

	if ((!defined $ENV{GNUPLOT_LIB}) || $GNUPLOT_LIB eq "") {
	    $GNUPLOT_LIB = "..";
	}
	my $date = &ctime(time);
	my $plot = 1;

# input and output files
	open(IN,  "<$GNUPLOT_LIB/$ARGV[0].dem") or die "can't open $GNUPLOT_LIB/$ARGV[0].dem";
	open(OUT, ">$ARGV[0].html") or die "can't open $ARGV[0].html";

# open pipe to gnuplot and set terminal type
	open(GNUPLOT, "|$gnuplot") or die "can't find gnuplot";
	if ((defined $ENV{DEMOTERM}) && $DEMOTERM ne "") {
	    print GNUPLOT "set term $DEMOTERM\n";
	} else {
	    print GNUPLOT "set term svg enhanced font 'arial,11' size 600,400 dynamic\n";
	}
	print GNUPLOT "set output \"$ARGV[0].$plot.svg\"\n";

# find out if gpsavediff is available in current path
	my $savescripts = T;
	{local $^W=0; $savescripts = open(FOO, "|gpsavediff") }
	close FOO if ($savescripts);

# Boiler plate header
	print OUT "<html>\n<head>\n<title>gnuplot demo script: $ARGV[0].dem </title>\n";
	print OUT "<link rel=\"stylesheet\" href=\"gnuplot_demo.css\" type=\"text/css\">\n"
		  if (-e "gnuplot_demo.css");
	print OUT "</head>\n";
	print OUT "<body>\n<h2>gnuplot demo script: <font color=blue>$ARGV[0].dem</font> </h2>\n";
	print OUT "<i>autogenerated by webify.pl on $date</i>";

# try to find gnuplot version
	$version = `$gnuplot --version`;
	print OUT "\n<br><i>gnuplot version $version</i>";
	print OUT "<hr>\n";

# Start processing
	print OUT "<table border=0><tr><td valign=top>\n";
	print OUT "<embed src=\"$ARGV[0].$plot.svg\" type=\"image/svg+xml\" width=600 height=400 align=right>\n";
	print OUT "</td><td>\n";


	print OUT "<pre>\n";

	while (<IN>) {
		if (/^ *pause -1/) {
			if ($savescripts) {
			    print OUT "<br><p>Click <a href=$ARGV[0].$plot.gnu>here</a> ",
				  "for minimal script to generate this plot</p>\n";
			    print GNUPLOT "save \"| gpsavediff > $ARGV[0].$plot.gnu\"\n";
			}
			print OUT "</pre></td></tr></table>\n<br clear=all>\n<hr>\n";
			$plot++;
			print OUT "<table border=0><tr><td>\n";
			print OUT "<embed src=\"$ARGV[0].$plot.svg\" type=\"image/svg+xml\" width=600 height=400 align=right>\n";
			print OUT "</td><td valign=top>\n";

			print OUT "<pre>\n";
			print GNUPLOT "set output \"$ARGV[0].$plot.svg\"\n";
		} elsif (/^pause/) {
			print GNUPLOT "set output \"$ARGV[0].$plot.svg\"\n";
		} else {
			print OUT HTML::Entities::encode($_);
			print GNUPLOT;
		}
	}

# Amazingly enough, that's it.
# Replace leftover empty file with a legal svg empty plot before leaving.
	close GNUPLOT;
	unlink("$ARGV[0].$plot.svg");
	open(EMPTY, ">$ARGV[0].$plot.svg") or die "can't open empty plot";
	print EMPTY <<MT
<?xml version="1.0"  standalone="no"?>
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" 
 "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg width="1" height="1"
 xmlns="http://www.w3.org/2000/svg"
 xmlns:xlink="http://www.w3.org/1999/xlink">
</svg>
MT
;
	print OUT "</pre></td></tr><table>\n";
	print OUT "</body>\n</html>\n";

