/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#define MAX_ADDR_LEN 1000

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "allocate.h"
#include "reverse_address.h"


char * reverse_address(char *addr)
{
    char *reverse, *temp, *dot1, *dot2, *dot3, *dot4;
    char *dot5, *dot6, *dot7, *dot8;
    int num_dots = 0;
    int ipv4 = 0;
    int ipv6 = 0;

    reverse = allocate(MAX_ADDR_LEN+3);
    temp  = allocate(MAX_ADDR_LEN);
    dot1 = allocate(MAX_ADDR_LEN);
    dot2 = allocate(MAX_ADDR_LEN);
    dot3 = allocate(MAX_ADDR_LEN);
    dot4 = allocate(MAX_ADDR_LEN);
    dot5 = allocate(MAX_ADDR_LEN);
    dot6 = allocate(MAX_ADDR_LEN);
    dot7 = allocate(MAX_ADDR_LEN);
    dot8 = allocate(MAX_ADDR_LEN);

    /* IPV4 - add a dot in the beginning and one at the end */
    if( strstr(addr, ".") && ! strstr(addr, ":") )
    {
	ipv4 = 1;
	snprintf(reverse, MAX_ADDR_LEN-2, ".%s.", addr);
	temp = strtok(reverse, ".");
	while( temp != NULL )
	{
	    num_dots++;
	    if( num_dots == 1 )
	      snprintf(dot1, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 2 )
	      snprintf(dot2, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 3 )
	      snprintf(dot3, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 4 )
	      snprintf(dot4, MAX_ADDR_LEN-1, "%s", temp);
	    /* We pass NULL to get the next token */	
	    temp = strtok(NULL, ".");
	}
	free(temp);
    }
    else
    /* IPV6 - add a colon in the beginning and one at the end */
    if( strstr(addr, ":") )
    {
	ipv6 = 1;
	snprintf(reverse, MAX_ADDR_LEN-2, ":%s:", addr);
	temp = strtok(reverse, ":");
	while( temp != NULL )
	{
	    num_dots++;
	    if( num_dots == 1 )
	      snprintf(dot1, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 2 )
	      snprintf(dot2, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 3 )
	      snprintf(dot3, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 4 )
	      snprintf(dot4, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 5 )
	      snprintf(dot5, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 6 )
	      snprintf(dot6, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 7 )
	      snprintf(dot7, MAX_ADDR_LEN-1, "%s", temp);
	    if( num_dots == 8 )
	      snprintf(dot8, MAX_ADDR_LEN-1, "%s", temp);
	    /* We pass NULL to get the next token */	
	    temp = strtok(NULL, ":");    
	}
	free(temp);
    }

    if( ipv4 )
    {
	if( num_dots == 1  )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s", dot1);

	if( num_dots == 2 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s.%s", dot2, dot1);

	if( num_dots == 3 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s.%s.%s", dot3, dot2, dot1);

	if( num_dots == 4 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s.%s.%s.%s", dot4, dot3, dot2, dot1);
    }
    else
    if( ipv6 )
    {
	if( num_dots == 1  )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s", dot1);

	if( num_dots == 2 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s", dot2, dot1);

	if( num_dots == 3 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s", dot3, dot2, dot1);

	if( num_dots == 4 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s:%s", dot4, dot3, dot2, dot1);

	if( num_dots == 5  )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s:%s:%s", dot5, dot4, dot3, dot2, dot1);

	if( num_dots == 6 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s:%s:%s:%s", dot6, dot5, dot4, dot3, dot2, dot1);

	if( num_dots == 7 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s:%s:%s:%s:%s", dot7, dot6, dot5, dot4, dot3, dot2, dot1);

	if( num_dots == 8 )
    	    snprintf(reverse, MAX_ADDR_LEN-1, "%s:%s:%s:%s:%s:%s:%s:%s", dot8, dot7, dot6, dot5, dot4, dot3, dot2, dot1);
    }
    else
      {
//         printf("This is not a valid ipv4 or ipv6 address\n");
	 snprintf(reverse, MAX_ADDR_LEN-1, "ADDRESS_ERROR");
      }

    free(dot1); free(dot2); free(dot3); free(dot4);
    free(dot5); free(dot6); free(dot7); free(dot8);

    return reverse;
}
