/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * dir_util.c
 *
 * get_dstool_path()   finds directories for a variety of different dstool
 *                     functions
 *
 */

#include <stdlib.h>
#include <string.h>
#include <constants.h>
#include <utilities.h>


/*
* this proc fetches a filesystem path based on an 
* environment variable.  This proc is architecture-specific!
*/

int 
get_dstool_path(char *path, int type)
{
  char *env_value;

  switch (type) 
    {
    case DSTOOL_DIR:
      if( (env_value = getenv("DSTOOL")) == NULL ) return(FALSE);
      path = strcpy( path, env_value );
      break;
    case DSTOOL_COLOR_DIR:
      if( (env_value = getenv("DSTOOL_COLOR_DIR")) != NULL ) 
	path = strcpy( path, env_value);
      else if ( (env_value = getenv("DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/colormaps");
      }
      else 
	return (FALSE);
      break;
    case DSTOOL_TCL_DIR:
      if( (env_value = getenv("DSTOOL_TCL_DIR")) != NULL )
	path = strcpy(path,env_value);
      else if ( (env_value = getenv("DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/tcl");
      }
      else 
	return (FALSE);
      break;
    case MY_DSTOOL_TCL_DIR:
      if( (env_value = getenv("MY_DSTOOL_TCL_DIR")) != NULL )
	path = strcpy(path,env_value);
      else if ( (env_value = getenv("MY_DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/tcl");
      }
      else 
	return (FALSE);
      break;
    case MY_DSTOOL_OOGL_DIR:
      if( (env_value = getenv("MY_DSTOOL_OOGL_DIR")) != NULL )
	path = strcpy(path,env_value);
      else if ( (env_value = getenv("MY_DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/oogl");
      }
      else 
	return (FALSE);
      break;
    case DSTOOL_OOGL_DIR:
      if( (env_value = getenv("DSTOOL_OOGL_DIR")) != NULL )
	path = strcpy(path,env_value);
      else if ( (env_value = getenv("DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/oogl");
      }
      else 
	return (FALSE);
      break;
    case DSTOOL_HELP_DIR:
      if( (env_value = getenv("DSTOOL_HELP_DIR")) != NULL )
	path = strcpy(path,env_value);
      else if ( (env_value = getenv("DSTOOL")) != NULL ) {
	path = strcpy(path,env_value);
	strcat(path,"/help");
       }
      else 
	return (FALSE);
      break;
    case DSTOOL_DATA_DIR:
      if( (env_value = getenv("DSTOOL_DATA_DIR")) != NULL )
	path = strcpy( path, env_value);
      else
	get_cwd(path, SIZE_OF_DIR);
      break;
    case DSTOOL_PS_PROLOG:
      if( (env_value = getenv("DSTOOL_PS_PROLOG")) != NULL )
	path = strcpy( path, env_value);
      else if( (env_value = getenv("DSTOOL")) != NULL ) 
        path = strcpy( path, env_value );
      else
	get_cwd(path, SIZE_OF_DIR);
      break;
    default:
      system_mess_proc(0,"get_dstool_path: Bad flag for finding path");
      return(FALSE);
      break;
    }
  return(TRUE);
}


int
get_dstool_env(path,type)
     char *path;
     int type;
{
  switch (type) 
    {
    case LPDEST:
      if( getenv("LPDEST") == NULL ) return( FALSE);
      path = strcpy( path, getenv("LPDEST") );
      break;
    case PRINTER:
      if( getenv("PRINTER") == NULL ) return( FALSE);
      path = strcpy( path, getenv("PRINTER") );
      break;
    case DSTOOL_PS_PROLOG:
      if( getenv("DSTOOL_PS_PROLOG") == NULL ) return( FALSE);
      path = strcpy( path, getenv("DSTOOL_PS_PROLOG") );
      break;
    default:
      system_mess_proc(0,"get_dstool_path: Bad flag for finding path");
      return(FALSE);
      break;
    }
  
  return( TRUE );
}




