package imagedir_server;
@ISA = ("imagedir_base");
use strict;
use error;
use diskless;
use imagedir_base;
1;

# create a new object
sub new {
        my $proto = shift;
        my $class = ref($proto) || $proto;
	my $self  = $class->SUPER::new();
        bless($self,$class);
        return $self;
}

# Create object if it doesn't exist
sub create
{
	my $class=$_[0];
	my $imagedir=$_[1];
	my $error=$_[2];
	my $rc;

	die if (!ref($error) or defined ($$error));

	if ( !($imagedir =~ /^\//) or $imagedir eq "/" )
	{
		$$error="error"->new("error"->general,
			"Paranoid check: Attempt to create NFS-Root image with relative or root path");
		return undef;
	}

	if ( -d $imagedir )
	{
		$$error="error"->new("error"->alreadyexists,
			"Attempt to create NFS-Root image when directory already exists");
		return undef;
	}

	if ( ! -f "base2_2.tgz")
	{
		$$error="error"->new("error"->general,
			"Cannot find base2_2.tgz");
		return undef;
	}

	my @imagedeb = <diskless-image-*.deb>;
	if ($#imagedeb < 0)
	{
		$$error="error"->new("error"->general,
			"diskless-image-*.deb cannot be found");
		return undef;
	}
	if ($#imagedeb >= 1)
	{
		$$error="error"->new("error"->general,
			"more then one diskless-image-*.deb found");
		return undef;
	}
	my $imagedeb = $imagedeb[0];
	print "Will use base2_2.tgz and $imagedeb\n";
	
#	$rc = "diskless"->mymkdir("$imagedir",$error);
#	return undef if (!$rc);

	$rc=system("mkdir","-p",$imagedir);
	if ($rc)
	{
		$$error = "error"->process("Error executing mkdir",$?);
		return(0);
	}

	my $isbuffered = $|; $| = 1;
	print "Extracting base2_2.tgz to $imagedir...";
	$| = $isbuffered;
	$rc=system("tar","-C",$imagedir,"-xzf","base2_2.tgz");
	if ($rc)
	{
		$$error = "error"->process("Error executing tar",$?);
		return(0);
	}
	print "done.\n";

	$rc = "diskless"->mymkdir("$imagedir/etc/diskless-image",$error);
	return undef if (!$rc);

	$rc=system("dpkg","--root",$imagedir,"-i",$imagedeb);
	if ($? != 0)
	{
		$$error = "error"->process("Error executing dpkg",$?);
		return(0);
	}

	my $self=$class->get($imagedir,$error);
	return $self;
}


sub config
{
	my $self=$_[0];
	my $options = shift;
	my $error=$_[1];

	die if (!ref($error) or defined ($$error));

	my $imagedir = $self->get_dirname_imagedir;

	# !!!FIXME!!! package is not called diskless-image!
	# How to fix? I don't know...

	system("chroot",$imagedir,"/usr/sbin/configure-diskless-image");
	if ($? != 0)
	{
		$$error = "error"->process("Error executing chroot",$?);
	}

	return(1);
}
