/*
 * Copyright (C) 1999, 2000  Upi Tamminen <desaster@imnetti.fi>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>

#include "reppu.h"

int debug = 0;
int current_frame = 1, remote_hosts = 0, end_frame = -1;
char blend[512], remote_host[MAX_HOSTS][256], current_host[256];

/* this stores the filenames of created images for further use */
struct file_list *filelist;

void *render_thread_remote(void *arg)
{
    client((char *) arg, blend);
    return NULL;
}

int main (int argc, char *argv[])
{
    FILE *filein;
    pthread_t th_remote[MAX_HOSTS]; /* there used to be th_local */
/*  char output[512]; */
    int i;

    bzero(&blend, strlen(blend));
    
    if (argc > 1) if (strcmp(argv[1], "--server") == 0) {
	int foreground = 0;

	for (i = 2; i < argc; i++) {

	    if (strcmp(argv[i], "-v") == 0 || strcmp(argv[i], "--verbose") == 0)
		debug = 1;
	    if (strcmp(argv[i], "-f") == 0 || strcmp(argv[i], "--foreground") == 0)
		foreground = 1;
	}
	if (!foreground) server(0);
	else server(1);
	exit(1);
    }

    printf("Reppu %s -- Copyright (C) 1999 Upi Tamminen <desaster@imnetti.fi>\n\n", REPPU_VERSION);
    if (argc < 3) {
	printf(
	    "Client: reppu <blendfile> <options> <host> [host] ...\n\n"
	    "    <blendfile>                    .blend file to render\n"
	    "    -s <frame>                     first frame to render (default 1)\n"
	    "    -e <frame>                     last frame to render (required)\n"
	    "    <host> [host] ...              hosts that are running reppu server\n\n"
	    "Server: reppu --server [options]\n\n"
	    "        --server                   tells reppu to act as server\n"
	    "    -v, --verbose                  for debugging. use this if you have\n"
	    "                                   problems. -f should be used with this\n"
	    "    -f, --foreground               don't fork() to background\n"
	);
	exit (1);
    }
    
    for (i = 1; i < argc; i++)
    {
	/* anything that begins with - is regonized as option */

	if (argv[i][0] != '-') {
	    if (blend[0] != '\0') {
		if (remote_hosts < MAX_HOSTS) {
		    strcpy(remote_host[remote_hosts], argv[i]);
		    remote_hosts ++;
		}
	    } else {
		strcpy(blend, argv[i]);
	    }
	}
	if (strcmp(argv[i], "-e") == 0) {
	    i ++;
	    end_frame = atoi(argv[i]);
	}

	else if (strcmp(argv[i], "-s") == 0) {
	    current_frame = atoi(argv[++i]);
	}
    }

    if (end_frame == -1) {
	fprintf(stderr, "Use -e to set the end frame\n");
	exit(1);
    } else if (end_frame == 0) {
	fprintf(stderr, "Invalid end frame %d\n", end_frame);
	exit(1);
    } else filelist = malloc(sizeof(struct file_list) * end_frame);

    if (current_frame < 1 || current_frame > end_frame) {
	fprintf(stderr, "Invalid start frame %d\n", current_frame);
	exit(1);
    }

    if ((filein = fopen(blend, "r")) == NULL) {
	fprintf(stderr, "opening %s failed, SHAME!\n", blend);
	exit (1);
    }
    /* Add check-for-blend-header here :) */
    fclose(filein); /* we don't need this anymore */

    if (!remote_hosts) {
	fprintf(stderr, "No host(s) given\n");
	exit(1);
    }

    for (i = 0; i < remote_hosts; i ++)
	if (pthread_create(&th_remote[i], NULL, render_thread_remote, (void *) remote_host[i]) != 0)
	    fprintf(stderr, "failed to create thread\n");

    for (i = 0; i < remote_hosts; i ++)
	pthread_join(th_remote[i], NULL);
    
    /* debugging, remove this */ /*
    for (i = start_frame; i < end_frame + 1; i ++)
	printf("%d: [%s]\n", i, filelist[i].string); */

/*
    memset(output, 0, sizeof(output));
    strncat(output, blend, strlen(blend) - 5);
    sprintf(output, "%smpg", output);
    printf("Encoding [%s]\n", output);
*/
    return 0;
}
