/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.GrammarResolverImpl;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static final String[] IDENTITY_CONSTRAINTS = new String[]{"unique", "key", "keyref"};
    private static boolean DEBUGGING = false;
    private static boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    private static boolean DEBUG_UNION = false;
    private static boolean CR_IMPL = true;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Hashtable fElementRecurseComplex = new Hashtable();
    private boolean fElementDefaultQualified = false;
    private boolean fAttributeDefaultQualified = false;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private EntityResolver fEntityResolver = null;
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void startNamespaceDeclScope(int n, int n2) {
    }

    public void endNamespaceDeclScope(int n) {
    }

    private String resolvePrefixToURI(String string) throws Exception {
        String string2 = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string)));
        if (string2 == null) {
            this.reportGenericSchemaError("prefix : [" + string + "] can not be resolved to a URI");
            return "";
        }
        if (string.length() == 0 && string2.equals("http://www.w3.org/2000/10/XMLSchema") && this.fTargetNSURIString.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string, EntityResolver entityResolver) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.fEntityResolver = entityResolver;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public void doTraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        String string;
        Object object;
        Object object2;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fSchemaRootElement = element;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        this.fGrammarResolver = grammarResolver;
        this.fDatatypeRegistry = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
        this.fDatatypeRegistry.expandRegistryToFullSchemaSet();
        if (element == null) {
            return;
        }
        String string2 = element.getPrefix();
        if ((string2 == null || string2.length() == 0) && ((String)(object2 = element.getAttribute("xmlns"))).length() == 0) {
            element.setAttribute("xmlns", "http://www.w3.org/2000/10/XMLSchema");
        }
        this.fTargetNSURIString = element.getAttribute("targetNamespace");
        if (this.fTargetNSURIString == null) {
            this.fTargetNSURIString = "";
        }
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            if (this.fSchemaGrammar.getComplexTypeRegistry() == null) {
                this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            } else {
                this.fComplexTypeRegistry = this.fSchemaGrammar.getComplexTypeRegistry();
            }
            if (this.fSchemaGrammar.getAttirubteDeclRegistry() == null) {
                this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            } else {
                this.fAttributeDeclRegistry = this.fSchemaGrammar.getAttirubteDeclRegistry();
            }
            if (this.fSchemaGrammar.getNamespacesScope() == null) {
                this.fSchemaGrammar.setNamespacesScope(this.fNamespacesScope);
            } else {
                this.fNamespacesScope = this.fSchemaGrammar.getNamespacesScope();
            }
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setTargetNamespaceURI(this.fTargetNSURIString);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        object2 = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)object2.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string3 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string3), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup")) {
                if (string.equals("attribute")) {
                    this.traverseAttributeDecl((Element)object, null, false);
                } else if (string.equals("group")) {
                    this.traverseGroupDecl((Element)object);
                } else if (!string.equals("notation")) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    private void checkTopLevelDuplicateNames(Element element) {
    }

    private void extractTopLevel3Components(Element element) {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getLocalName();
            String string2 = element2.getAttribute("name");
            if (string.equals("attributeGroup")) {
                this.fSchemaGrammar.topLevelAttrGrpDecls.put(string2, element2);
            } else if (string.equals("attribute")) {
                this.fSchemaGrammar.topLevelAttrDecls.put(string2, element2);
            } else if (string.equals("group")) {
                this.fSchemaGrammar.topLevelGroupDecls.put(string2, element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private String expandSystemId(String string, String string2) throws Exception {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        string3 = TraverseSchema.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = string4 + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    private void traverseInclude(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = string + ',' + inputSource.getSystemId();
        }
        if (this.fIncludeLocations.contains(string)) {
            return;
        }
        this.fIncludeLocations.addElement(string);
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string2 = element2.getAttribute("targetNamespace");
            if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string2 + "'");
            } else {
                boolean bl = this.fElementDefaultQualified;
                boolean bl2 = this.fAttributeDefaultQualified;
                int n = this.fCurrentScope;
                String string3 = this.fCurrentSchemaURL;
                Element element3 = this.fSchemaRootElement;
                this.fSchemaRootElement = element2;
                this.fCurrentSchemaURL = string;
                this.traverseIncludedSchema(element2);
                this.fCurrentSchemaURL = string3;
                this.fCurrentScope = n;
                this.fElementDefaultQualified = bl;
                this.fAttributeDefaultQualified = bl2;
                this.fSchemaRootElement = element3;
            }
        }
    }

    private void traverseIncludedSchema(Element element) throws Exception {
        String string;
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string2 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup")) {
                if (string.equals("attribute")) {
                    this.traverseAttributeDecl((Element)object, null, false);
                } else if (!(string.equals("group") && object.getAttribute("ref").equals("") || string.equals("notation"))) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    private void traverseImport(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = string + ',' + inputSource.getSystemId();
        }
        if (this.fImportLocations.contains(string)) {
            return;
        }
        this.fImportLocations.addElement(string);
        String string2 = element.getAttribute("namespace");
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (schemaGrammar == null) {
            schemaGrammar = new SchemaGrammar();
        }
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string3 = element2.getAttribute("targetNamespace");
            if (!string3.equals(string2)) {
                this.reportGenericSchemaError("imported schema '" + string + "' has a different targetNameSpace '" + string3 + "' from what is declared '" + string2 + "'.");
            } else {
                new TraverseSchema(element2, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, string, this.fEntityResolver);
            }
        } else {
            this.reportGenericSchemaError("Could not get the doc root for imported Schema file: " + string);
        }
    }

    private void traverseAnnotationDecl(Element element) {
    }

    private Element checkContent(Element element, Element element2, boolean bl) throws Exception {
        if (element2 == null) {
            if (!bl) {
                this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
            }
            return null;
        }
        if (element2.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element2);
            element2 = XUtil.getNextSiblingElement(element2);
            if (element2 == null) {
                if (!bl) {
                    this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
                }
                return null;
            }
            if (element2.getLocalName().equals("annotation")) {
                this.reportSchemaError(26, new Object[]{element.getAttribute("name")});
                return null;
            }
        }
        return element2;
    }

    private DatatypeValidator findDTValidator(Element element, String string) throws Exception {
        Element element2;
        String string2;
        int n = this.fStringPool.addSymbol(string);
        String string3 = "";
        DatatypeValidator datatypeValidator = null;
        String string4 = string;
        int n2 = string.indexOf(":");
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2 + 1);
        }
        if ((datatypeValidator = this.getDatatypeValidator(string2 = this.resolvePrefixToURI(string3), string4)) == null && (element2 = this.getTopLevelComponentByName("simpleType", string4)) != null) {
            this.traverseSimpleTypeDecl(element2);
            datatypeValidator = this.getDatatypeValidator(string2, string4);
        }
        if (datatypeValidator == null) {
            this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
        }
        return datatypeValidator;
    }

    private int traverseSimpleTypeDecl(Element element) throws Exception {
        Object object;
        int n;
        int n2;
        if (DEBUG_UNION) {
            System.out.println("----------->CR traverseSimpleType()");
        }
        String string = element.getAttribute("name");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = -1;
        n3 = string.equals("") ? this.fStringPool.addSymbol("#S#" + this.fSimpleTypeAnonCount++) : this.fStringPool.addSymbol(string);
        Element element2 = XUtil.getFirstChildElement(element);
        if ((element2 = this.checkContent(element, element2, false)) == null) {
            return -1;
        }
        String string2 = element2.getLocalName();
        String string3 = null;
        Vector<DatatypeValidator> vector = null;
        int n4 = 0;
        StringTokenizer stringTokenizer = null;
        int n5 = 0;
        if (DEBUG_UNION) {
            System.out.println("[varietyProperty]:" + string2);
        }
        if (string2.equals("list")) {
            string3 = element2.getAttribute("itemType");
            bl = true;
        } else if (string2.equals("restriction")) {
            string3 = element2.getAttribute("base");
            bl3 = true;
        } else if (string2.equals("union")) {
            bl2 = true;
            string3 = element2.getAttribute("memberTypes");
            if (string3 != "") {
                stringTokenizer = new StringTokenizer(string3);
                n4 = stringTokenizer.countTokens();
            } else {
                n4 = 1;
            }
            vector = new Vector<DatatypeValidator>(n4, 2);
        } else {
            this.reportSchemaError(7, new Object[]{string2});
            return -1;
        }
        DatatypeValidator datatypeValidator = null;
        if (DEBUG_UNION) {
            System.out.println("[nameProperty]= " + string);
            System.out.println("[base]= " + string3 + ";");
            System.out.println("[size]= " + n4);
            if (stringTokenizer != null) {
                System.out.println("[unionMembers]= " + stringTokenizer.toString());
            }
        }
        if (string3 == "") {
            element2 = XUtil.getFirstChildElement(element2);
            if ((element2 = this.checkContent(element, element2, false)) == null) {
                return -1;
            }
            if (element2.getLocalName().equals("simpleType")) {
                n2 = this.traverseSimpleTypeDecl(element2);
                if (DEBUG_UNION) {
                    System.out.println("[After traverseSimpleTypeDecl]: " + this.fStringPool.toString(n2));
                    System.out.println("[traverseSimpleTypeDecl]: " + string);
                }
                if (n2 != -1 && (datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n2))) != null && bl2) {
                    vector.addElement(datatypeValidator);
                }
                if (n2 == -1 || datatypeValidator == null) {
                    this.reportSchemaError(15, new Object[]{element2.getAttribute("base"), element2.getAttribute("name")});
                    return -1;
                }
            }
        } else {
            n5 = 1;
            if (bl2) {
                n5 = n4;
            }
            n = 0;
            while (n < n5) {
                if (bl2) {
                    string3 = stringTokenizer.nextToken();
                }
                if ((datatypeValidator = this.findDTValidator(element, string3)) == null) {
                    return -1;
                }
                if (bl2) {
                    vector.addElement(datatypeValidator);
                }
                if (bl && datatypeValidator instanceof UnionDatatypeValidator) {
                    this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
                    return -1;
                }
                ++n;
            }
        }
        element2 = string3 == "" ? XUtil.getNextSiblingElement(element2) : XUtil.getFirstChildElement(element2);
        if (bl2) {
            n = n4;
            while (element2 != null) {
                if (DEBUG_UNION) {
                    System.out.println("[start Union types traversal] + " + element2.getNodeName());
                    System.out.println(n + "-Getting all other simpletypes");
                    System.out.println("content: " + element2.getNodeName());
                }
                if ((n2 = this.traverseSimpleTypeDecl(element2)) != -1 && (datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n2))) != null) {
                    if (DEBUG_UNION) {
                        System.out.println("validator to add: " + datatypeValidator.toString());
                    }
                    vector.addElement(datatypeValidator);
                }
                if (datatypeValidator == null || n2 == -1) {
                    this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
                    return -1;
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
        }
        Hashtable<String, Object> hashtable = null;
        int n6 = 0;
        if (bl3 && element2 != null) {
            int n7 = 0;
            hashtable = new Hashtable<String, Object>();
            object = new Vector();
            element2 = this.checkContent(element, element2, true);
            while (element2 != null) {
                if (element2.getNodeType() == 1) {
                    ++n6;
                    if (element2.getLocalName().equals("enumeration")) {
                        ++n7;
                        String string4 = element2.getAttribute("value");
                        ((Vector)object).addElement(string4);
                        this.checkContent(element, XUtil.getFirstChildElement(element2), true);
                    } else if (element2.getLocalName().equals("annotation")) {
                        this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
                    } else {
                        hashtable.put(element2.getLocalName(), element2.getAttribute("value"));
                        this.checkContent(element, XUtil.getFirstChildElement(element2), true);
                    }
                }
                element2 = XUtil.getNextSiblingElement(element2);
            }
            if (n7 > 0) {
                hashtable.put("enumeration", object);
            }
        } else if (bl && element2 != null) {
            if (string3 != "") {
                element2 = this.checkContent(element, element2, true);
            } else {
                this.reportSchemaError(27, new Object[]{element.getAttribute("name")});
            }
        } else if (bl2 && element2 != null) {
            if (string3 != "") {
                element2 = this.checkContent(element, element2, true);
            } else {
                this.reportSchemaError(27, new Object[]{element.getAttribute("name")});
            }
        }
        String string5 = this.fStringPool.toString(n3);
        if (this.fTargetNSURIString.length() != 0) {
            string5 = this.fTargetNSURIString + "," + string5;
        }
        try {
            object = this.fDatatypeRegistry.getDatatypeValidator(string5);
            if (object == null) {
                if (bl) {
                    this.fDatatypeRegistry.createDatatypeValidator(string5, datatypeValidator, hashtable, true);
                } else if (bl3) {
                    this.fDatatypeRegistry.createDatatypeValidator(string5, datatypeValidator, hashtable, false);
                } else {
                    this.fDatatypeRegistry.createDatatypeValidator(string5, vector);
                }
            }
        }
        catch (Exception exception) {
            this.reportSchemaError(21, new Object[]{exception.getMessage()});
        }
        return this.fStringPool.addSymbol(string5);
    }

    private int traverseAny(Element element) throws Exception {
        int n = -1;
        String string = element.getAttribute("namespace").trim();
        String string2 = element.getAttribute("processContents").trim();
        int n2 = 6;
        int n3 = 7;
        int n4 = 8;
        if (string2.length() > 0 && !string2.equals("strict")) {
            if (string2.equals("lax")) {
                n2 = 22;
                n3 = 23;
                n4 = 24;
            } else if (string2.equals("skip")) {
                n2 = 38;
                n3 = 39;
                n4 = 40;
            }
        }
        if (string.length() == 0 || string.equals("##any")) {
            n = this.fSchemaGrammar.addContentSpecNode(n2, -1, -1, false);
        } else if (string.equals("##other")) {
            String string3 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
            int n5 = this.fStringPool.addSymbol(string3);
            n = this.fSchemaGrammar.addContentSpecNode(n3, -1, n5, false);
        } else if (string.equals("##local")) {
            n = this.fSchemaGrammar.addContentSpecNode(n4, -1, -1, false);
        } else if (string.length() > 0) {
            int n6;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreElements()) {
                string4 = stringTokenizer.nextToken();
                if (string4.equals("##targetNamespace")) {
                    string4 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
                }
                vector.addElement(string4);
            }
            string4 = (String)vector.elementAt(0);
            int n7 = this.fStringPool.addSymbol(string4);
            int n8 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
            int n9 = vector.size();
            if (n9 > 1) {
                string4 = (String)vector.elementAt(1);
                n7 = this.fStringPool.addSymbol(string4);
                int n10 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
                int n11 = this.fSchemaGrammar.addContentSpecNode(4, n8, n10, false);
                int n12 = 2;
                while (n12 < n9) {
                    string4 = (String)vector.elementAt(n12);
                    n7 = this.fStringPool.addSymbol(string4);
                    n10 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
                    n11 = this.fSchemaGrammar.addContentSpecNode(4, n11, n10, false);
                    ++n12;
                }
                n = n11;
            } else {
                n = n6;
            }
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for any element");
        }
        return n;
    }

    public DatatypeValidator getDatatypeValidator(String string, String string2) {
        DatatypeValidator datatypeValidator = null;
        datatypeValidator = string.length() == 0 || string.equals("http://www.w3.org/2000/10/XMLSchema") ? this.fDatatypeRegistry.getDatatypeValidator(string2) : this.fDatatypeRegistry.getDatatypeValidator(string + "," + string2);
        return datatypeValidator;
    }

    private XMLAttributeDecl traverseAnyAttribute(Element element) throws Exception {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        String string = element.getAttribute("processContents").trim();
        String string2 = element.getAttribute("namespace").trim();
        String string3 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        if (string2.length() == 0 || string2.equals("##any")) {
            xMLAttributeDecl.type = 8;
        } else if (string2.equals("##other")) {
            xMLAttributeDecl.type = 9;
            xMLAttributeDecl.name.uri = this.fStringPool.addSymbol(string3);
        } else if (string2.equals("##local")) {
            xMLAttributeDecl.type = 10;
        } else if (string2.length() > 0) {
            xMLAttributeDecl.type = 11;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = this.fStringPool.startStringList();
            Vector vector = new Vector();
            while (stringTokenizer.hasMoreElements()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("##targetNamespace")) {
                    string4 = string3;
                }
                if (this.fStringPool.addStringToList(n, this.fStringPool.addSymbol(string4))) continue;
                this.reportGenericSchemaError("Internal StringPool error when reading the namespace attribute for anyattribute declaration");
            }
            this.fStringPool.finishStringList(n);
            xMLAttributeDecl.enumeration = n;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for anyattribute declaration");
        }
        xMLAttributeDecl.defaultType = 4;
        if (string.equals("skip")) {
            xMLAttributeDecl.defaultType = 6;
        } else if (string.equals("lax")) {
            xMLAttributeDecl.defaultType = 5;
        }
        return xMLAttributeDecl;
    }

    private XMLAttributeDecl mergeTwoAnyAttribute(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == -1) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 8) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl2.type == 8) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9) {
            if (xMLAttributeDecl2.type == 9) {
                if (xMLAttributeDecl2.name.uri == xMLAttributeDecl.name.uri) {
                    return xMLAttributeDecl;
                }
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl2;
            }
            if (xMLAttributeDecl2.type == 11) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl2.enumeration, xMLAttributeDecl.name.uri)) {
                    return xMLAttributeDecl2;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration);
                int n = this.fStringPool.startStringList();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] != xMLAttributeDecl.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n2]);
                    }
                    ++n2;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl2.enumeration = n;
                return xMLAttributeDecl2;
            }
        }
        if (xMLAttributeDecl.type == 10) {
            if (xMLAttributeDecl2.type == 9 || xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
        }
        if (xMLAttributeDecl.type == 11) {
            if (xMLAttributeDecl2.type == 9) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl.enumeration, xMLAttributeDecl2.name.uri)) {
                    return xMLAttributeDecl;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration);
                int n = this.fStringPool.startStringList();
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] != xMLAttributeDecl2.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n3]);
                    }
                    ++n3;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                int[] nArray = this.intersect2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration));
                int n = this.fStringPool.startStringList();
                int n4 = 0;
                while (n4 < nArray.length) {
                    this.fStringPool.addStringToList(n, nArray[n4]);
                    ++n4;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
        }
        return xMLAttributeDecl;
    }

    int[] intersect2sets(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length > nArray2.length ? nArray.length : nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (nArray[n2] == nArray2[n3]) {
                    nArray3[n++] = nArray[n2];
                }
                ++n3;
            }
            ++n2;
        }
        int[] nArray4 = new int[n];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        return nArray4;
    }

    private int traverseComplexTypeDecl(Element element) throws Exception {
        String string;
        ComplexTypeInfo complexTypeInfo;
        String string2 = element.getAttribute("abstract");
        String string3 = element.getAttribute("block");
        String string4 = element.getAttribute("final");
        String string5 = element.getAttribute("ID");
        String string6 = element.getAttribute("name");
        String string7 = element.getAttribute("mixed");
        boolean bl = false;
        if (DEBUGGING) {
            System.out.println("traversing complex Type : " + string6);
        }
        if (string6.equals("")) {
            string6 = "#" + this.fAnonTypeCount++;
        } else {
            this.fCurrentTypeNameStack.push(string6);
            bl = true;
        }
        int n = this.fStringPool.addSymbol(string6);
        if (this.isTopLevel(element) && (complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string = this.fTargetNSURIString + "," + string6)) != null) {
            return this.fStringPool.addSymbol(string);
        }
        int n2 = this.fScopeCount++;
        int n3 = this.fCurrentScope;
        this.fCurrentScope = n2;
        Element element2 = null;
        ComplexTypeInfo complexTypeInfo2 = new ComplexTypeInfo();
        try {
            element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
            if (element2 == null) {
                this.processComplexContent(n, element2, complexTypeInfo2, null, false);
            } else {
                String string8 = element2.getLocalName();
                int n4 = -2;
                if (string8.equals("simpleContent")) {
                    this.traverseSimpleContentDecl(n, element2, complexTypeInfo2);
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the simpleContent child in the complexType");
                    }
                } else if (string8.equals("complexContent")) {
                    this.traverseComplexContentDecl(n, element2, complexTypeInfo2, string7.equals("true"));
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the complexContent child in the complexType");
                    }
                } else {
                    this.processComplexContent(n, element2, complexTypeInfo2, null, string7.equals("true"));
                }
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            String string9 = complexTypeRecoverableError.getMessage();
            this.handleComplexTypeError(string9, n, complexTypeInfo2);
        }
        complexTypeInfo2.scopeDefined = n2;
        complexTypeInfo2.blockSet = this.parseBlockSet(string3);
        complexTypeInfo2.finalSet = this.parseFinalSet(string4);
        boolean bl2 = complexTypeInfo2.isAbstract = string2.equals("true");
        if (!string6.startsWith("#")) {
            string6 = this.fTargetNSURIString + "," + string6;
        }
        complexTypeInfo2.typeName = new String(string6);
        if (DEBUGGING) {
            System.out.println(">>>add complex Type to Registry: " + string6 + " baseDTValidator=" + complexTypeInfo2.baseDataTypeValidator + " baseCTInfo=" + complexTypeInfo2.baseComplexTypeInfo + " derivedBy=" + complexTypeInfo2.derivedBy + " contentType=" + complexTypeInfo2.contentType + " contentSpecHandle=" + complexTypeInfo2.contentSpecHandle + " datatypeValidator=" + complexTypeInfo2.datatypeValidator);
        }
        this.fComplexTypeRegistry.put(string6, complexTypeInfo2);
        this.fCurrentScope = n3;
        if (bl) {
            this.fCurrentTypeNameStack.pop();
            this.checkRecursingComplexType();
        }
        this.fSchemaGrammar.setElementComplexTypeInfo(complexTypeInfo2.templateElementIndex, complexTypeInfo2);
        n = this.fStringPool.addSymbol(string6);
        return n;
    }

    private void traverseSimpleContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n2;
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        complexTypeInfo.contentType = 4;
        complexTypeInfo.contentSpecHandle = -1;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        String string3 = element2.getLocalName();
        if (string3.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string3.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the simpleContent element is invalid.  The content must be RESTRICTION or EXTENSION");
        }
        String string4 = element2.getAttribute("base");
        String string5 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string4.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string4);
        this.processBaseTypeInfo(qName, complexTypeInfo);
        if (complexTypeInfo.baseComplexTypeInfo != null && complexTypeInfo.baseComplexTypeInfo.contentSpecHandle > -1) {
            throw new ComplexTypeRecoverableError("The type '" + string4 + "' specified as the " + "base in the simpleContent element must not have complexContent");
        }
        Element element4 = null;
        if (complexTypeInfo.derivedBy == 2) {
            if (complexTypeInfo.baseDataTypeValidator != null) {
                throw new ComplexTypeRecoverableError("The type '" + string4 + "' is a simple type.  It cannot be used in a " + "derivation by RESTRICTION for a complexType");
            }
            complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
            if (element3.getLocalName().equals("simpleType")) {
                n2 = this.traverseSimpleTypeDecl(element3);
                if (n2 != -1) {
                    complexTypeInfo.baseDataTypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n2));
                    element3 = XUtil.getNextSiblingElement(element3);
                } else {
                    throw new ComplexTypeRecoverableError();
                }
            }
            n2 = 0;
            int n3 = 0;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Vector<String> vector = new Vector<String>();
            Element element5 = element3;
            while (element5 != null && (element5.getLocalName().equals("minExclusive") || element5.getLocalName().equals("minInclusive") || element5.getLocalName().equals("maxExclusive") || element5.getLocalName().equals("maxInclusive") || element5.getLocalName().equals("precision") || element5.getLocalName().equals("scale") || element5.getLocalName().equals("length") || element5.getLocalName().equals("minLength") || element5.getLocalName().equals("maxLength") || element5.getLocalName().equals("encoding") || element5.getLocalName().equals("period") || element5.getLocalName().equals("duration") || element5.getLocalName().equals("enumeration") || element5.getLocalName().equals("pattern") || element5.getLocalName().equals("annotation"))) {
                if (element5.getNodeType() == 1) {
                    Element element6 = element5;
                    ++n3;
                    if (element6.getLocalName().equals("enumeration")) {
                        ++n2;
                        vector.addElement(element6.getAttribute("value"));
                        Element element7 = XUtil.getFirstChildElement(element6);
                        if (element7 != null && element7.getLocalName().equals("annotation")) {
                            this.traverseAnnotationDecl(element5);
                        }
                    } else {
                        hashtable.put(element6.getLocalName(), element6.getAttribute("value"));
                    }
                }
                element5 = XUtil.getNextSiblingElement(element5);
            }
            if (n2 > 0) {
                hashtable.put("enumeration", vector);
            }
            complexTypeInfo.datatypeValidator = n3 > 0 ? this.fDatatypeRegistry.createDatatypeValidator(string, complexTypeInfo.baseDataTypeValidator, hashtable, false) : complexTypeInfo.baseDataTypeValidator;
            if (element5 != null) {
                if (!this.isAttrOrAttrGroup(element5)) {
                    throw new ComplexTypeRecoverableError("Invalid child in the RESTRICTION element of simpleContent");
                }
                element4 = element5;
            }
        } else {
            if (complexTypeInfo.baseComplexTypeInfo != null) {
                complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
            }
            complexTypeInfo.datatypeValidator = complexTypeInfo.baseDataTypeValidator;
            if (element3 != null) {
                if (!this.isAttrOrAttrGroup(element3)) {
                    throw new ComplexTypeRecoverableError("Only annotations and attributes are allowed in the content of an EXTENSION element for a complexType");
                }
                element4 = element3;
            }
        }
        n2 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == -1 ? -1 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        this.processAttributes(element4, qName, complexTypeInfo);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void traverseComplexContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        String string3 = element.getAttribute("mixed");
        boolean bl2 = bl;
        if (string3.equals("true")) {
            bl2 = true;
        } else if (string3.equals("false")) {
            bl2 = false;
        }
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.baseDataTypeValidator = null;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        String string4 = element2.getLocalName();
        if (string4.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string4.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the complexContent element is invalid. The content must be RESTRICTION or EXTENSION");
        }
        String string5 = element2.getAttribute("base");
        String string6 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string5.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string5);
        String string7 = this.fStringPool.toString(qName.uri);
        String string8 = this.fStringPool.toString(qName.localpart);
        if (!string7.equals("http://www.w3.org/2000/10/XMLSchema") || !string8.equals("anyType")) {
            this.processBaseTypeInfo(qName, complexTypeInfo);
            if (complexTypeInfo.baseComplexTypeInfo == null) {
                throw new ComplexTypeRecoverableError("The base type specified in the complexContent element must be a complexType");
            }
        }
        this.processComplexContent(n, element3, complexTypeInfo, qName, bl2);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void handleComplexTypeError(String string, int n, ComplexTypeInfo complexTypeInfo) throws Exception {
        String string2 = this.fStringPool.toString(n);
        if (string != null) {
            if (string2.startsWith("#")) {
                this.reportGenericSchemaError("Anonymous complexType: " + string);
            } else {
                this.reportGenericSchemaError("ComplexType '" + string2 + "': " + string);
            }
        }
        complexTypeInfo.contentType = 1;
        complexTypeInfo.contentSpecHandle = -1;
        complexTypeInfo.derivedBy = 0;
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.attlistHead = -1;
        int n2 = this.fStringPool.addSymbol("$" + string2);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == -1 ? -1 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
    }

    private QName parseBase(String string) throws Exception {
        String string2 = "";
        String string3 = string;
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        int n2 = this.fStringPool.addSymbol(string);
        int n3 = this.fStringPool.addSymbol(string2);
        int n4 = this.fStringPool.addSymbol(string3);
        int n5 = this.fStringPool.addSymbol(this.resolvePrefixToURI(string2));
        return new QName(n3, n4, n2, n5);
    }

    private boolean baseFromAnotherSchema(QName qName) throws Exception {
        String string = this.fStringPool.toString(qName.uri);
        return !string.equals(this.fTargetNSURIString) && !string.equals("http://www.w3.org/2000/10/XMLSchema") && string.length() != 0;
    }

    private void processBaseTypeInfo(QName qName, ComplexTypeInfo complexTypeInfo) throws Exception {
        ComplexTypeInfo complexTypeInfo2 = null;
        DatatypeValidator datatypeValidator = null;
        String string = this.fStringPool.toString(qName.uri);
        String string2 = this.fStringPool.toString(qName.localpart);
        String string3 = this.fStringPool.toString(qName.rawname);
        if (this.baseFromAnotherSchema(qName)) {
            complexTypeInfo2 = this.getTypeInfoFromNS(string, string2);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string, string2)) == null) {
                throw new ComplexTypeRecoverableError("Could not find base type " + string2 + " in schema " + string);
            }
        } else {
            String string4 = string + "," + string2;
            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string4);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string, string2)) == null) {
                Element element = this.getTopLevelComponentByName("complexType", string2);
                if (element != null) {
                    int n = this.traverseComplexTypeDecl(element);
                    complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n));
                } else {
                    element = this.getTopLevelComponentByName("simpleType", string2);
                    if (element != null) {
                        int n = this.traverseSimpleTypeDecl(element);
                        datatypeValidator = this.getDatatypeValidator(string, string2);
                        if (datatypeValidator == null) {
                            // empty if block
                        }
                    } else {
                        throw new ComplexTypeRecoverableError("Base type could not be found : " + string3);
                    }
                }
            }
        }
        complexTypeInfo.baseComplexTypeInfo = complexTypeInfo2;
        complexTypeInfo.baseDataTypeValidator = datatypeValidator;
    }

    private void processComplexContent(int n, Element element, ComplexTypeInfo complexTypeInfo, QName qName, boolean bl) throws Exception {
        Element element2 = null;
        int n2 = -2;
        if (element != null) {
            String string = element.getLocalName();
            if (string.equals("group")) {
                n2 = this.expandContentModel(this.traverseGroupDecl(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("sequence")) {
                n2 = this.expandContentModel(this.traverseSequence(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("choice")) {
                n2 = this.expandContentModel(this.traverseChoice(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("all")) {
                n2 = this.expandContentModel(this.traverseAll(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (this.isAttrOrAttrGroup(element)) {
                complexTypeInfo.contentType = 1;
                element2 = element;
            } else {
                throw new ComplexTypeRecoverableError("Invalid child '" + string + "' in the complex type");
            }
        }
        if (bl) {
            int n3 = this.fSchemaGrammar.addContentSpecNode(0, -1, -1, false);
            n2 = n2 != -2 ? this.fSchemaGrammar.addContentSpecNode(4, n3, n2, false) : n3;
        }
        complexTypeInfo.contentSpecHandle = n2;
        if (complexTypeInfo.baseComplexTypeInfo != null) {
            int n4 = complexTypeInfo.baseComplexTypeInfo.contentSpecHandle;
            if (complexTypeInfo.derivedBy != 2) {
                if (this.baseFromAnotherSchema(qName)) {
                    String string = this.fStringPool.toString(qName.uri);
                    SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
                    n4 = this.importContentSpec(schemaGrammar, n4);
                }
                if (complexTypeInfo.contentSpecHandle == -2) {
                    complexTypeInfo.contentSpecHandle = n4;
                } else if (n4 > -1) {
                    complexTypeInfo.contentSpecHandle = this.fSchemaGrammar.addContentSpecNode(5, n4, complexTypeInfo.contentSpecHandle, false);
                }
            }
        } else {
            complexTypeInfo.derivedBy = 0;
        }
        complexTypeInfo.contentType = bl ? 2 : (complexTypeInfo.contentSpecHandle == -2 ? 0 : 3);
        String string = this.fStringPool.toString(n);
        int n5 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n5, n, this.fTargetNSURI), this.fTargetNSURI == -1 ? -1 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("Invalid child " + element2.getLocalName() + " in the complexType or complexContent");
            }
            this.processAttributes(element2, qName, complexTypeInfo);
        } else if (complexTypeInfo.baseComplexTypeInfo != null) {
            this.processAttributes(null, qName, complexTypeInfo);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processAttributes(Element var1_1, QName var2_2, ComplexTypeInfo var3_3) throws Exception {
        block19: {
            var4_4 = null;
            var5_5 = new Vector<E>();
            var6_6 = var1_1;
            while (var6_6 != null) {
                var7_7 = var6_6.getLocalName();
                if (var7_7.equals("attribute")) {
                    this.traverseAttributeDecl(var6_6, var3_3, false);
                } else if (var7_7.equals("attributeGroup")) {
                    this.traverseAttributeGroupDecl(var6_6, var3_3, var5_5);
                } else if (var7_7.equals("anyAttribute")) {
                    var4_4 = this.traverseAnyAttribute(var6_6);
                }
                var6_6 = XUtil.getNextSiblingElement(var6_6);
            }
            if (var4_4 != null) {
                var7_7 = null;
                var8_8 = var5_5.size();
                if (var8_8 > 0) {
                    var7_7 = (XMLAttributeDecl)var5_5.elementAt(0);
                    var9_10 = 1;
                    while (var9_10 < var8_8) {
                        var7_7 = this.mergeTwoAnyAttribute((XMLAttributeDecl)var7_7, (XMLAttributeDecl)var5_5.elementAt(var9_10));
                        ++var9_10;
                    }
                }
                if (var7_7 != null) {
                    var9_10 = var4_4.defaultType;
                    var4_4 = this.mergeTwoAnyAttribute(var4_4, (XMLAttributeDecl)var7_7);
                    var4_4.defaultType = var9_10;
                }
            }
            var7_7 = null;
            var8_9 = var3_3.baseComplexTypeInfo;
            if (var8_9 == null || var8_9.attlistHead <= -1) break block19;
            var9_10 = var8_9.attlistHead;
            var10_11 = this.fSchemaGrammar;
            v0 = var11_12 = this.baseFromAnotherSchema(var2_2) != false ? this.fStringPool.toString(var2_2.uri) : null;
            if (var11_12 != null) {
                var10_11 = (SchemaGrammar)this.fGrammarResolver.getGrammar(var11_12);
            }
            if (var10_11 != null) ** GOTO lbl56
            break block19;
lbl-1000:
            // 1 sources

            {
                this.fTempAttributeDecl.clear();
                var10_11.getAttributeDecl(var9_10, this.fTempAttributeDecl);
                if (this.fTempAttributeDecl.type == 8 || this.fTempAttributeDecl.type == 11 || this.fTempAttributeDecl.type == 10 || this.fTempAttributeDecl.type == 9) {
                    if (var4_4 == null) {
                        var7_7 = this.fTempAttributeDecl;
                    }
                    var9_10 = var10_11.getNextAttributeDeclIndex(var9_10);
                    continue;
                }
                var12_13 = this.fSchemaGrammar.getAttributeDeclIndex(var3_3.templateElementIndex, this.fTempAttributeDecl.name);
                if (var12_13 > -1 && var3_3.derivedBy == 2) {
                    var9_10 = this.fSchemaGrammar.getNextAttributeDeclIndex(var9_10);
                    continue;
                }
                this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, this.fTempAttributeDecl.enumeration, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator, this.fTempAttributeDecl.list);
                var9_10 = var10_11.getNextAttributeDeclIndex(var9_10);
lbl56:
                // 4 sources

                ** while (var9_10 > -1)
            }
        }
        if (var4_4 != null) {
            if (var4_4.type != -1) {
                this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, var4_4.name, var4_4.type, var4_4.enumeration, var4_4.defaultType, var4_4.defaultValue, var4_4.datatypeValidator, var4_4.list);
            }
        } else if (var7_7 != null) {
            this.fSchemaGrammar.addAttDef(var3_3.templateElementIndex, var7_7.name, var7_7.type, var7_7.enumeration, var7_7.defaultType, var7_7.defaultValue, var7_7.datatypeValidator, var7_7.list);
        }
        var3_3.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(var3_3.templateElementIndex);
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = element.getLocalName();
        return string.equals("attribute") || string.equals("attributeGroup") || string.equals("anyAttribute");
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            Enumeration enumeration = this.fElementRecurseComplex.keys();
            while (enumeration.hasMoreElements()) {
                QName qName = (QName)enumeration.nextElement();
                String string = (String)this.fElementRecurseComplex.get(qName);
                int n = qName.uri;
                int n2 = qName.localpart;
                int n3 = qName.prefix;
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fTargetNSURIString + "," + string);
                if (complexTypeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                int n4 = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n2, n), n3, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, complexTypeInfo.attlistHead, complexTypeInfo.datatypeValidator);
                this.fSchemaGrammar.setElementComplexTypeInfo(n4, complexTypeInfo);
            }
            this.fElementRecurseComplex.clear();
        }
    }

    private void checkParticleDerivationOK(Element element, Element element2) {
    }

    private int importContentSpec(SchemaGrammar schemaGrammar, int n) throws Exception {
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        schemaGrammar.getContentSpec(n, xMLContentSpec);
        int n2 = -1;
        int n3 = -1;
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        n2 = xMLContentSpec.value == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.value);
        n3 = xMLContentSpec.otherValue == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.otherValue);
        return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, n2, n3, false);
    }

    private int expandContentModel(int n, Element element) throws Exception {
        block22: {
            String string = element.getAttribute("minOccurs").trim();
            String string2 = element.getAttribute("maxOccurs").trim();
            int n2 = 1;
            int n3 = 1;
            if (string.equals("0") && string2.equals("0")) {
                return -2;
            }
            if (string.equals("")) {
                string = "1";
            }
            if (string2.equals("")) {
                string2 = "1";
            }
            int n4 = n;
            if (string.equals("1") && string2.equals("1")) break block22;
            if (string.equals("0") && string2.equals("1")) {
                n = this.fSchemaGrammar.addContentSpecNode(1, n, -1, false);
            } else if (string.equals("0") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(2, n, -1, false);
            } else if (string.equals("1") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
            } else if (string2.equals("unbounded")) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs : '" + exception.getMessage() + "' "});
                }
                if (n2 < 2) {
                    // empty if block
                }
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
                int n5 = 0;
                while (n5 < n2 - 1) {
                    n = this.fSchemaGrammar.addContentSpecNode(5, n4, n, false);
                    ++n5;
                }
            } else {
                try {
                    n2 = Integer.parseInt(string);
                    n3 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
                }
                if (n2 == 0) {
                    int n6;
                    n = n6 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n7 = 0;
                    while (n7 < n3 - n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n6, false);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n4, false);
                        ++n8;
                    }
                    int n9 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n10 = 0;
                    while (n10 < n3 - n2) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n9, false);
                        ++n10;
                    }
                }
            }
        }
        return n;
    }

    private int traverseAttributeDecl(Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        String string;
        int n;
        String string2 = element.getAttribute("name");
        int n2 = this.fStringPool.addSymbol(string2);
        String string3 = element.getAttribute("form");
        boolean bl2 = this.isTopLevel(element);
        DatatypeValidator datatypeValidator = null;
        int n3 = -1;
        boolean bl3 = false;
        int n4 = -1;
        String string4 = element.getAttribute("ref");
        String string5 = element.getAttribute("type");
        if (!string4.equals("")) {
            if (bl2) {
                this.reportGenericSchemaError("An attribute with \"ref\" present must not have <schema> as its parent");
            }
            if (!string2.equals("")) {
                this.reportGenericSchemaError("Attribute " + string2 + " cannot refer to another attribute, but it refers to " + string4);
            }
            if (!string5.equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a type");
            }
            if (!element.getAttribute("form").equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a \"form\" property");
            }
            if (!element.getAttribute("value").equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a value");
            }
        }
        Element element2 = this.findAttributeSimpleType(element);
        String string6 = null;
        String string7 = element.getAttribute("use");
        boolean bl4 = string7.equals("prohibited");
        boolean bl5 = string7.equals("required");
        if (!string4.equals("")) {
            String string8;
            String string9 = "";
            string6 = string4;
            int n5 = string4.indexOf(":");
            if (n5 > 0) {
                string9 = string4.substring(0, n5);
                string6 = string4.substring(n5 + 1);
            }
            if (!(string8 = this.resolvePrefixToURI(string9)).equals(this.fTargetNSURIString)) {
                this.addAttributeDeclFromAnotherSchema(string6, string8, complexTypeInfo);
                return -1;
            }
            Element element3 = this.getTopLevelComponentByName("attribute", string6);
            if (element3 != null) {
                this.traverseAttributeDecl(element3, complexTypeInfo, true);
                int n6 = this.fStringPool.addSymbol(element3.getAttribute("name"));
                int n7 = -1;
                if (this.fTargetNSURIString.length() > 0) {
                    n7 = this.fTargetNSURI;
                }
                QName qName = new QName(-1, n6, n6, n7);
                if (bl4) {
                    int n8 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName);
                    XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                    this.fSchemaGrammar.getAttributeDecl(n8, xMLAttributeDecl);
                    xMLAttributeDecl.defaultType = 7;
                    this.fSchemaGrammar.setAttributeDecl(complexTypeInfo.templateElementIndex, n8, xMLAttributeDecl);
                } else if (bl5) {
                    int n9 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName);
                    XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                    this.fSchemaGrammar.getAttributeDecl(n9, xMLAttributeDecl);
                    xMLAttributeDecl.defaultType = xMLAttributeDecl.defaultType == 1 ? 8 : 2;
                    this.fSchemaGrammar.setAttributeDecl(complexTypeInfo.templateElementIndex, n9, xMLAttributeDecl);
                }
            } else if (this.fAttributeDeclRegistry.get(string6) != null) {
                this.addAttributeDeclFromAnotherSchema(string6, string8, complexTypeInfo);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attribute " + string4);
            }
            return -1;
        }
        if (string5.equals("")) {
            if (element2 != null) {
                n3 = 7;
                n4 = this.traverseSimpleTypeDecl(element2);
                string6 = this.fStringPool.toString(n4);
            } else {
                n3 = 7;
                string6 = "string";
                n4 = this.fStringPool.addSymbol(string6);
            }
            string6 = this.fStringPool.toString(n4);
            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string6);
        } else {
            Element element4;
            if (element2 != null && !bl) {
                this.reportGenericSchemaError("Attribute declarations may not contain both a type and a simpleType declaration");
            }
            String string10 = "";
            string6 = string5;
            n4 = this.fStringPool.addSymbol(string6);
            n = string5.indexOf(":");
            if (n > 0) {
                string10 = string5.substring(0, n);
                string6 = string5.substring(n + 1);
            }
            if ((string = this.resolvePrefixToURI(string10)).equals("http://www.w3.org/2000/10/XMLSchema") || string.length() == 0) {
                datatypeValidator = this.getDatatypeValidator("", string6);
                if (string6.equals("ID")) {
                    n3 = 3;
                } else if (string6.equals("IDREF")) {
                    n3 = 4;
                } else if (string6.equals("IDREFS")) {
                    n3 = 4;
                    bl3 = true;
                } else if (string6.equals("ENTITY")) {
                    n3 = 1;
                } else if (string6.equals("ENTITIES")) {
                    n3 = 1;
                    bl3 = true;
                } else if (string6.equals("NMTOKEN")) {
                    n3 = 5;
                } else if (string6.equals("NMTOKENS")) {
                    n3 = 5;
                    bl3 = true;
                } else if (string6.equals("notation")) {
                    n3 = 6;
                } else {
                    n3 = 7;
                    if (datatypeValidator == null && string.length() == 0) {
                        element4 = this.getTopLevelComponentByName("simpleType", string6);
                        if (element4 != null) {
                            this.traverseSimpleTypeDecl(element4);
                            datatypeValidator = this.getDatatypeValidator(string, string6);
                        } else if (!bl) {
                            this.reportGenericSchemaError("simpleType not found : (" + string + ":" + string6 + ")");
                        }
                    }
                }
            } else {
                datatypeValidator = this.getDatatypeValidator(string, string6);
                if (datatypeValidator == null && string.equals(this.fTargetNSURIString)) {
                    element4 = this.getTopLevelComponentByName("simpleType", string6);
                    if (element4 != null) {
                        this.traverseSimpleTypeDecl(element4);
                        datatypeValidator = this.getDatatypeValidator(string, string6);
                    } else if (!bl) {
                        this.reportGenericSchemaError("simpleType not found : (" + string + ":" + string6 + ")");
                    }
                }
                n3 = 7;
            }
        }
        int n10 = -1;
        n = -1;
        if (datatypeValidator == null && !bl) {
            this.reportGenericSchemaError("could not resolve the type or get a null validator for datatype : " + this.fStringPool.toString(n4));
        }
        string = element.getAttribute("value");
        if (bl2) {
            if (!string.equals("")) {
                if ((bl5 || bl4 || string7.equals("optional")) && !bl) {
                    this.reportGenericSchemaError("Globally-declared attributes containing values must have \"use\" set to \"FIXED\" or \"DEFAULT\", not " + string7);
                } else if (string7.equals("") && !bl) {
                    this.reportGenericSchemaError("Globally-declared attributes containing values MUST have \"use\" present and set to \"FIXED\" or \"DEFAULT\"");
                } else if (string7.equals("fixed")) {
                    n10 = 1;
                    n = this.fStringPool.addString(string);
                } else {
                    n10 = 3;
                    n = this.fStringPool.addString(string);
                }
            } else if (!string7.equals("") && !bl) {
                this.reportGenericSchemaError("Globally-declared attributes containing no value may not have \"use\" present");
            } else {
                n10 = 0;
            }
        } else if (!string.equals("")) {
            if (bl5 || bl4 || string7.equals("optional")) {
                this.reportGenericSchemaError("Locally-declared attributes containing values must have \"use\" set to \"FIXED\" or \"DEFAULT\", not " + string7);
            } else if (string7.equals("")) {
                this.reportGenericSchemaError("Locally-declared attributes containing values MUST have \"use\" present and set to \"FIXED\" or \"DEFAULT\"");
            } else if (string7.equals("fixed")) {
                n10 = 1;
                n = this.fStringPool.addString(string);
            } else {
                n10 = 3;
                n = this.fStringPool.addString(string);
            }
        } else {
            n10 = bl5 ? 2 : (bl4 ? 7 : 0);
        }
        if (n3 == 7 && n != -1) {
            try {
                if (datatypeValidator != null) {
                    datatypeValidator.validate(this.fStringPool.toString(n), null);
                } else if (!bl) {
                    this.reportSchemaError(2, new Object[]{string5});
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                if (!bl) {
                    this.reportSchemaError(18, new Object[]{element.getAttribute("name"), invalidDatatypeValueException.getMessage()});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Internal error in attribute datatype validation");
            }
        }
        int n11 = -1;
        if (this.fTargetNSURIString.length() > 0) {
            if (bl2) {
                n11 = this.fTargetNSURI;
            } else if (!string3.equals("unqualified") && (string3.equals("qualified") || this.fAttributeDefaultQualified)) {
                n11 = this.fTargetNSURI;
            }
        }
        QName qName = new QName(-1, n2, n2, n11);
        if (DEBUGGING) {
            System.out.println(" the dataType Validator for " + this.fStringPool.toString(n2) + " is " + datatypeValidator);
        }
        if (bl2) {
            this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
            this.fTempAttributeDecl.name.setValues(qName);
            this.fTempAttributeDecl.type = n3;
            this.fTempAttributeDecl.defaultType = n10;
            this.fTempAttributeDecl.list = bl3;
            if (n != -1) {
                this.fTempAttributeDecl.defaultValue = new String(this.fStringPool.toString(n));
            }
            this.fAttributeDeclRegistry.put(string2, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, qName, n3, n4, n10, this.fStringPool.toString(n), datatypeValidator, bl3);
        }
        return -1;
    }

    private int addAttributeDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #addAttributeDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
        if (hashtable == null) {
            this.reportGenericSchemaError("no attribute was defined in schema : " + string2);
            return -1;
        }
        XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string);
        if (xMLAttributeDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, -1, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator, xMLAttributeDecl.list);
        }
        return 0;
    }

    private int traverseAttributeGroupDecl(Element element, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        int n = this.fStringPool.addSymbol(element.getAttribute("name"));
        String string = element.getAttribute("ref");
        int n2 = -1;
        int n3 = -1;
        if (!string.equals("")) {
            String string2;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string;
            int n4 = string.indexOf(":");
            if (n4 > 0) {
                string3 = string.substring(0, n4);
                string4 = string.substring(n4 + 1);
            }
            if (!(string2 = this.resolvePrefixToURI(string3)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(string4, string2, complexTypeInfo, vector);
                return -1;
            }
            Element element2 = this.getTopLevelComponentByName("attributeGroup", string4);
            if (element2 != null) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attributegroup " + string);
            }
            return -1;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null) {
            if (element3.getLocalName().equals("attribute")) {
                this.traverseAttributeDecl(element3, complexTypeInfo, false);
            } else if (element3.getLocalName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element3, complexTypeInfo, vector);
            } else {
                if (element3.getLocalName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element3));
                    break;
                }
                if (element3.getLocalName().equals("annotation")) {
                    // empty if block
                }
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseAttributeGroupDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelAttrGrpDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no attribute group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        int n2 = -1;
        int n3 = -1;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            if (element2.getLocalName().equals("attribute")) {
                String string3 = element2.getAttribute("name");
                if (string3.length() > 0) {
                    Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
                    if (hashtable != null && hashtable.get(string3) != null) {
                        this.addAttributeDeclFromAnotherSchema(string3, string2, complexTypeInfo);
                        return -1;
                    }
                } else {
                    this.traverseAttributeDecl(element2, complexTypeInfo, false);
                }
            } else if (element2.getLocalName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                if (element2.getLocalName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                    break;
                }
                if (element2.getLocalName().equals("annotation")) {
                    // empty if block
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return -1;
    }

    private Element findAttributeSimpleType(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        if (element2 == null) {
            return null;
        }
        if (element2.getLocalName().equals("simpleType")) {
            return element2;
        }
        if (element2.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element2);
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (element2 == null) {
            return null;
        }
        if (element2.getLocalName().equals("simpleType") && XUtil.getNextSiblingElement(element2) == null) {
            return element2;
        }
        this.reportGenericSchemaError("An attribute declaration must contain at most one annotation preceding at most one simpleType");
        return null;
    }

    private QName traverseElementDecl(Element element) throws Exception {
        Object object;
        int n;
        int n2;
        String string;
        int n3;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -2;
        DatatypeValidator datatypeValidator = null;
        String string2 = element.getAttribute("name");
        if (DEBUGGING) {
            System.out.println("traversing element decl : " + string2);
        }
        String string3 = element.getAttribute("ref");
        String string4 = element.getAttribute("type");
        String string5 = element.getAttribute("minOccurs");
        String string6 = element.getAttribute("maxOccurs");
        String string7 = element.getAttribute("default");
        String string8 = element.getAttribute("fixed");
        if (!string7.equals("") && !string8.equals("")) {
            this.reportGenericSchemaError("an element cannot have both \"fixed\" and \"default\" present at the same time");
        }
        String string9 = element.getAttribute("substitutionGroup");
        String string10 = element.getAttribute("form");
        String string11 = null;
        if (this.isTopLevel(element)) {
            if (string2.equals("")) {
                this.reportGenericSchemaError("globally-declared element must have a name");
            } else if (!string3.equals("")) {
                this.reportGenericSchemaError("globally-declared element " + string2 + " cannot have a ref attribute");
            }
            n4 = this.fStringPool.addSymbol(string2);
            n3 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, n4, -1);
            if (n3 > -1) {
                return new QName(-1, n4, n4, this.fTargetNSURI);
            }
        }
        n4 = this.parseBlockSet(element.getAttribute("block"));
        n3 = this.parseFinalSet(element.getAttribute("final"));
        boolean bl = element.getAttribute("nullable").equals("true");
        boolean bl2 = element.getAttribute("abstract").equals("true");
        int n9 = 0;
        if (bl) {
            ++n9;
        }
        if (bl2) {
            n9 += 2;
        }
        if (!string3.equals("")) {
            Element element2;
            Element element3;
            if (!(string4.equals("") && n9 <= 0 && n3 <= 0 && n4 <= 0 && string7.equals("") && string8.equals(""))) {
                this.reportSchemaError(16, null);
            }
            if (!string2.equals("")) {
                this.reportGenericSchemaError("element " + string2 + " cannot also have a ref attribute");
            }
            if ((element3 = XUtil.getFirstChildElement(element)) != null && element3.getLocalName().equals("annotation")) {
                if (XUtil.getNextSiblingElement(element3) != null) {
                    this.reportSchemaError(17, null);
                } else {
                    this.traverseAnnotationDecl(element3);
                }
            } else if (element3 != null) {
                this.reportSchemaError(17, null);
            }
            String string12 = "";
            String string13 = string3;
            int n10 = string3.indexOf(":");
            if (n10 > 0) {
                string12 = string3.substring(0, n10);
                string13 = string3.substring(n10 + 1);
            }
            int n11 = this.fStringPool.addSymbol(string13);
            String string14 = this.resolvePrefixToURI(string12);
            QName qName = new QName(string12 != null ? this.fStringPool.addSymbol(string12) : -1, n11, this.fStringPool.addSymbol(string3), string14 != null ? this.fStringPool.addSymbol(string14) : -1);
            if (!string14.equals(this.fTargetNSURIString)) {
                return qName;
            }
            int n12 = this.fSchemaGrammar.getElementDeclIndex(qName, -1);
            if (n12 == -1 && (element2 = this.getTopLevelComponentByName("element", string13)) == null) {
                this.reportGenericSchemaError("Element " + string13 + " not found in the Schema");
                return qName;
            }
            return qName;
        }
        Element element4 = null;
        int n13 = -1;
        boolean bl3 = true;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        ComplexTypeInfo complexTypeInfo = null;
        DatatypeValidator datatypeValidator2 = null;
        if (string9.length() > 0) {
            string15 = this.resolvePrefixToURI(this.getPrefix(string9));
            string16 = this.getLocalPart(string9);
            string17 = string15 + "," + string16;
            if (!string15.equals(this.fTargetNSURIString)) {
                complexTypeInfo = this.getElementDeclTypeInfoFromNS(string15, string16);
                if (complexTypeInfo == null && (datatypeValidator2 = this.getElementDeclTypeValidatorFromNS(string15, string16)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type for element '" + string16 + "' in schema '" + string15 + "'");
                }
            } else {
                element4 = this.getTopLevelComponentByName("element", string16);
                if (element4 == null) {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string9), -1);
                    if (n13 == -1) {
                        bl3 = false;
                        this.reportGenericSchemaError("substitutionGroup affiliation element " + string9 + " in element declaration " + string2);
                    }
                } else {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string9), -1);
                    if (n13 == -1) {
                        this.traverseElementDecl(element4);
                        n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string9), -1);
                    }
                }
                if (n13 != -1 && (complexTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(n13)) == null) {
                    this.fSchemaGrammar.getElementDecl(n13, this.fTempElementDecl);
                    datatypeValidator2 = this.fTempElementDecl.datatypeValidator;
                    if (datatypeValidator2 == null) {
                        bl3 = false;
                        this.reportGenericSchemaError("Could not find type for element '" + string16 + "' in schema '" + string15 + "'");
                    }
                }
            }
        }
        ComplexTypeInfo complexTypeInfo2 = null;
        Element element5 = XUtil.getFirstChildElement(element);
        if (element5 != null && element5.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element5);
            element5 = XUtil.getNextSiblingElement(element5);
        }
        if (element5 != null && element5.getLocalName().equals("annotation")) {
            this.reportGenericSchemaError("element declarations can contain at most one annotation Element Information Item");
        }
        boolean bl4 = false;
        if (element5 != null) {
            string = element5.getLocalName();
            if (string.equals("complexType")) {
                if (element5.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous complexType in element '" + string2 + "' has a name attribute");
                } else {
                    n7 = this.traverseComplexTypeDecl(element5);
                }
                if (n7 != -1) {
                    complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse complexType error in element '" + string2 + "'");
                }
                bl4 = true;
                element5 = XUtil.getNextSiblingElement(element5);
            } else if (string.equals("simpleType")) {
                if (element5.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous simpleType in element '" + string2 + "' has a name attribute");
                } else {
                    n7 = this.traverseSimpleTypeDecl(element5);
                }
                if (n7 != -1) {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n7));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse simpleType error in element '" + string2 + "'");
                }
                n5 = 4;
                bl4 = true;
                element5 = XUtil.getNextSiblingElement(element5);
            } else if (string4.equals("")) {
                n5 = 1;
                n6 = -1;
            }
            if (element5 != null) {
                string = element5.getLocalName();
            }
            while (element5 != null && (string.equals("key") || string.equals("keyref") || string.equals("unique"))) {
                if ((element5 = XUtil.getNextSiblingElement(element5)) == null) continue;
                string = element5.getLocalName();
            }
            if (element5 != null) {
                bl3 = false;
                this.reportGenericSchemaError("only annotation, simpleType, complexType, key, keyref and unique Element Information Items are allowed in element declarations");
            }
        }
        if (bl4 && string4.length() > 0) {
            bl3 = false;
            this.reportGenericSchemaError("Element '" + string2 + "' have both a type attribute and a annoymous type child");
        } else if (!string4.equals("")) {
            String string18;
            if (element4 != null) {
                this.checkSubstitutionGroupOK(element, element4);
            }
            string = "";
            String string19 = string4;
            n2 = string4.indexOf(":");
            if (n2 > 0) {
                string = string4.substring(0, n2);
                string19 = string4.substring(n2 + 1);
            }
            if (!(string18 = this.resolvePrefixToURI(string)).equals(this.fTargetNSURIString) && !string18.equals("http://www.w3.org/2000/10/XMLSchema") && string18.length() != 0) {
                string11 = string18;
                complexTypeInfo2 = this.getTypeInfoFromNS(string18, string19);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string18, string19)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type " + string19 + " in schema " + string18);
                }
            } else {
                complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string18 + "," + string19);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string18, string19)) == null) {
                    if (string18.equals("http://www.w3.org/2000/10/XMLSchema") && !this.fTargetNSURIString.equals("http://www.w3.org/2000/10/XMLSchema")) {
                        bl3 = false;
                        this.reportGenericSchemaError("type not found : " + string18 + ":" + string19);
                    } else {
                        Element element6 = this.getTopLevelComponentByName("complexType", string19);
                        if (element6 != null) {
                            if (this.fCurrentTypeNameStack.search(string19) > -1) {
                                int n14 = -1;
                                if (string10.equals("qualified") || this.fElementDefaultQualified) {
                                    n14 = this.fTargetNSURI;
                                }
                                int n15 = this.fStringPool.addSymbol(string2);
                                QName qName = new QName(this.fCurrentScope, n15, n15, n14);
                                this.fElementRecurseComplex.put(qName, string19);
                                return new QName(-1, n15, n15, n14);
                            }
                            n7 = this.traverseComplexTypeDecl(element6);
                            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                        } else {
                            element6 = this.getTopLevelComponentByName("simpleType", string19);
                            if (element6 != null) {
                                n7 = this.traverseSimpleTypeDecl(element6);
                                datatypeValidator = this.getDatatypeValidator(string18, string19);
                            } else {
                                bl3 = false;
                                this.reportGenericSchemaError("type not found : " + string18 + ":" + string19);
                            }
                        }
                    }
                }
            }
        } else if (bl4) {
            if (element4 != null) {
                this.checkSubstitutionGroupOK(element, element4);
            }
        } else {
            if (complexTypeInfo2 == null && datatypeValidator == null) {
                complexTypeInfo2 = complexTypeInfo;
            }
            if (complexTypeInfo2 == null && datatypeValidator == null) {
                datatypeValidator = datatypeValidator2;
            }
        }
        if (complexTypeInfo2 == null && datatypeValidator == null) {
            if (bl3) {
                n5 = 1;
            } else {
                bl3 = false;
                this.reportGenericSchemaError("untyped element : " + string2);
            }
        }
        if (complexTypeInfo2 != null) {
            n6 = complexTypeInfo2.contentSpecHandle;
            n5 = complexTypeInfo2.contentType;
            n8 = complexTypeInfo2.scopeDefined;
            datatypeValidator = complexTypeInfo2.datatypeValidator;
        }
        if (datatypeValidator != null) {
            n5 = 4;
            if (complexTypeInfo2 == null) {
                string11 = null;
            }
        }
        int n16 = n = this.fStringPool.addSymbol(string2);
        n2 = -1;
        int n17 = this.fCurrentScope;
        if (this.isTopLevel(element)) {
            n2 = this.fTargetNSURI;
            n17 = -1;
        } else if (!string10.equals("unqualified") && (string10.equals("qualified") || this.fElementDefaultQualified)) {
            n2 = this.fTargetNSURI;
        }
        int n18 = this.fSchemaGrammar.getElementDeclIndex(n2, n16, n17);
        if (n18 > -1) {
            this.fSchemaGrammar.getElementDecl(n18, this.fTempElementDecl);
            object = this.fTempElementDecl.datatypeValidator;
            ComplexTypeInfo complexTypeInfo3 = this.fSchemaGrammar.getElementComplexTypeInfo(n18);
            if (complexTypeInfo3 != null && complexTypeInfo3 != complexTypeInfo2 || object != null && object != datatypeValidator) {
                bl3 = false;
                this.reportGenericSchemaError("duplicate element decl in the same scope : " + this.fStringPool.toString(n16));
            }
        }
        object = new QName(-1, n16, n, n2);
        int n19 = -1;
        if (complexTypeInfo2 != null) {
            n19 = complexTypeInfo2.attlistHead;
        }
        int n20 = this.fSchemaGrammar.addElementDecl((QName)object, n17, n8, n5, n6, n19, datatypeValidator);
        if (DEBUGGING) {
            System.out.println("########elementIndex:" + n20 + " (" + this.fStringPool.toString(((QName)object).uri) + "," + this.fStringPool.toString(((QName)object).localpart) + ")" + " eltType:" + string4 + " contentSpecType:" + n5 + " SpecNodeIndex:" + n6 + " enclosingScope: " + n17 + " scopeDefined: " + n8 + "\n");
        }
        this.fSchemaGrammar.setElementComplexTypeInfo(n20, complexTypeInfo2);
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(n20, string11);
        this.fSchemaGrammar.setElementDeclBlockSet(n20, n4);
        this.fSchemaGrammar.setElementDeclFinalSet(n20, n3);
        this.fSchemaGrammar.setElementDeclMiscFlags(n20, n9);
        this.fSchemaGrammar.setElementDeclSubstitutionGroupElementFullName(n20, string17);
        Element element7 = XUtil.getFirstChildElement((Node)element, IDENTITY_CONSTRAINTS);
        Object var42_59 = null;
        if (element7 != null) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(n20, xMLElementDecl);
            while (element7 != null) {
                String string20 = element7.getLocalName();
                if (string20.equals("key")) {
                    this.traverseKey(element7, xMLElementDecl);
                } else if (string20.equals("keyref")) {
                    this.traverseKeyRef(element7, xMLElementDecl);
                } else if (string20.equals("unique")) {
                    this.traverseUnique(element7, xMLElementDecl);
                } else {
                    throw new RuntimeException("identity constraint must be one of \"unique\", \"key\", or \"keyref\"");
                }
                this.fSchemaGrammar.setElementDecl(n20, xMLElementDecl);
                element7 = XUtil.getNextSiblingElement((Node)element7, IDENTITY_CONSTRAINTS);
            }
        }
        return object;
    }

    private void traverseUnique(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        if (DEBUG_IDENTITY_CONSTRAINTS) {
            System.out.println("<IC>: traverseUnique(\"" + element.getNodeName() + "\")");
        }
        String string = this.getElementNameFor(element);
        Unique unique = new Unique(string);
        this.traverseIdentityConstraint(unique, element);
        xMLElementDecl.unique.addElement(unique);
    }

    private void traverseKey(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string = element.getAttribute("name");
        if (DEBUG_IDENTITY_CONSTRAINTS) {
            System.out.println("<IC>: traverseKey(\"" + element.getNodeName() + "\") [" + string + ']');
        }
        String string2 = this.getElementNameFor(element);
        Key key = new Key(string2, string);
        this.traverseIdentityConstraint(key, element);
        xMLElementDecl.key.addElement(key);
    }

    private void traverseKeyRef(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string = element.getAttribute("name");
        if (DEBUG_IDENTITY_CONSTRAINTS) {
            System.out.println("<IC>: traverseKeyRef(\"" + element.getNodeName() + "\") [" + string + ']');
        }
        String string2 = this.getElementNameFor(element);
        KeyRef keyRef = new KeyRef(string2, string);
        this.traverseIdentityConstraint(keyRef, element);
        xMLElementDecl.keyRef.addElement(keyRef);
    }

    private void traverseIdentityConstraint(IdentityConstraint identityConstraint, Element element) throws Exception {
        Object object;
        Object object2;
        Element element2 = XUtil.getFirstChildElement((Node)element, "selector");
        String string = CR_IMPL ? element2.getAttribute("xpath") : XUtil.getChildText(element2);
        string = string.trim();
        try {
            object2 = new Selector.XPath(string, this.fStringPool, this.fNamespacesScope);
            object = new Selector((Selector.XPath)object2, identityConstraint);
            if (DEBUG_IDENTITY_CONSTRAINTS) {
                System.out.println("<IC>:   selector: " + object);
            }
            identityConstraint.setSelector((Selector)object);
        }
        catch (XPathException xPathException) {
            throw new SAXException(xPathException.getMessage());
        }
        object2 = XUtil.getNextSiblingElement((Node)element2, "field");
        while (object2 != null) {
            object = CR_IMPL ? object2.getAttribute("xpath") : XUtil.getChildText((Node)object2);
            object = ((String)object).trim();
            try {
                Field.XPath xPath = new Field.XPath((String)object, this.fStringPool, this.fNamespacesScope);
                Field field = new Field(xPath, null, identityConstraint);
                if (DEBUG_IDENTITY_CONSTRAINTS) {
                    System.out.println("<IC>:   field:    " + field);
                }
                identityConstraint.addField(field);
            }
            catch (XPathException xPathException) {
                throw new SAXException(xPathException.getMessage());
            }
            object2 = XUtil.getNextSiblingElement((Node)object2, "field");
        }
    }

    private String getElementNameFor(Element element) {
        Element element2 = (Element)element.getParentNode();
        String string = element2.getAttribute("name");
        if (string.length() == 0) {
            string = element2.getAttribute("ref");
        }
        return string;
    }

    int getLocalPartIndex(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getLocalPart(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    int getPrefixIndex(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getPrefix(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void checkSubstitutionGroupOK(Element element, Element element2) {
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String var1_1, String var2_2) throws Exception {
        var3_3 = null;
        if (var1_1.equals("group")) {
            var3_3 = (Element)this.fSchemaGrammar.topLevelGroupDecls.get(var2_2);
        } else if (var1_1.equals("attributeGroup")) {
            var3_3 = (Element)this.fSchemaGrammar.topLevelAttrGrpDecls.get(var2_2);
        } else if (var1_1.equals("attribute")) {
            var3_3 = (Element)this.fSchemaGrammar.topLevelAttrDecls.get(var2_2);
        }
        if (var3_3 != null) {
            return var3_3;
        }
        var3_3 = XUtil.getFirstChildElement(this.fSchemaRootElement);
        if (var3_3 != null) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            if (var3_3.getLocalName().equals(var1_1) && var3_3.getAttribute("name").equals(var2_2)) {
                return var3_3;
            }
            var3_3 = XUtil.getNextSiblingElement(var3_3);
lbl18:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl19:
        // 1 sources

        return null;
    }

    private boolean isTopLevel(Element element) {
        return element.getParentNode().getLocalName().endsWith("schema");
    }

    DatatypeValidator getTypeValidatorFromNS(String string, String string2) throws Exception {
        return this.getDatatypeValidator(string, string2);
    }

    ComplexTypeInfo getTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)schemaGrammar.getComplexTypeRegistry().get(string + "," + string2);
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getElementDeclTypeValidatorFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            DatatypeValidator datatypeValidator = null;
            if (n > -1) {
                schemaGrammar.getElementDecl(n, this.fTempElementDecl);
                datatypeValidator = this.fTempElementDecl.datatypeValidator;
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return datatypeValidator;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getELementDeclTypeValidatorFromNS");
        return null;
    }

    ComplexTypeInfo getElementDeclTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            ComplexTypeInfo complexTypeInfo = null;
            if (n > -1) {
                complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n);
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getElementDeclTypeInfoFromNS");
        return null;
    }

    private int traverseGroupDecl(Element element) throws Exception {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("ref");
        if (!string2.equals("")) {
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string2;
            int n = string2.indexOf(":");
            if (n > 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
            int n2 = this.fStringPool.addSymbol(string4);
            String string5 = this.resolvePrefixToURI(string3);
            if (!string5.equals(this.fTargetNSURIString)) {
                return this.traverseGroupDeclFromAnotherSchema(string4, string5);
            }
            int n3 = -1;
            Element element2 = this.getTopLevelComponentByName("group", string4);
            if (element2 == null) {
                this.reportGenericSchemaError("Group " + string4 + " not found in the Schema");
            } else {
                n3 = this.traverseGroupDecl(element2);
            }
            return n3;
        }
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null && element3.getLocalName().equals("annotation")) {
            element3 = XUtil.getNextSiblingElement(element3);
        }
        int n = 0;
        int n4 = 0;
        Object var8_13 = null;
        boolean bl2 = false;
        n4 = 5;
        n = 3;
        int n5 = -2;
        int n6 = -2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (element3 != null) {
            block27: {
                String string6;
                boolean bl6;
                int n7;
                block25: {
                    block26: {
                        block24: {
                            n7 = -2;
                            bl3 = true;
                            bl6 = false;
                            string6 = element3.getLocalName();
                            if (!string6.equals("element")) break block24;
                            QName qName = this.traverseElementDecl(element3);
                            n7 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl5 = true;
                            break block25;
                        }
                        if (!string6.equals("group")) break block26;
                        n7 = this.traverseGroupDecl(element3);
                        if (n7 == -1) break block27;
                        bl5 = true;
                        break block25;
                    }
                    if (string6.equals("all")) {
                        n7 = this.traverseAll(element3);
                        bl4 = true;
                    } else if (string6.equals("choice")) {
                        n7 = this.traverseChoice(element3);
                        bl5 = true;
                    } else if (string6.equals("sequence")) {
                        n7 = this.traverseSequence(element3);
                        bl5 = true;
                    } else if (string6.equals("any")) {
                        n7 = this.traverseAny(element3);
                        bl5 = true;
                    } else {
                        bl6 = true;
                        this.reportSchemaError(14, new Object[]{"group", string6});
                    }
                }
                if (!bl6) {
                    n7 = this.expandContentModel(n7, element3);
                }
                if (bl5 && bl4) {
                    this.reportSchemaError(14, new Object[]{"'all' needs to be 'the' only Child", string6});
                }
                if (n5 == -2) {
                    n5 = n7;
                } else if (n6 == -2) {
                    n6 = n7;
                } else {
                    n5 = this.fSchemaGrammar.addContentSpecNode(n4, n5, n6, false);
                    n6 = n7;
                }
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        if (bl3 && n6 != -2) {
            n5 = this.fSchemaGrammar.addContentSpecNode(n4, n5, n6, false);
        }
        return n5;
    }

    private int traverseGroupDeclFromAnotherSchema(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseGroupDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelGroupDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getLocalName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n2 = 0;
        int n3 = 0;
        Object var11_11 = null;
        boolean bl2 = false;
        n3 = 5;
        n2 = 3;
        int n4 = -2;
        int n5 = -2;
        boolean bl3 = false;
        while (element2 != null) {
            block22: {
                boolean bl4;
                int n6;
                block20: {
                    String string3;
                    block21: {
                        block19: {
                            n6 = -2;
                            bl3 = true;
                            bl4 = false;
                            string3 = element2.getLocalName();
                            int n7 = this.fStringPool.addSymbol(string3);
                            String string4 = element2.getAttribute("form");
                            if (!string3.equals("element")) break block19;
                            QName qName = this.traverseElementDecl(element2);
                            n6 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl4 = true;
                            break block20;
                        }
                        if (!string3.equals("group")) break block21;
                        n6 = this.traverseGroupDecl(element2);
                        if (n6 == -1) break block22;
                        bl4 = true;
                        break block20;
                    }
                    if (string3.equals("all")) {
                        n6 = this.traverseAll(element2);
                        bl4 = true;
                    } else if (string3.equals("choice")) {
                        n6 = this.traverseChoice(element2);
                        bl4 = true;
                    } else if (string3.equals("sequence")) {
                        n6 = this.traverseSequence(element2);
                        bl4 = true;
                    } else if (string3.equals("any")) {
                        n6 = this.traverseAny(element2);
                        bl4 = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string3});
                    }
                }
                if (bl4) {
                    n6 = this.expandContentModel(n6, element2);
                }
                if (n4 == -2) {
                    n4 = n6;
                } else if (n5 == -2) {
                    n5 = n6;
                } else {
                    n4 = this.fSchemaGrammar.addContentSpecNode(n3, n4, n5, false);
                    n5 = n6;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl3 && n5 != -2) {
            n4 = this.fSchemaGrammar.addContentSpecNode(n3, n4, n5, false);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return n4;
    }

    int traverseSequence(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getLocalName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 5;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            block17: {
                boolean bl2;
                int n5;
                block15: {
                    String string;
                    block16: {
                        block14: {
                            n5 = -2;
                            bl = true;
                            bl2 = false;
                            string = element2.getLocalName();
                            if (!string.equals("element")) break block14;
                            QName qName = this.traverseElementDecl(element2);
                            n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl2 = true;
                            break block15;
                        }
                        if (!string.equals("group")) break block16;
                        n5 = this.traverseGroupDecl(element2);
                        if (n5 == -1) break block17;
                        bl2 = true;
                        break block15;
                    }
                    if (string.equals("choice")) {
                        n5 = this.traverseChoice(element2);
                        bl2 = true;
                    } else if (string.equals("sequence")) {
                        n5 = this.traverseSequence(element2);
                        bl2 = true;
                    } else if (string.equals("any")) {
                        n5 = this.traverseAny(element2);
                        bl2 = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string});
                    }
                }
                if (bl2) {
                    n5 = this.expandContentModel(n5, element2);
                }
                if (n3 == -2) {
                    n3 = n5;
                } else if (n4 == -2) {
                    n4 = n5;
                } else {
                    n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                    n4 = n5;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    int traverseChoice(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getLocalName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 4;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            block17: {
                boolean bl2;
                int n5;
                block15: {
                    String string;
                    block16: {
                        block14: {
                            n5 = -2;
                            bl = true;
                            bl2 = false;
                            string = element2.getLocalName();
                            if (!string.equals("element")) break block14;
                            QName qName = this.traverseElementDecl(element2);
                            n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl2 = true;
                            break block15;
                        }
                        if (!string.equals("group")) break block16;
                        n5 = this.traverseGroupDecl(element2);
                        if (n5 == -1) break block17;
                        bl2 = true;
                        break block15;
                    }
                    if (string.equals("choice")) {
                        n5 = this.traverseChoice(element2);
                        bl2 = true;
                    } else if (string.equals("sequence")) {
                        n5 = this.traverseSequence(element2);
                        bl2 = true;
                    } else if (string.equals("any")) {
                        n5 = this.traverseAny(element2);
                        bl2 = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string});
                    }
                }
                if (bl2) {
                    n5 = this.expandContentModel(n5, element2);
                }
                if (n3 == -2) {
                    n3 = n5;
                } else if (n4 == -2) {
                    n4 = n5;
                } else {
                    n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                    n4 = n5;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    int traverseAll(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getLocalName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int[] nArray = null;
        int n = 0;
        int n2 = -2;
        while (element2 != null) {
            block19: {
                boolean bl;
                int n3;
                block17: {
                    String string;
                    block18: {
                        block16: {
                            n3 = -2;
                            bl = false;
                            string = element2.getLocalName();
                            if (!string.equals("element")) break block16;
                            QName qName = this.traverseElementDecl(element2);
                            n3 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl = true;
                            break block17;
                        }
                        if (CR_IMPL) {
                            this.reportGenericSchemaError("Content of all group is restricted to elements only.  '" + string + "' was seen and is being ignored");
                            break;
                        }
                        if (!string.equals("group")) break block18;
                        n3 = this.traverseGroupDecl(element2);
                        if (n3 == -1) break block19;
                        bl = true;
                        break block17;
                    }
                    if (string.equals("choice")) {
                        n3 = this.traverseChoice(element2);
                        bl = true;
                    } else if (string.equals("sequence")) {
                        n3 = this.traverseSequence(element2);
                        bl = true;
                    } else if (string.equals("any")) {
                        n3 = this.traverseAny(element2);
                        bl = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string});
                    }
                }
                if (bl) {
                    n3 = this.expandContentModel(n3, element2);
                }
                try {
                    nArray[n] = n3;
                }
                catch (NullPointerException nullPointerException) {
                    nArray = new int[32];
                    nArray[n] = n3;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int[] nArray2 = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray[n] = n3;
                }
                ++n;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (n == 0) {
            return n2;
        }
        try {
            n2 = this.allCalcWrapper(nArray, n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reportGenericSchemaError("The size of the <all> declaration in your schema is too large for this parser and elements using it will not validate correctly.");
        }
        return n2;
    }

    private int allCalcWrapper(int[] nArray, int n) throws Exception {
        int n2 = n / 2;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        if (nArray2.length == 1) {
            return nArray2[0];
        }
        if (nArray2.length < 1) {
            return -2;
        }
        if (n2 > nArray2.length) {
            this.reportGenericSchemaError("The size of the permutations " + n2 + " cannot be greater than the length of the array to be permuted; error in processing of <all>!");
            return -2;
        }
        if (nArray2.length <= 3) {
            return this.allCombo(nArray2);
        }
        return this.allCalc(nArray2, 0, n2, 0, new int[nArray2.length - n2], -2);
    }

    private int allCombo(int[] nArray) throws Exception {
        if (nArray.length == 2) {
            int[] nArray2 = new int[]{nArray[0], nArray[1]};
            int[] nArray3 = new int[]{nArray[1], nArray[0]};
            int n = this.createSeq(nArray2);
            int n2 = this.createSeq(nArray3);
            return this.fSchemaGrammar.addContentSpecNode(4, n, n2, false);
        }
        if (nArray.length == 3) {
            int[] nArray4 = new int[]{nArray[0], nArray[1], nArray[2]};
            int[] nArray5 = new int[]{nArray[0], nArray[2], nArray[1]};
            int[] nArray6 = new int[]{nArray[1], nArray[0], nArray[2]};
            int[] nArray7 = new int[]{nArray[1], nArray[2], nArray[0]};
            int[] nArray8 = new int[]{nArray[2], nArray[1], nArray[0]};
            int[] nArray9 = new int[]{nArray[2], nArray[0], nArray[1]};
            int n = this.createSeq(nArray4);
            int n3 = this.createSeq(nArray5);
            int n4 = this.createSeq(nArray6);
            int n5 = this.createSeq(nArray7);
            int n6 = this.createSeq(nArray8);
            int n7 = this.createSeq(nArray9);
            int n8 = this.fSchemaGrammar.addContentSpecNode(4, n, n3, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n4, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n5, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n6, false);
            return this.fSchemaGrammar.addContentSpecNode(4, n8, n7, false);
        }
        return -2;
    }

    private int allCalc(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4) throws Exception {
        if (nArray.length - n2 - n == 1) {
            int[] nArray3 = new int[n2 + n];
            int n5 = n;
            while (n5 < nArray.length) {
                this.arrayProducer(nArray, n5, nArray3, nArray2, n3);
                int n6 = this.allCalcWrapper(nArray3, nArray3.length);
                int n7 = this.allCalcWrapper(nArray2, nArray2.length);
                int n8 = this.fSchemaGrammar.addContentSpecNode(5, n6, n7, false);
                n4 = n4 != -2 ? this.fSchemaGrammar.addContentSpecNode(4, n4, n8, false) : n8;
                ++n5;
            }
            return n4;
        }
        int n9 = n;
        while (n9 < nArray.length) {
            int[] nArray4 = new int[nArray.length - 1];
            this.arrayProducer(nArray, n9, nArray4, nArray2, n3);
            n4 = this.allCalc(nArray4, n, n2, n3 + 1, nArray2, n4);
            ++n;
            --n2;
            ++n9;
        }
        return n4;
    }

    private void arrayProducer(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        nArray3[n2] = nArray[n];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n < nArray.length - 1) {
            System.arraycopy(nArray, n + 1, nArray2, n, nArray.length - n - 1);
        }
    }

    private int createSeq(int[] nArray) throws Exception {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 2;
        while (n3 < nArray.length) {
            n = this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
            n2 = nArray[n3];
            ++n3;
        }
        return this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
    }

    private int parseInt(String string) throws Exception {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseSimpleFinal(String string) throws Exception {
        if (string.equals("#all")) {
            return 30;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + string + ")");
        }
        return n + n2 + n3 + n4;
    }

    private int parseComplexContent(String string) throws Exception {
        if (string.equals("empty")) {
            return 0;
        }
        if (string.equals("elementOnly")) {
            return 3;
        }
        if (string.equals("textOnly")) {
            return 4;
        }
        if (string.equals("mixed")) {
            return 2;
        }
        this.reportGenericSchemaError("Invalid value for content");
        return -1;
    }

    private int parseDerivationSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 7;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseBlockSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitutionGroup")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'substitutionGroup' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseFinalSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitutionGroup")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'substitutionGroup' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private void reportGenericSchemaError(String string) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + string);
        } else {
            this.reportSchemaError(23, new Object[]{string});
        }
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Error: Usage java TraverseSchema yourFile.xsd");
            System.exit(0);
        }
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(stringArray[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = ignoreWhitespaceParser.getDocument();
        OutputFormat outputFormat = new OutputFormat(document);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        TraverseSchema traverseSchema = null;
        try {
            Element element = document.getDocumentElement();
            traverseSchema = new TraverseSchema(element, new StringPool(), new SchemaGrammar(), new GrammarResolverImpl());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        ignoreWhitespaceParser.getDocument();
    }

    static class IgnoreWhitespaceParser
    extends DOMParser {
        IgnoreWhitespaceParser() {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void ignorableWhitespace(int n) {
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string) {
            super(string);
        }
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy = 0;
        public int blockSet = 0;
        public int finalSet = 0;
        public boolean isAbstract = false;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;
    }
}

