/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.util.Collection;

import javax.xml.parsers.DocumentBuilderFactory;

import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.multiplex.InputMultiplexor;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.w3c.dom.Document;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ConfigurationByXMLTestClient extends ConfigurationTestClient
{
   
/**
 *  In this test a Connector configured with an XML document
 *  is started and the parameters of the MultiplexingManager,
 *  InputMultiplexor, and OutputMultiplexor are tested.
 */
   public void testConfigurationByXML()
   {
      log.info("entering " + getName());
      
      try
      {  
         // Create XML document with parameters.
         String bindHost = ConfigurationTestServer.connector6BindHost;
         int bindPort = ConfigurationTestServer.connector6BindPort;
         StringBuffer buf = new StringBuffer();
         buf.append("<?xml version=\"1.0\"?>\n");
         buf.append("<config>");
         buf.append("<invoker transport=\"multiplex\">");
         buf.append("<attribute name=\"serverBindAddress\">" + bindHost + "</attribute>");
         buf.append("<attribute name=\"serverBindPort\">" + bindPort + "</attribute>");
         
         // MultiplexManager parameters.
         buf.append("<attribute name=\"" + Multiplex.STATIC_THREADS_MONITOR_PERIOD + "\">" +
                    (2 + Multiplex.STATIC_THREADS_MONITOR_PERIOD_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.SHUTDOWN_REQUEST_TIMEOUT + "\">" +
                    (3 + Multiplex.SHUTDOWN_REQUEST_TIMEOUT_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.SHUTDOWN_REFUSALS_MAXIMUM + "\">" +
                    (4 + Multiplex.SHUTDOWN_REFUSALS_MAXIMUM_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.SHUTDOWN_MONITOR_PERIOD + "\">" +
                    (5 + Multiplex.SHUTDOWN_MONITOR_PERIOD_DEFAULT) + "</attribute>");
         
         // InputMultiplexor parameters.
         buf.append("<attribute name=\"" + Multiplex.INPUT_BUFFER_SIZE + "\">" +
                    (2 + Multiplex.INPUT_BUFFER_SIZE_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.INPUT_MAX_ERRORS + "\">" +
                    (3 + Multiplex.INPUT_MAX_ERRORS_DEFAULT) + "</attribute>");
         
         // OutputMultiplexor parameters.
         buf.append("<attribute name=\"" + Multiplex.OUTPUT_MESSAGE_POOL_SIZE + "\">" +
                   (2 + Multiplex.OUTPUT_MESSAGE_POOL_SIZE_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.OUTPUT_MESSAGE_SIZE + "\">" +
                   (3 + Multiplex.OUTPUT_MESSAGE_SIZE_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.OUTPUT_MAX_CHUNK_SIZE + "\">" +
                   (4 + Multiplex.OUTPUT_MAX_CHUNK_SIZE_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.OUTPUT_MAX_TIME_SLICE + "\">" +
                   (5 + Multiplex.OUTPUT_MAX_TIME_SLICE_DEFAULT) + "</attribute>");
         buf.append("<attribute name=\"" + Multiplex.OUTPUT_MAX_DATA_SLICE + "\">" +
                   (6 + Multiplex.OUTPUT_MAX_DATA_SLICE_DEFAULT) + "</attribute>");
         
         // MultiplexServerInvoker parameter.
         buf.append("<attribute name=\"" + Multiplex.MAX_ACCEPT_ERRORS + "\">" +
                   (2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT) + "</attribute>");
    
         buf.append("</invoker>");
         buf.append("</config>");
         log.info(buf);
         Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
    
         // Create Connector.
         Connector connector = new Connector();
         connector.setConfiguration(xml.getDocumentElement());
         connector.create();
         SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
         connector.addInvocationHandler("sample", invocationHandler);
         connector.start();
         log.info("started Connector on: " + connector.getInvokerLocator());
         
         // Tell test server connector has started.
         os.write(37);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get MultiplexingManager.
         MultiplexServerInvoker masterServerInvoker = (MultiplexServerInvoker) connector.getServerInvoker();        
         while (masterServerInvoker.getServerInvokers().isEmpty())
         {
            try
            {
               Thread.sleep(1000);
            }
            catch (Exception e) {}
         }
         
         Collection virtualServerInvokers = masterServerInvoker.getServerInvokers();
         MultiplexServerInvoker virtualServerInvoker = (MultiplexServerInvoker) virtualServerInvokers.iterator().next();
         VirtualServerSocket vss = (VirtualServerSocket) virtualServerInvoker.getServerSocket();
         MultiplexingManager manager = vss.getMultiplexingManager();

         // Test MultiplexingManager parameters.
         Field field = MultiplexingManager.class.getDeclaredField("staticThreadsMonitorPeriod");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 2 + Multiplex.STATIC_THREADS_MONITOR_PERIOD_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownRequestTimeout");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 3 + Multiplex.SHUTDOWN_REQUEST_TIMEOUT_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownRefusalsMaximum");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 4 + Multiplex.SHUTDOWN_REFUSALS_MAXIMUM_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownMonitorPeriod");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 5 + Multiplex.SHUTDOWN_MONITOR_PERIOD_DEFAULT);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get InputMultiplexor.
         field =  MultiplexingManager.class.getDeclaredField("inputMultiplexor");
         field.setAccessible(true);
         InputMultiplexor inputMultiplexor = (InputMultiplexor) field.get(manager);
         
         // Test InputMultiplexor parameters.
         field = InputMultiplexor.class.getDeclaredField("bufferSize");
         field.setAccessible(true);
         assertEquals(field.getInt(inputMultiplexor), 2 + Multiplex.INPUT_BUFFER_SIZE_DEFAULT);
         
         field = InputMultiplexor.class.getDeclaredField("maxErrors");
         field.setAccessible(true);
         assertEquals(field.getInt(inputMultiplexor), 3 + Multiplex.INPUT_MAX_ERRORS_DEFAULT);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get OutputMultiplexor.
         field =  MultiplexingManager.class.getDeclaredField("outputMultiplexor");
         field.setAccessible(true);
         OutputMultiplexor outputMultiplexor = (OutputMultiplexor) field.get(manager);
         
         // Test OutputMultiplexor parameters.
         field = OutputMultiplexor.class.getDeclaredField("messagePoolSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 2 + Multiplex.OUTPUT_MESSAGE_POOL_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("messageSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 3 + Multiplex.OUTPUT_MESSAGE_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("maxChunkSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 4 + Multiplex.OUTPUT_MAX_CHUNK_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("maxTimeSlice");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 5 + Multiplex.OUTPUT_MAX_TIME_SLICE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("maxDataSlice");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 6 + Multiplex.OUTPUT_MAX_DATA_SLICE_DEFAULT);
                 
         /////////////////////////////////////////////////////////////////////////////////////
         // Test MultiplexServerInvoker parameter.
         field =  MultiplexServerInvoker.class.getDeclaredField("maxAcceptErrors");
         field.setAccessible(true);
         assertEquals(field.getInt(masterServerInvoker), 2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT);
         assertEquals(field.getInt(virtualServerInvoker), 2 + Multiplex.MAX_ACCEPT_ERRORS_DEFAULT);
 
         connector.stop();
         log.info(getName() + " PASSES");
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
         log.info(getName() + " FAILS");
      }
   }
}
