# Detect product
function ibm_j2re_detect() {
  local found=
  eval $(dpkg-architecture)
  case "$DEB_BUILD_GNU_TYPE" in
    "i386-linux")
      case "$archive_name" in
        "IBMJava2-JRE-131.tgz") # SUPPORTED
	    j2se_version=1.3.1
	    j2se_expected_min_size=20 #  bytes
	    found=true
	    ;;
        "IBMJava2-JRE-142.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=37 #  bytes
	    found=true
	    ;;
      esac
      ;;
    "x86_64-linux")
      case "$archive_name" in
        "IBMJava2-JRE-AMD64-142.x86_64.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=37
	    found=true
	    ;;
      esac
      ;;
    "s390-linux")
      case "$archive_name" in
        "IBMJava2-JRE-131.s390.tgz") # SUPPORTED
	    j2se_version=1.3.1
	    j2se_expected_min_size=20
	    found=true
	    ;;
        "IBMJava2-JRE-141.s390.tgz") # SUPPORTED
	    j2se_version=1.4.1
	    j2se_expected_min_size=31
	    found=true
	    ;;
        "IBMJava2-JRE-142.s390.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=34
	    found=true
	    ;;
        "IBMJava2-JRE-142.s390x.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=34
	    found=true
	    ;;
      esac
      ;;
    "powerpc-linux")
      case "$archive_name" in
        "IBMJava2-JRE-131.ppc.tgz") # SUPPORTED
	    j2se_version=1.3.1
	    j2se_expected_min_size=20 #  bytes
	    found=true
	    ;;
        "IBMJava2-JRE-142.ppc.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=40 #  bytes
	    found=true
	    ;;
      esac
      ;;
    "powerpc64-linux")
      case "$archive_name" in
        "IBMJava2-JRE-142.ppc64.tgz") # SUPPORTED
	    j2se_version=1.4.2
	    j2se_expected_min_size=37
	    found=true
	    ;;
      esac
      ;;
  esac
  if [[ -n "$found" ]]; then
    cat << EOF

Detected product:
    Java(TM) Runtime Environment (J2RE)
    Standard Edition, Version $j2se_version
    IBM Corporation
EOF
	if read_yn "Is this correct [Y/n]: "; then
	    j2se_found=true
	    j2se_release="${j2se_version:0:3}"
	    j2se_required_space=$(( $j2se_expected_min_size * 2 + 20 ))
	    j2se_vendor="ibm"
	    j2se_title="Java(TM) 2 RE, Standard Edition, IBM Corporation"
	    j2re_run
 	fi
    fi
}

j2se_detect_ibm_j2re=ibm_j2re_detect
