package org.biojava.utils.bytecode;

/**
 * Instructions which retrieve a double from the constant pool.
 *
 * @author Matthew Pocock
 */

class DoubleInstruction implements Instruction {
  private double val;
  
  DoubleInstruction(double val) {
    this.val = val;
  }
  
  public void writeCode(CodeContext ctx) throws CodeException {
    ctx.writeByte(ByteCode.op_ldc2_w);
    ctx.writeShort(ctx.getConstants().resolveDouble(val));
  }
  
  public int stackDepth() {
    return stackDelta();
  }
  
  public int stackDelta() {
    return 1;
  }
}
