 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Thu Aug 14 1997                               */
 /* --------------------------------------------------------------------  */
 /* Look for subtypes of a given type defined in any module.              */
 /*                                                                       */
 /* Walks over the directory tree looking for header files with names     */
 /* which match ".*Type.h" and looks in them for class                    */
 /* definitions. Outputs definitions of subtype tables.                   */
 /*                                                                       */
 /*************************************************************************/

#include "EST.h"
#include "EST_String.h"
#include "EST_Pathname.h"
#include "EST_error.h"

#define BUFFER_SIZE (1024)

void find_below(EST_Pathname dir, EST_Regex &file_re, EST_StrList &dirs)
{
  static EST_Regex start_re("^[./\\]+");
  static EST_Regex sep_re("[/\\]+");
#ifdef DO_SUBDIRS
  EST_StrList entries(dir.entries());

  EST_Litem *item;

  for(item=entries.head(); item; item=next(item))
    {
      EST_Pathname entry = entries(item);

      if (entry != "./" && entry != "../" && entry != "RCS/" && entry.is_dirname())
	find_below(dir + entry, file_re, dirs);

    }
#endif

  // fprintf(stderr, "dir=%s\n", (const char *)dir);

  if (access(dir + "NoInit", F_OK) != 0  &&
      dir.contains(file_re))
    {
      EST_String name(dir.as_file());
      name.gsub(start_re, "");
      name.gsub(sep_re, "_");
      dirs.append(name);
    }
}

int main(int argc, char *argv[])
{
  if (argc <2)
    EST_error("Useage: find_inits DIRECTORY ..."); 

  argv+=1;
  argc-=1;

  EST_String fre = EST_String("\\([A-Z0-9a-z_]+\\)[/\\\\\\\\]*$");
  EST_Regex  file_re(fre);

  EST_StrList dirs;

  for(int i=0; i<argc; i++)
    {
      EST_Pathname dir(argv[i]);


      find_below(dir.as_directory(), file_re, dirs);
    }

  cout << "\n";
  cout << "/* This file is autogenerated by src/modules/Makefile */\n";
  cout << "\n";
  cout << "#include \"EST_unix.h\"\n";
  cout << "#include \"stdio.h\"\n";
  cout << "#include \"festival.h\"\n";
  cout << "\n";

  
  EST_Litem *d_item;
  for(d_item=dirs.head(); d_item; d_item=next(d_item))
    {
      EST_String dir(dirs(d_item));
      cout <<  "void festival_" << dir << "_init(void);\n";
    }

  cout << "\n";
  cout << "void festival_init_modules(void)\n";
  cout << "{\n";
  for(d_item=dirs.head(); d_item; d_item=next(d_item))
    {
      EST_String dir(dirs(d_item));
      cout << "   festival_" << dir << "_init();\n";
    }
  cout << "}\n";
  return 0;
}






