 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Fri Jul 25 1997                               */
 /* --------------------------------------------------------------------- */
 /* A simple power smoothing module which turns off power calculation     */
 /* in synthesis.                                                         */
 /*                                                                       */
 /*************************************************************************/


//#include "../WaveSynthesis/FramesUnit.h"
#include "FramesUnit.h"
#include "no_power.h"
#include "frames_imposition_support.h"
#include "module_support.h"

static ModuleDescription description =
{
  "no_power", 1.0,
  "CSTR",
  "Richard Caley <rjc@cstr.ed.ac.uk>",
  {
    "No power smoothing.",
     NULL
  },
  {
    { "Segment",	"Segments of the utterance."},
    { "ModifiedUnit",	"Units to be smoothed"},
    {NULL,NULL}
  },
  { {NULL,NULL}
  },
  { {NULL,NULL}
  },
  { {NULL,NULL,NULL,NULL}
  }
};

static inline int irint(float f) { return int((f)+0.5); }

static void extract_power(FramesUnit::Chunk *ch, int &pos)
{

  Unit *last_unit=NULL;
  int mod_i=0;
  for(int i=0; i<ch->n; i++)
    {
      if (ch->bit[i].unit == last_unit)
	mod_i++;
      else
	mod_i=0;
      last_unit = ch->bit[i].unit;
	  
      EST_Track *mods = ch->bit[i].unit->modifications(mod_i);

      if (mods)
	{
	  ImpositionBuffer::ensure(pos+50);
	  for(int f=0; f<mods->num_frames(); f++)
	      ImpositionBuffer::b()[pos++].power = mods->a(f, channel_power);
	}
    }
}

static void impose_power(FramesUnit::Chunk *ch, int &pos)
{

  Unit *last_unit=NULL;
  int mod_i=0;
  for(int i=0; i<ch->n; i++)
    {
      if (ch->bit[i].unit == last_unit)
	mod_i++;
      else
	mod_i=0;
      last_unit = ch->bit[i].unit;
	  
      EST_Track *mods = ch->bit[i].unit->modifications(mod_i);

      if (mods)
	  for(int f=0; f<mods->num_frames(); f++)
	      mods->a(f, channel_power) = ImpositionBuffer::b()[pos++].power;
    }
}

static void switch_off_power(int n)
{
  for (int i=0; i<n; i++)
    {
      ImpositionBuffer::b()[i].power = -1;
    }
}

LISP no_power(LISP args)
{
  EST_Utterance *utt;

  EST_String segment_stream_name("Segment");
  EST_String modunit_stream_name("ModifiedUnit");

  EST_Stream *segment_stream=NULL, *modunit_stream=NULL;

  unpack_module_args(args, 
		     utt, 
		     segment_stream_name, segment_stream, sat_existing,
		     modunit_stream_name, modunit_stream, sat_existing);

  FramesUnit::Chunk *chunks = FramesUnit::chunk_utterance(utt, modunit_stream, NULL);

  FramesUnit::Chunk *ch;
  EST_Stream_Item *seg_item=segment_stream->head();
  int pos=0;

  for(ch=chunks; ch->n != 0; ch++)
    {
      if (!seg_item)
	err("too many chunks", NIL);
  
      extract_power(ch, pos);

      seg_item = next(seg_item);
    }

  //  cout << "[[";
  //  for(int i=0; i<pos; i++)
  //    cout << " " << ImpositionBuffer::b()[i].power;
  //  cout << " ]]\n";

  switch_off_power(pos);

  //  cout << "[[";
  //  for(int ii=0; ii<pos; ii++)
  //    cout << " " << ImpositionBuffer::b()[ii].power;
  //  cout << " ]]\n";

  seg_item=segment_stream->head();
  pos=0;

  for(ch=chunks; ch->n != 0; ch++)
    {
      impose_power(ch, pos);

      seg_item = next(seg_item);
    }

 return NIL;
}

void no_power_init(void)
{
  proclaim_module("no_power", &description);
  init_module_subr("no_power", no_power, &description);
}
