 /*************************************************************************/
 /*                                                                       */
 /*                Centre for Speech Technology Research                  */
 /*                     University of Edinburgh, UK                       */
 /*                       Copyright (c) 1996,1997                         */
 /*                        All Rights Reserved.                           */
 /*                                                                       */
 /*  Permission to use, copy, modify, distribute this software and its    */
 /*  documentation for research, educational and individual use only, is  */
 /*  hereby granted without fee, subject to the following conditions:     */
 /*   1. The code must retain the above copyright notice, this list of    */
 /*      conditions and the following disclaimer.                         */
 /*   2. Any modifications must be clearly marked as such.                */
 /*   3. Original authors' names are not deleted.                         */
 /*  This software may not be used for commercial purposes without        */
 /*  specific prior written permission from the authors.                  */
 /*                                                                       */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
 /*  THIS SOFTWARE.                                                       */
 /*                                                                       */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Wed Mar 12 1997                               */
 /* --------------------------------------------------------------------- */
 /* Tie all the synthesis modules together.                               */
 /*                                                                       */
 /*************************************************************************/

#include "siod.h"
#include "EST.h"
#include "UniSyn.h"

LISP us_diphone_init(LISP args);
LISP us_get_diphones(LISP args);
LISP us_make_group_file(LISP name,LISP params);
LISP us_ps_synthesis(LISP arg1, LISP arg2);
LISP us_list_dbs(void);
LISP us_select_db(LISP name);
LISP us_db_params();

LISP us_F0targets_to_pitchmarks(LISP lutt);
void us_get_diphones(EST_Utterance &utt);


LISP FT_warp_pitchmarks(LISP lutt, LISP l_pm_file, LISP l_seg_file)
{
    EST_Utterance *utt = get_c_utt(lutt);

    EST_String pm_file = get_c_string(l_pm_file);
    EST_String seg_file = get_c_string(l_seg_file);

    EST_Track *pm = new EST_Track;
    EST_Relation seg;

    if (pm->load(pm_file) != format_ok)
	return NIL;

    if (seg.load(seg_file) != format_ok)
	return NIL;

    warp_pitchmarks(*utt, pm, seg, *utt->relation("Segment"));

    return lutt;
}

LISP FT_f0_to_pitchmarks(LISP lutt, LISP l_f0_name, LISP l_pm_name, 
			 LISP l_end_time)
{
    EST_Utterance *utt = get_c_utt(lutt);

    float end_time = (l_end_time == NIL) ? -1 : get_c_float(l_end_time);

    EST_Relation *f0_rel = utt->relation(get_c_string(l_f0_name), 1);
    EST_Relation *pm_rel = utt->create_relation(get_c_string(l_pm_name));

    EST_Track *f0 = (EST_Track *) f0_rel->head()->fP("f0", 1);
    EST_Track *pm = new EST_Track;

    EST_Item *a = pm_rel->append();
    a->fset("coefs", pm, gc_track);
    a = pm_rel->append();

    f0_to_pitchmarks(*f0, *pm, end_time);
//    cout << "f0: " << *f0 << endl;
//    cout << "pm: " << *pm << endl;

    return lutt;
}

LISP FT_us_F0targets_to_pitchmarks(LISP lutt)
{
    EST_Utterance *utt = get_c_utt(lutt);

    us_F0targets_to_pitchmarks(*utt);

    return lutt;
}

LISP FT_us_unit_concat(LISP lutt)
{
    EST_Utterance *utt = get_c_utt(lutt);

    us_unit_concat(*utt);

    return lutt;
}

LISP FT_us_unit_copy_wave(LISP lutt, LISP l_sig_file,  LISP l_pm_file)
{
    EST_Utterance *utt = get_c_utt(lutt);

    EST_String sig_file = get_c_string(l_sig_file);
    EST_String pm_file = get_c_string(l_pm_file);

    EST_Track *pm = new EST_Track;
    EST_Wave *sig = new EST_Wave;

    if (pm->load(pm_file) != format_ok)
	return NIL;

    if (sig->load(sig_file) != format_ok)
	return NIL;

    us_unit_copy_wave(*utt, *sig, pm);

    return lutt;
}

LISP FT_us_lpc_synthesis(LISP lutt)
{
    EST_Utterance *utt = get_c_utt(lutt);

    us_lpc_synthesis(*utt);

    return lutt;
}

LISP FT_us_get_diphones(LISP lutt)
{
    EST_Utterance *utt = get_c_utt(lutt);

    us_get_diphones(*utt);

    return lutt;
}

void festival_UniSyn_init(void)
{
    proclaim_module("UniSyn");

    init_subr_1("us_diphone_init", us_diphone_init,
    "(us_diphone_init DIPHONE_NAME)\n\
    Initialise UniSyn diphone synthesizer with database DIPHONE_NAME.");

    init_subr_1("us_lpc_synthesis", FT_us_lpc_synthesis,
    "(us_lpc_synthesis UTT)\n\
    Synthesize utterance UTT using residual excited LPC in \n\
    the UniSyn pitch-synchronous synthesizer.");
    
    init_subr_1("us_get_diphones", FT_us_get_diphones,
    "(us_get_synthesis UTT)\n\
    Construct a unit stream in UTT comprising suitable diphones. The unit \n\
     stream produced is suitable for immediate use in us_ps_synthesis.");

    init_subr_1("us_unit_concat", FT_us_unit_concat,
    "(us_unit_concat UTT)\n\
     Concat coef and wave information in unit stream into a single \n\
     Frames structure storing the result in the Frame relation");

    init_subr_1("us_F0targets_to_pitchmarks", FT_us_F0targets_to_pitchmarks,
    "(us_F0targets_to_pitchmarks UTT)\n\
     Make set of pitchmarks according to F0 target specification");

    init_subr_4("us_f0_to_pitchmarks", FT_f0_to_pitchmarks,
    "(us_f0_to_pitchmarks UTT F0_relation PM_relation END_TIME)\n\
    From the F0 contour in F0_relation, create a set of pitchmarks\n\
    in PM_relation. If END_TIME is not nil, Extra pitchmarks will be \n\
    created at the default interval up to this point");

    init_subr_2("us_make_group_file", us_make_group_file,
    "(us_make_group_file FILENAME PARAMS)\n\
    Make a group file from the currently specified diphone set.  PARAMS \n\
    is an optional assoc list and allows specification of the \n\
    track_file_format (default est_binary), sig_file_format (default \n\
    snd) and sig_sample_format (default mulaw).  This is recommended \n\
    for LPC databases.  For PSOLA based databases the sig_sample_format \n\
    should probably be set to short.");
    
    init_subr_0("us_list_dbs", us_list_dbs,
    "(us_list_dbs)\n\
    List names of UniSyn databases currently loaded.");

    init_subr_0("us_db_params", us_db_params,
    "(us_db_params)\n\
    Return parameters of current UniSyn database.");

    init_subr_1("us_db_select", us_select_db,
    "(us_db_select NAME)\n\
    Select named UniSyn database.");

    init_subr_3("us_warp_pitchmarks", FT_warp_pitchmarks,
    "(warp_utterance UTT (Wavefile Pitchmark_file))\n\
    Change waveform to match prosodic specification of utterance.");

    init_subr_3("us_unit_copy_wave", FT_us_unit_copy_wave,
    "(warp_utterance UTT (Wavefile Pitchmark_file))\n\
    Change waveform to match prosodic specification of utterance.");

#ifdef HAVE_US_TDPSOLA_TM
    us_init_tdpsola();
#endif

}
