%{
/********************************************************************************
 * Copyright (c) Erik Kunze 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char debug2_l[] = "$Id: monitor2.l,v 4.1 1998/01/06 21:21:30 erik Rel $";
#endif

#include <stdio.h>
#include <ctype.h>
#include "y.tab.h"
#include "monitor.h"

#undef getc
#define getc(x)		(*CmdLine ? tolower(*CmdLine++) : EOF)
#undef feof
#define feof(x)		(*CmdLine ? 0 : 1)

extern int yylval;



%}
%%
[ \t]+				{	}
\n					{ return NL;				}
"+"					{ return PLUS;				}
"-"					{ return MINUS;				}
"="					{ return EQUAL;				}
"c"					{
						if (NumberBase == 16)
						{
							REJECT;
						}
						return COPY;
					}
"copy"				{ return COPY;				}
"d"					{
						if (NumberBase == 16)
						{
							REJECT;
						}
						return DIS;
					}
"dis"				{ return DIS;				}
"f"					{
						if (NumberBase == 16)
						{
							REJECT;
						}
						return FILL;
					}
"fill"				{ return FILL;				}
"g"("o")?			{ return GO;				}
"q"("uit")?			{ return QUIT;				}
"r"("eg")?			{ return REGISTER;			}
"base"				{ return BASE;				}
"bin"				{ return BAS2;				}
"oct"				{ return BAS8;				}
"dec"				{ return BAS10;				}
"hex"				{ return BAS16;				}
"im"				{ return INT_MODE;			}
"iff1"				{ return INT_FF1;			}
"iff2"				{ return INT_FF2;			}
[01]+				{
						if (NumberBase == 2)
						{
							int i;
							for (i = 0, yylval = 0; i < yyleng; i++)
							{
								yylval <<= 1;
								yylval |= yytext[i] - '0';
							}
							return (yylval > 0xffff ? UNKNOWN : NUMBER);
						}
						REJECT;
					}
[0-7]+				{
						if (NumberBase == 8)
						{
							(void)sscanf(yytext, "%o", &yylval);
							return (yylval > 0xffff ? UNKNOWN : NUMBER);
						}
						REJECT;
					}
[0-9]+				{
						if (NumberBase == 10)
						{
							(void)sscanf(yytext, "%d", &yylval);
							return (yylval > 0xffff ? UNKNOWN : NUMBER);
						}
						REJECT;
					}
[0-9a-f]+			{
						if (NumberBase == 16)
						{
							(void)sscanf(yytext, "%x", &yylval);
							return (yylval > 0xffff ? UNKNOWN : NUMBER);
						}
						return UNKNOWN;
					}
.					{ return UNKNOWN;			}
%%

void
yylex_init(void)
{
	BEGIN INITIAL;
}

