/************************************************************************/
/* Module : xutil.c					                */
/* Purpose: Misc X routines              	                        */
/* By     : Keith R. Davis					        */
/* Date   : 7/24/98					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/************************************************************************/

#include <Xm/Xm.h>			/* motif lib header		*/
#include <Xm/PrimitiveP.h>              /* motif primitive widget head. */
#include <X11/cursorfont.h>             /* X cursors                    */

/************************************************************************/
/* Function: XUTIL_BeginWait                                            */
/* Purpose : Grabs input events & displays watch cursor                 */
/* Params  : w : widget to receive wait state                           */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void XUTIL_BeginWait(Widget w)
{ 
  XDefineCursor(XtDisplay(w),
		XtWindow(w),
		XCreateFontCursor(XtDisplay(w),XC_watch));

  XmUpdateDisplay(w);

  XtGrabButton(w,
	       AnyButton,
	       AnyModifier,
	       TRUE,
	       ButtonPressMask|ButtonMotionMask|ButtonReleaseMask|
	       LeaveWindowMask|EnterWindowMask|FocusChangeMask,
	       GrabModeAsync,
	       GrabModeAsync,
	       None,
	       None);
}

/************************************************************************/
/* Function: XUTIL_EndWait                                              */
/* Purpose : UnGrabs input events                                       */
/* Params  : w : widget to have wait state removed                      */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void XUTIL_EndWait(Widget w)
{
  XtUngrabButton(w, AnyButton, AnyModifier);
  XUndefineCursor(XtDisplay(w),XtWindow(w));
  XmUpdateDisplay(w);
}
