/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: contexthelp.h,v 1.4 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		contexthelp.h
**
**  contents:		definitions for context sensitive help
**
**  interface:		#include "context.h" 
**			
**  public procedures:	
**
**	* void context_cb (Widget, XtPointer, XtPointer)
**			
**      * to get context help, specify the following
**
**	  XtAddCallback (widget, XmNhelpCallback, 
**			 (XtCallbackProc) context_cb, 
**			 (XtPointer) cx_*);
**
**	  where widget is the widget for which help is needed and
**	  cx_* is a identifyer  constant (defined here in context.h).
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _CONTEXTHELP_H_
#define _CONTEXTHELP_H_ 1

/* -------------------------------------------------------------------- *
*g  include files
** -------------------------------------------------------------------- */
#include <Xm/Xm.h>		/* for Widget. */
#include "helpp.h"

/* -------------------------------------------------------------------- *
*g  interface specification and prototypes.
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	libhelp_context_cb
**
**  purpose:		provides context sensitive help. 
**			in most cases it is called by
** -------------------------------------------------------------------- *
**  args:		standard callback args.
**			(in) Widget parent,
**			(in) XtPointer call_data,
**			(in) XtPointer client_data (unused)
**			call_data is actually an integer. 
**			symbols for possible values are defined below.
**			
**  precondition:	callback must be added via XtAddCallback
**  postcondition:	context sensitive help is initiated.
**  error handling.:	-
** -------------------------------------------------------------------- */
void 
libhelp_context_cb (Widget, XtPointer, XtPointer);

/* -------------------------------------------------------------------- *
*g  data for context sensitive help.
** -------------------------------------------------------------------- */
#define cx_non  		0
#define cx_browser 		1
#define cx_help_toolbar 	2
#define cx_main_toolbar         3
#define cx_sql_window           4
#define cx_output_window        5
#define cx_status_window        6 
#define cx_menu                 7    

#define cx_max			8
#define cx_end			-1

/* the mapping between context symbols and help files is made here:  */
#define context_mapping							\
{ cx_non, 		"index.html" },  				\
{ cx_browser ,		"mpsql_help.html" },			        \
{ cx_help_toolbar, 	"mpsql_help.html" },         			\
{ cx_main_toolbar,      "mpsql_toolbar.html" },                         \
{ cx_sql_window,        "mpsql_edit.html"},                             \
{ cx_output_window,     "mpsql_output.html"},                           \
{ cx_status_window,     "mpsql_msg.html"},			        \
{ cx_menu,              "mpsql_menu.html"},                             \
/* last line:  */							\
{ cx_end, NULL }
    
/* -------------------------------------------------------------------- *
*g  context_help convenience macro
** -------------------------------------------------------------------- */
#define context_help(_widget,_class)					\
XtAddCallback ((_widget), XmNhelpCallback, 				\
	       (XtCallbackProc) libhelp_context_cb,			\
	       (XtPointer) (_class))

#endif /* !_CONTEXTHELP_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
