/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

/*************************************************************
 * Modified by James Brook, Oct 1994
 * British Telecommunications Labs, UK, jamesb@aom.bt.co.uk
 * Want to add another option to the subsetting panel, to
 * choose all rows with a particular identifier.
 ************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <math.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"

static Widget spopup;
static Widget from_text, to_text;
static char *from_str, *to_str;
static Widget sample_text;
static char *sample_str;
static Widget everyn_text, everyn_init_text;
static char *everyn_str, *everyn_init_str;

/*************************************************************
 * Added by James Brook, Oct 1994
 ************************************************************/
static Widget id_cmd, id_label, id_text;
static char *id_str;
static Boolean id = False;
static Widget sticky_ids_cmd;
static Boolean sticky_ids = False;
/************************************************************/

static Widget apply, restore, close;
static Boolean block = False, sample = True, everyn = False;

/* ARGSUSED */
static XtCallbackProc
rescale_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  reset_rows_in_plot(xg, True);
  copy_brushinfo_to_senddata(xg);
  if (xg->link_erase_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
  }
  assign_points_to_bins(xg);
  plot_once(xg);

  if (xg->is_cprof_plotting && xg->link_cprof_plotting)
    passive_update_cprof_plot(xg);
}

/*
 * This algorithm taken from Knuth, Seminumerical Algorithms;
 * Vol 2 of his series.
*/
int
sample_xgobi(int n, xgobidata *xg) {
  int i, t, m;
  int doneit = 0;
  float rrand;
#ifndef USE_DRAND48
  long lrand;
#endif

  if (n > 0 && n < xg->nrows) {
    for (i=0; i<xg->nrows; i++)
      xg->erased[i] = 1;

    for (t=0, m=0; t<xg->nrows && m<n; t++)
    {
#ifdef USE_DRAND48
      rrand = (float) drand48();    /* rrand on [0.0,1.0] */
#else
      lrand = (long) random();
      rrand = (float) ((double) lrand / (double) MAXINT) ;
#endif

      if ( ((xg->nrows - t) * rrand) < (n - m) )
      {
        xg->erased[t] = 0;
        xg->rows_in_plot[m++] = t;
      }
    }
    doneit = 1;
  }
  return(doneit);
}

/* ARGSUSED */
XtCallbackProc
subset_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int i, k;
  int doneit = 0;

  if (block)
  {
    int from_n, to_n;

    XtVaGetValues(from_text, XtNstring, (String) &from_str, NULL);
    XtVaGetValues(to_text, XtNstring, (String) &to_str, NULL);

    from_n = atoi(from_str);
    to_n = atoi(to_str);

    if (to_n > 0 && to_n <= xg->nrows &&
        from_n > 0 && from_n < xg->nrows &&
        from_n < to_n)
    {

      for (i=0; i<xg->nrows; i++)
        xg->erased[i] = 1;

      for (i=(from_n - 1), k=0; i<to_n; i++, k++)
      {
        xg->erased[i] = 0;
        xg->rows_in_plot[k] = i;
      }
      xg->nrows_in_plot = to_n - from_n + 1;

      xg->delete_erased_pts = True;
      doneit = 1;
    }
    else
    {
      char message[MSGLENGTH];
      sprintf(message, "The limits aren't correctly specified.\n");
      show_message(message, xg);
    }
  }
  else if (sample)
  {
    int sample_size;

    XtVaGetValues(sample_text, XtNstring, (String) &sample_str, NULL);
    sample_size = atoi(sample_str);
    if (sample_size > 0) {
      doneit = sample_xgobi(sample_size, xg);
      xg->nrows_in_plot = sample_size;
    }

  }
  else if (everyn)
  {
    int everyn_n, everyn_init;

    XtVaGetValues(everyn_text, XtNstring, (String) &everyn_str, NULL);
    everyn_n = atoi(everyn_str);

    XtVaGetValues(everyn_init_text, XtNstring, (String) &everyn_init_str, NULL);
    everyn_init = atoi(everyn_init_str);

    if (everyn_n > 0 && everyn_n < xg->nrows &&
      everyn_init > 0 && everyn_init < (xg->nrows-1) )
    {
      for (i=0; i<xg->nrows; i++)
        xg->erased[i] = 1;

      for (i=(everyn_init-1), k=0; i<xg->nrows; i=i+everyn_n, k++)
      {
        xg->erased[i] = 0;
        xg->rows_in_plot[k] = i;
      }
      xg->nrows_in_plot = k+1;
      doneit = 1;
    }
    else
    {
      char message[MSGLENGTH];
      sprintf(message, "Interval 'n' not correctly specified.\n");
      show_message(message, xg);
    }
  }

  /*************************************************************
   * Added by James Brook, Oct 1994
   ************************************************************/
  if (sticky_ids)
  {
    int j;

    k = 0;
    for (i=0; i<xg->nrows; i++) {
      xg->erased[i] = 1;
      for (j=0; j<xg->nsticky_ids; j++) {
        if (!strcmp(xg->rowlab[i], xg->rowlab[xg->sticky_ids[j]])) {
          if (xg->erased[i]) {	/* If it has not been done already */
            xg->erased[i] = 0;
            xg->rows_in_plot[k++] = i;
            break;
          }
        }
      }
    }
    xg->nrows_in_plot = k;

    xg->delete_erased_pts = True;
    doneit = 1;
  }

  /***************************************************************
   * Could use the same format as the others, i.e. loop over rows 
   * setting them erased then unerasing the ones we want, but it
   * seems quicker this way
   ***************************************************************/
  if (id)
  {
    XtVaGetValues(id_text, XtNstring, (String) &id_str, NULL);

    k = 0;
    for (i=0; i<xg->nrows; i++) {
      if (strcmp(xg->rowlab[i], id_str)) {
        xg->erased[i] = 1;
      }
      else {
        xg->erased[i] = 0;
        xg->rows_in_plot[k++] = i;
      }
    }
    xg->nrows_in_plot = k;

    xg->delete_erased_pts = True;
    doneit = 1;
  }
  /************************************************************/

  if (doneit)
  {
    reset_rows_in_plot(xg, False);
    copy_brushinfo_to_senddata(xg);
    if (xg->link_erase_brushing)
    {
      XtOwnSelection( (Widget) xg->workspace,
        (Atom) XG_ROWSINPLOT,
        (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
        /*(Time) XtLastTimestampProcessed(display),*/
        (XtConvertSelectionProc) pack_rowsinplot_data,
        (XtLoseSelectionProc) pack_brush_lose ,
        (XtSelectionDoneProc) pack_brush_done );
      announce_rows_in_plot(xg);
    }
    assign_points_to_bins(xg);
    plot_once(xg);

    if (xg->is_cprof_plotting && xg->link_cprof_plotting)
      passive_update_cprof_plot(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
restore_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int i;

  for (i=0; i<xg->nrows; i++)
  {
    xg->erased[i] = 0;
    xg->rows_in_plot[i] = i;
  }
  xg->nrows_in_plot = xg->nrows;
  /* Restore no longer rescales */
  reset_rows_in_plot(xg, False);

  copy_brushinfo_to_senddata(xg);
  if (xg->link_erase_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
  }
  assign_points_to_bins(xg);
  plot_once(xg);

  if (xg->is_cprof_plotting && xg->link_cprof_plotting)
    passive_update_cprof_plot(xg);
}

/* ARGSUSED */
static XtCallbackProc
close_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  XtPopdown(spopup);
}

/* ARGSUSED */
XtCallbackProc
block_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  block = !block;
}

/* ARGSUSED */
XtCallbackProc
sample_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  sample = !sample;
}

/* ARGSUSED */
XtCallbackProc
everyn_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  everyn = !everyn;
}

/*************************************************************
 * Added by James Brook, Oct 1994
 ************************************************************/
/* ARGSUSED */
XtCallbackProc
sticky_ids_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  sticky_ids = !sticky_ids; 
}

/* ARGSUSED */
XtCallbackProc
id_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  id = !id;
}
/*****************************************************************/

/* ARGSUSED */
XtCallbackProc
subset_panel_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  Widget sframe, sform, paramform, paramlabel;
  Widget sample_cmd, sample_label;
  Widget rescale_cmd;
  Widget block_cmd, from_label, to_label;
  Widget everyn_cmd, everyn_label;
  Widget everyn_init_label;
  Dimension width, height;
  Position x, y;
  static int initd = 0;

  if (!initd)
  {
    from_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    to_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    everyn_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    everyn_init_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    sample_str = (char *) XtMalloc((Cardinal) 20 * sizeof(char));
    /*************************************************************
     * Added by James Brook, Oct 1994
     ************************************************************/
    id_str = (char *) XtMalloc((Cardinal) 32 * sizeof(char));
    /*****************************************************************/
    
    (void) sprintf(from_str, "1");
    (void) sprintf(to_str, "%d", xg->nrows);
    (void) sprintf(everyn_str, "1");
    (void) sprintf(everyn_init_str, "1");
    (void) sprintf(sample_str, "%d", xg->nrows_in_plot);
    /*************************************************************
     * Added by James Brook, Oct 1994
     ************************************************************/
    (void) sprintf(id_str, xg->rowlab[0]);
    /*****************************************************************/

    XtVaGetValues(xg->shell,
      XtNwidth, &width,
      XtNheight, &height, NULL);
    XtTranslateCoords(xg->shell,
      (Position) (width/2), (Position) (height/2), &x, &y);
    /*
     * Create the popup to solicit subsetting arguments.
    */
    spopup = XtVaCreatePopupShell("Subset0",
      /*transientShellWidgetClass, w,*/
      topLevelShellWidgetClass, xg->shell,
      XtNx, (Position) x,
      XtNy, (Position) y,
      XtNinput, (Boolean) True,
      /*XtNallowShellResize, (Boolean) False,*/
      XtNtitle, (String) "Subset data",
      XtNiconName, (String) "Subset",
      NULL);
    if (mono) set_mono(spopup);

    /*
     * Create a paned widget so the 'Click here ...'
     * can be all across the bottom.
    */
    sframe = XtVaCreateManagedWidget("Form",
      panedWidgetClass, spopup,
      XtNorientation, (XtOrientation) XtorientVertical,
      NULL);

    /*
     * Create the form widget.
    */
    sform = XtVaCreateManagedWidget("Form",
      formWidgetClass, sframe,
      NULL);
    if (mono) set_mono(sform);

    paramform = XtVaCreateManagedWidget("Param",
      formWidgetClass, sform,
      NULL);
    if (mono) set_mono(paramform);

    paramlabel = XtVaCreateManagedWidget("Label",
      labelWidgetClass, paramform,
      XtNlabel, (String) "Subsetting parameters:",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(paramlabel);

    block_cmd = (Widget) CreateToggle(xg, "Consec. block",
      True, (Widget) NULL, (Widget) paramlabel, (Widget) NULL,
      block, ONE_OF_MANY, paramform, "Subset");
    XtVaSetValues(block_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    XtManageChild(block_cmd);
    XtAddCallback(block_cmd, XtNcallback,
      (XtCallbackProc) block_cback, (XtPointer) xg);

    from_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) block_cmd,
      XtNfromVert, (Widget) paramlabel,
      XtNlabel, (String) "From row ",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(from_label);

    from_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) from_label,
      XtNfromVert, (Widget) paramlabel,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) from_str,
      NULL);
    if (mono) set_mono(from_text);

    to_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) from_text,
      XtNfromVert, (Widget) paramlabel,
      XtNlabel, (String) "to row ",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(to_label);

    to_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) to_label,
      XtNfromVert, (Widget) paramlabel,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) to_str,
      NULL);
    if (mono) set_mono(to_text);

    sample_cmd = (Widget) CreateToggle(xg, "Random sample w/o repl.",
      True, (Widget) NULL, (Widget) block_cmd, (Widget) block_cmd,
      sample, ONE_OF_MANY, paramform, "Subset");
    XtVaSetValues(sample_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    XtManageChild(sample_cmd);
    XtAddCallback(sample_cmd, XtNcallback,
      (XtCallbackProc) sample_cback, (XtPointer) xg);

    sample_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) sample_cmd,
      XtNfromVert, (Widget) from_label,
      XtNlabel, (String) "Sample of size",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(sample_label);

    sample_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) sample_label,
      XtNfromVert, (Widget) from_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) sample_str,
      NULL);
    if (mono) set_mono(sample_text);

    everyn_cmd = (Widget) CreateToggle(xg, "Every nth row",
      True, (Widget) NULL, (Widget) sample_cmd, (Widget) block_cmd,
      everyn, ONE_OF_MANY, paramform, "Subset");
    XtVaSetValues(everyn_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    XtManageChild(everyn_cmd);
    XtAddCallback(everyn_cmd, XtNcallback,
      (XtCallbackProc) everyn_cback, (XtPointer) xg);

    everyn_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) everyn_cmd,
      XtNfromVert, (Widget) sample_label,
      XtNlabel, (String) " n ",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(everyn_label);

    everyn_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) everyn_label,
      XtNfromVert, (Widget) sample_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) everyn_str,
      NULL);
    if (mono) set_mono(everyn_text);

    everyn_init_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) everyn_text,
      XtNfromVert, (Widget) sample_label,
      XtNlabel, (String) "starting with",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(everyn_init_label);

    everyn_init_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) everyn_init_label,
      XtNfromVert, (Widget) sample_label,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) everyn_init_str,
      NULL);
    if (mono) set_mono(everyn_init_text);

    /*************************************************************
     * Added, James Brook, Oct 1994
     ************************************************************/
    sticky_ids_cmd = (Widget) CreateToggle(xg, "Use sticky label ids",
      True, (Widget) NULL, (Widget) everyn_cmd, (Widget) block_cmd,
      block, ONE_OF_MANY, paramform, "Subset");
    XtVaSetValues(sticky_ids_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    XtManageChild(sticky_ids_cmd);
    XtAddCallback(sticky_ids_cmd, XtNcallback,
      (XtCallbackProc) sticky_ids_cback, (XtPointer) xg);

    id_cmd = (Widget) CreateToggle(xg, "Use row id",
      True, (Widget) NULL, (Widget) sticky_ids_cmd, (Widget) block_cmd,
      block, ONE_OF_MANY, paramform, "Subset");
    XtVaSetValues(id_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    XtManageChild(id_cmd);
    XtAddCallback(id_cmd, XtNcallback,
      (XtCallbackProc) id_cback, (XtPointer) xg);

    id_label = XtVaCreateManagedWidget("Subset",
      labelWidgetClass, paramform,
      XtNfromHoriz, (Widget) id_cmd,
      XtNfromVert, (Widget) sticky_ids_cmd,
      XtNlabel, (String) "Row id ",
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainLeft,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      NULL);
    if (mono) set_mono(id_label);

    id_text = XtVaCreateManagedWidget("Subset",
      asciiTextWidgetClass, paramform,
      XtNfromHoriz, (Widget) id_label,
      XtNfromVert, (Widget) sticky_ids_cmd,
      XtNleft, (XtEdgeType) XtChainLeft,
      XtNright, (XtEdgeType) XtChainRight,
      XtNtop, (XtEdgeType) XtChainTop,
      XtNbottom, (XtEdgeType) XtChainTop,
      XtNresizable, (Boolean) True,
      XtNeditType, (int) XawtextEdit,
      XtNresize, (XawTextResizeMode) XawtextResizeWidth,
      XtNstring, (String) id_str,
      NULL);
    if (mono) set_mono(id_text);

    apply = (Widget) CreateCommand(xg, "Subset the data",
      1, (Widget) NULL, (Widget) paramform,
      sform, "Subset");
    XtManageChild(apply);
    XtAddCallback(apply, XtNcallback,
      (XtCallbackProc) subset_cback, (XtPointer) xg);

    rescale_cmd = (Widget) CreateCommand(xg, "Rescale",
      1, (Widget) apply, (Widget) paramform,
      sform, "SubsetRescale");
    XtManageChild(rescale_cmd);
    XtAddCallback(rescale_cmd, XtNcallback,
      (XtCallbackProc) rescale_cback, (XtPointer) xg);

    restore = (Widget) CreateCommand(xg, "Include all data",
      1, (Widget) rescale_cmd, (Widget) paramform,
      sform, "Subset");
    XtManageChild(restore);
    XtAddCallback(restore, XtNcallback,
      (XtCallbackProc) restore_cback, (XtPointer) xg);

    close = XtVaCreateManagedWidget("Close",
      commandWidgetClass, sframe,
      XtNshowGrip, (Boolean) False,
      XtNskipAdjust, (Boolean) True,
      XtNlabel, (String) "Click here to dismiss",
      NULL);
    if (mono) set_mono(close);
    XtAddCallback(close, XtNcallback,
      (XtCallbackProc) close_cback, (XtPointer) xg);
  }

  XtPopup(spopup, (XtGrabKind) XtGrabNone);
  XRaiseWindow(display, XtWindow(spopup));

  if (!initd)
  {
    set_wm_protocols(spopup);
    initd = 1;
  }
}

