/*
** qualList.c (from slist_template.c)
*/

# include "lclintMacros.nf"
# include "basic.h"

qualList
qualList_new ()
{
  return qualList_undefined;
}

static /*@only@*/ /*@notnull@*/ qualList
qualList_newEmpty (void)
{
  qualList s = (qualList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->free = qualListBASESIZE;
  s->elements = (qual *) dmalloc (sizeof (*s->elements) * qualListBASESIZE);

  return (s);
}

void
qualList_clear (qualList q)
{
  if (qualList_isDefined (q))
    {
      q->free += q->nelements;
      q->nelements = 0;
    }
}

static void
qualList_grow (/*@notnull@*/ qualList s)
{
  int i;
  qual *oldelements = s->elements;
  
  s->free += qualListBASESIZE; 

  s->elements = (qual *) dmalloc (sizeof (*s->elements) * (s->nelements + s->free));
    
  for (i = 0; i < s->nelements; i++)
    {
      s->elements[i] = oldelements[i];
    }
  
  sfree (oldelements);
}

qualList qualList_add (qualList s, qual el)
{
  if (qualList_isUndefined (s))
    {
      s = qualList_newEmpty ();
    }
  
  if (s->free <= 0)
    qualList_grow (s);
  
  s->free--;
  s->elements[s->nelements] = el;
  s->nelements++;

  return (s);
}

qualList qualList_appendList (qualList s, qualList t)
{
  qualList_elements (t, current)
    {
      s = qualList_add (s, current);
    } end_qualList_elements;

  return s;
}

# ifndef NOLCL
qualList qualList_copy (qualList s)
{
  qualList t = qualList_new ();

  qualList_elements (s, current)
    {
      t = qualList_add (t, current);
    } end_qualList_elements;

  return t;
}
# endif

/*@only@*/ cstring
qualList_unparse (qualList s)
{
   int i;
   cstring st = cstring_undefined;

   if (qualList_isDefined (s))
     {
       for (i = 0; i < qualList_size (s); i++)
	 {
	   if (i == 0)
	     {
	       st = message ("%q%s ", st, qual_unparse (s->elements[i]));
	     }
	   else
	     st = message ("%q%s ", st, qual_unparse (s->elements[i]));
	 }
     }

   return st;
}

# ifndef NOLCL
/*@only@*/ cstring
qualList_toCComments (qualList s)
{
   int i;
   cstring st = cstring_undefined;

   if (qualList_isDefined (s))
     {
       for (i = 0; i < qualList_size (s); i++)
	 {
	   if (i == 0)
	     {
	       st = message ("%q/*@%s@*/ ", st, qual_unparse (s->elements[i]));
	     }
	   else
	     st = message ("%q/*@%s@*/ ", st, qual_unparse (s->elements[i]));
	 }
     }

   return st;
}
# endif

bool
qualList_hasAliasQualifier (qualList s)
{
  if (qualList_isDefined (s))
    {
      qualList_elements (s, q)
	{
	  if (qual_isAliasQual (q)) return TRUE;
	} end_qualList_elements;
    }

  return FALSE;
}

bool
qualList_hasExposureQualifier (qualList s)
{
  if (qualList_isDefined (s))
    {
      qualList_elements (s, q)
	{
	  if (qual_isExQual (q)) return TRUE;
	} end_qualList_elements;
    }

  return FALSE;
}

void
qualList_free (/*@only@*/ qualList s)
{
  if (qualList_isDefined (s))
    {
      sfree (s->elements); 
      sfree (s);
    }
}




