/*
 * dnode2.c - SCO UnixWare node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */

/*
 * Copyright 1998 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode3.c,v 1.1 98/04/01 10:53:45 abe Exp $";
#endif


#include "lsof.h"

#include <sys/fs/bfs.h>


/*
 * readbfslino() - read bfs inode's local inode information
 */

int
readbfslino(v, i)
	struct vnode *v;		/* containing vnode */
	struct l_ino *i;		/* local inode information */
{
	struct inode b;
	struct vfs kv;

	if (kread((KA_T)v->v_data, (char *)&b, sizeof(b)))
	    return(1);
	if (v->v_vfsp && kread((KA_T)v->v_vfsp, (char *)&kv, sizeof(kv)) == 0)
	    i->dev = kv.vfs_dev;
	else
	    return(1);
	i->rdev = 0;
	i->number = b.i_diskino.d_ino;
	i->size = (SZOFFTYPE)BFS_FILESIZE(&b.i_diskino);
	return(0);
}
