/*
    bigint.c - Manage big positive integer numbers
    Copyright (c) 1996  Martin Schulze <joey@artis.uni-oldenburg.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: bigint.c,v 1.1.1.1 1997/06/03 20:48:34 joey Exp $
 */

#include "bigint.h"
#include <stdio.h>
#include <string.h>
#include <malloc.h>

bigint bigint_add(bigint a, bigint b)
{
  int i;
  unsigned long int tmp;
  bigint c;

  for (i=0; i<BIGINT_LEN; i++) {
    tmp = a.val[i] + b.val[i];
    if (tmp >= BIGINT_MAX) {
      c.val[i] = tmp - BIGINT_MAX;
      if (i<BIGINT_LEN)
	a.val[i+1]++;
      else
	fprintf(stderr, "Overflow in bigint addition.");
    } else
      c.val[i] = tmp;
  }
  return c;
}

bigint bigint_sub(bigint a, bigint b)
{
  /* FIXME */
  fprintf (stderr, "bigint_sub not supported yet.\n");
  return a;
}

bigint bigint_int(int num)
{
  bigint x;
  int i;

  for (i=0; i<BIGINT_LEN; i++) x.val[i] = 0L;
  x.val[0] = num;
  x.val[1] = 0;
  return x;
}

bigint bigint_string(char *s)
{
  char tmp[BIGINT_PREC+1];
  bigint a;
  int i;
  char *cp, *x;

  for (i=0; i<BIGINT_LEN; i++) a.val[i] = 0L;
  if ((x = (char *)malloc(strlen(s)+1))) {
    strcpy(x, s);
    for (i=0; i<BIGINT_LEN; i++) {
      if (strlen(x)) {
	cp = x;
	if (strlen(x) > BIGINT_PREC)
	  cp += (strlen(x) - BIGINT_PREC);
	strcpy(tmp, cp);
	*cp = '\0';
	sscanf(tmp, "%lu", &a.val[i]);
      }
    }
    free (x);
  }

  return a;
}

void bigint_sprintf (char *res, char *format, bigint a)
{
  char s[(BIGINT_PREC*BIGINT_LEN)+1];
  char tmp[BIGINT_PREC+1];
  char form[6];
  int i, max;

  bzero(s, sizeof(s));
  sprintf(form, "%%0%dlu", BIGINT_PREC);
  max = BIGINT_LEN;
  for (;max>0 && !a.val[max-1];max--);
  for (i=0; i<max; i++) {
    if (i<max-1)
      sprintf(tmp, form, a.val[i]);
    else
      sprintf(tmp, "%lu", a.val[i]);
    sprintf (res, "%s%s", tmp, s);
    sprintf (s, "%s", res);
  }
  sprintf (res, format, s);
}
