/* cp_format.c = this file contains the routines for creating the 
XView environment --- see XView Programming Manual */

#include "cp_head.h"
#include <xview/svrimage.h>
#include <X11/Xutil.h>
#include <xview/font.h>

Menu write_menu,sel_inq_menu,spec_inq_menu,clr_menu,param_menu,
	pack_menu,K_menu,R_menu,O_menu,C_menu,misc_menu,screen_opt_menu,
	color_menu,inquiry_menu,disp_opt_menu,screen_c_menu,cmd_menu,
	face_color_menu,cir_color_menu,remove_menu,add_menu,set_abc_menu,
	fix_menu,repack_menu,mob_menu,path_io_menu,circles_ofs_menu,
	complex_ofs_menu,label_menu,output_menu,print_menu;
Menu_item brush_m_item,err_m_item,toler_m_item,
	iter_m_item,cycle_m_item;
static int depth;
XSizeHints xhints;
long supplied;
void (*default_textsw_notify)();
Xv_Font basefont,ttfont;

/* ===================== base_frame ==================== */

void
frame_builder() 
{
	int i,p;

		/* create base frame and main panel */
	sprintf(buf,"CirclePack (dir; %s)",working_dir);
	base_frame=(Frame)xv_create((int)NULL,FRAME,
		WIN_X,0,WIN_Y,100,  
		XV_LABEL,buf,
		0);
		
/*	basefont=(Xv_Font)xv_find(base_frame,
		FONT,FONT_NAME,"lucidasans-italic-12",NULL);
	if (!basefont)
	 {
	 	printf("couldn't create font\n");
	 	basefont=(Xv_Font)xv_get(base_frame,XV_FONT);
	 }
	 
	xv_set(base_frame,FONT,basefont,NULL);
*/ 	
	create_panel_sw();
	create_special_menu();
	create_cursors();
	window_fit_height(base_frame);

		/* prepare color ramp and cms */

	blue_to_red_ramp();
	for (i=1;i<40;i++)
	{
		cms_colors[i].red=red[i];
		cms_colors[i].green=green[i];
		cms_colors[i].blue=blue[i];
	}
	cms_colors[0].red=cms_colors[0].green=
		cms_colors[0].blue=255;
	cms_colors[BG_COLOR].red=cms_colors[BG_COLOR].green=
		cms_colors[BG_COLOR].blue=255;
	cms_colors[FG_COLOR].red=cms_colors[FG_COLOR].green=
		cms_colors[FG_COLOR].blue=0;
	cms = (Cms)xv_create((int)NULL, CMS,
		CMS_NAME,           "blue_to_red_ramp",
        	CMS_CONTROL_CMS,    FALSE,
		CMS_TYPE,           XV_STATIC_CMS,
		CMS_SIZE,           42,
		CMS_COLORS,         cms_colors,
		NULL);

		/* set Xlib graphics context, etc */

	display=(Display *)xv_get(base_frame,XV_DISPLAY);
	depth=(int)DefaultDepth(display,DefaultScreen(display));
	if (depth<2) depth=1;
/*	else depth=8; */
	if (!(font=XLoadQueryFont(display,"-adobe-helvetica-medium-*-normal-*-10-*-*-*-*-*-*-*")))
	 {
		strcpy(msgbuf,"Couldn't load fixed font");
		emsg();
	 }
	gc_val.font=font->fid;
	gc_val.stipple=XCreateBitmapFromData(display,
		(XID)xv_get(base_frame,XV_XID),stipple_bits,16,2);
	gc=XCreateGC(display,
		(XID)xv_get(base_frame,XV_XID),GCFont,&gc_val);
	XSetFillStyle(display,gc,FillSolid);
	gc_fill=XCreateGC(display,
		(XID)xv_get(base_frame,XV_XID),GCFont | GCStipple,&gc_val);
	XSetFillStyle(display,gc_fill,FillStippled);
	XSetLineAttributes(display,gc,0,LineSolid,CapButt,JoinRound);
	XSetLineAttributes(display,gc_fill,0,LineSolid,CapButt,JoinRound);
	colors = (unsigned long *)xv_get(cms,CMS_INDEX_TABLE);
	bgcolor=(unsigned long)xv_get(cms,CMS_BACKGROUND_PIXEL);
	fgcolor=(unsigned long)xv_get(cms,CMS_FOREGROUND_PIXEL);
/*
	bgcolor=colors[0];fgcolor=colors[FG_COLOR];
*/
	XSetForeground(display,gc,fgcolor);
	XSetBackground(display,gc,bgcolor);
	XSetBackground(display,gc_fill,bgcolor);
/* ??	XSetForeground(display,gc_fill,bgcolor); */
	XSetForeground(display,gc_fill,fgcolor);

		/* create canvases and their frames */

	create_canvas_frames();

		/* create other windows */
	create_subwindows();
	create_manip_frame();
	create_config_win();
	create_screen_popups();
	create_script_frame();
	
	for (p=0;p<NUM_PACKS;p++) clear_canvas(&screendata[p]);

	printf("Done.\n");

/* set "hints" for window placement */

/*	XGetWMNormalHints(display,base_frame,&xhints,&supplied);
	xhints.flags = USPosition;

	xhints.x=0;xhints.y=600;
	XSetWMNormalHints(display,base_frame,&xhints);

	xhints.x=615;xhints.y=765;
	XSetWMNormalHints(display,script_frame,&xhints);

	xhints.x=450;xhints.y=10;
	XSetWMNormalHints(display,setup_frame,&xhints);

	xhints.x=0;xhints.y=760;
	XSetWMNormalHints(display,cmd_frame,&xhints);

	xhints.x=0;xhints.y=800;
	XSetWMNormalHints(display,msg_frame,&xhints);

	xhints.x=610;xhints.y=760;
	XSetWMNormalHints(display,text_frame,&xhints);
	
	for (i=0;i< NUM_PACKS;i++)
	 {
		xhints.x=770;xhints.y=50+i*20;
		XSetWMNormalHints(display,screen_frame[i],&xhints);
	 }
	
*/

} /* frame_builder */

create_panel_sw() /* creates main panel */
{
	int num_packs=NUM_PACKS;
	
	void pack_proc(),Radjust_proc(), cmd_up_proc(),
		inquiry_proc(),Kadjust_proc(),help_proc(),quit_proc(),
		active_p_proc(),screen_up_proc(),setup_proc(),
		misc_proc(),sel_print_proc(),history_proc(),
		special_proc(),Cadjust_proc(),Oadjust_proc(),
		cmd_proc(),color_proc(),script_up_proc(),
		print_proc(),handle_pack_proc(),handle_screen_up_proc(),
		handle_radjust_proc(),handle_cadjust_proc(),
		handle_kadjust_proc(),handle_inquiry_proc(),handle_misc_proc(),
		scr_popup_proc(),show_manip_frame_proc(),
		handle_c_menu_proc(),circles_ofs_proc(),ms_repack_proc(),
		quicksave_proc(),show_path_proc(),
		complex_ofs_proc(),clr_proc(),output_proc(),
		label_proc(),cir_com_proc(),handle_cmd_proc(),
		handle_oadjust_proc(),handle_write_proc(),
		handle_sel_inq_proc(),handle_spec_inq_proc(),
		handle_face_color_proc(),handle_cir_color_proc(),
		handle_set_abc_proc(),handle_add_proc(),handle_remove_proc(),
		handle_fix_proc(),handle_mob_proc(),handle_repack_proc(),
		handle_path_io_proc();

	write_menu=menu_create(MENU_STRINGS,
		"standard","  -c combinatorics","  -m minimal",
		"  -M maximal","  -s to script file","eucl_write",0,
		MENU_NOTIFY_PROC,handle_write_proc,
		0);

	path_io_menu=menu_create(MENU_STRINGS,
		"read_path <file>","write_path <file>",0,
		MENU_NOTIFY_PROC,handle_path_io_proc,
		0);		 

	pack_menu=menu_create(MENU_STRINGS,
		"read <file>",0,
		MENU_ITEM,
			MENU_STRING,"write <file>",
			MENU_PULLRIGHT,write_menu,
			0,
		MENU_STRINGS, "copy <p>","seed <n>",0,
		MENU_ITEM,
			MENU_STRING,"path r/w",
			MENU_PULLRIGHT,path_io_menu,
			0,
		MENU_NOTIFY_PROC,handle_pack_proc,
		0);

	if (num_packs==4)
	 {
		screen_opt_menu=menu_create(MENU_STRINGS,
			"Pack 0 ...",
			"Pack 1 ...",
			"Pack 2 ...",
			"Pack 3 ...",
			0,
			MENU_NOTIFY_PROC,handle_screen_up_proc,
			0);
	 }
	else if (num_packs==3)
	 {
		screen_opt_menu=menu_create(MENU_STRINGS,
			"Pack 0 ...",
			"Pack 1 ...",
			"Pack 2 ...",0,
			MENU_NOTIFY_PROC,handle_screen_up_proc,
			0);
	 }
	else if (num_packs==2)
	 {
		screen_opt_menu=menu_create(MENU_STRINGS,
			"Pack 0 ...",
			"Pack 1 ...",0,
			MENU_NOTIFY_PROC,handle_screen_up_proc,
			0);
	 }
	else 
	 {
		screen_opt_menu=menu_create(MENU_STRINGS,
			"Pack 0 ...",0,
			MENU_NOTIFY_PROC,handle_screen_up_proc,
			0);
	 }

	set_abc_menu=menu_create(MENU_STRINGS,
		"alpha <v>","beta <v>","gamma <v>","node_active <v>",0,
		MENU_NOTIFY_PROC,handle_set_abc_proc,
		0);

	add_menu=menu_create(MENU_STRINGS,
		"add_cir <v..>","add_layer <v w d>",
		"add_gen <n d>","add_ideal <v>",0,
		MENU_NOTIFY_PROC,handle_add_proc,
		0);

	remove_menu=menu_create(MENU_STRINGS,
		"rm_circle <v>","rm_edge <v w...>",0,
		MENU_NOTIFY_PROC,handle_remove_proc,
		0);

	K_menu=menu_create(
		MENU_ITEM,
			MENU_STRING,"Add circles",
			MENU_PULLRIGHT,add_menu,
			0,
		MENU_STRINGS,
		"enclose <n v..>","adjoin <p q v w n>",
		"cookie (cutout)",0,
		MENU_ITEM,
			MENU_STRING,"Remove",
			MENU_PULLRIGHT,remove_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Set nodes",
			MENU_PULLRIGHT,set_abc_menu,
			0,
		MENU_STRINGS,
		"swap <v w>",
		"---------------",0,
		MENU_NOTIFY_PROC,handle_kadjust_proc,
		0);

	R_menu=menu_create(MENU_STRINGS,
		"set_rad <r v..>","all bdry to infty",
		"inc_rad <v..>","  - inc all bdry radii",
		"dec_rad <v..>","  - dec all bdry radii",
		"set_random <v..>","scale <t>","spiral <a b>",0,
		MENU_NOTIFY_PROC,handle_radjust_proc,
		0);

	C_menu=menu_create(MENU_STRINGS,
		"Set Andreev","set_aim <a v..>",
		"Reset, current","Reset, default",0,
		MENU_NOTIFY_PROC,handle_cadjust_proc,
		0);

	O_menu=menu_create(MENU_STRINGS,
		"set_over <a>","set_over <a (v w)..>",
		"Reset to 0",0,
		MENU_NOTIFY_PROC,handle_oadjust_proc,
		0);

	print_menu=menu_create(
		MENU_GEN_PIN_WINDOW, base_frame,"Print Menu",
		MENU_STRINGS,
		"Open/Clear file",
		"selected data:","    - unit circle",
		"    - open crcls <v..>","    - filled crcls <v..>",
		"    - open faces <f..>","    - filled faces <f..>",
		"    - geodesics <v w..>","    - circle labels <v..>",
		"    - face labels <v..>",
		"    - caption","    - include pack <p>","    - current path",
		"Close file","send to printer",
		"--------------------","print canvas ps file",0,
		MENU_NOTIFY_PROC,print_proc,
		0);

	cir_color_menu=menu_create(MENU_STRINGS,
		"fg (foreground)","bg (background)",
		"rad (radii)","-q (compare to) <p>",
		"selected < c v..>",
		"-p (copy from) <p>",
		"-k (model curvature) <x>",0,
		MENU_NOTIFY_PROC,handle_cir_color_proc,
		0);

	face_color_menu=menu_create(MENU_STRINGS,
		"fg (foreground)","bg (background)",
		"area","-q (compare to) <p>",
		"selected < c f..>",
		"-p (copy from) <p>",0,
		MENU_NOTIFY_PROC,handle_face_color_proc,
		0);

	color_menu=menu_create(
		MENU_ITEM,
			MENU_STRING,"Circles: color -c",
			MENU_PULLRIGHT,cir_color_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Faces: color -f",
			MENU_PULLRIGHT,face_color_menu,
			0,
		0);

	sel_inq_menu=menu_create(MENU_STRINGS,
		"?flower <v..>","?rad <v..>","?ang_sum <v..>","?aim <v..>",
		"?face <f..>","?overlap <v w..>","?cent <v..>",
		"?alt_rad <v..>","?kappa <v..>",0,
		MENU_NOTIFY_PROC,handle_sel_inq_proc,
		0);

	spec_inq_menu=menu_create(MENU_STRINGS,
		"?curv_err","?bdry_dist",
		"?ratio_ftn <p q>","?conductance <v..>",
		"?remote processes",0,
		MENU_NOTIFY_PROC,handle_spec_inq_proc,
		0);

	inquiry_menu=menu_create(MENU_STRINGS,
		"?vert <v>","?pack <p>",0,
		MENU_ITEM,
			MENU_STRING,"selected data:",
			MENU_PULLRIGHT,sel_inq_menu,
			0,
		MENU_STRINGS,
		"?screen (data)","?parameters",0,
		MENU_ITEM,
			MENU_STRING,"Specials:",
			MENU_PULLRIGHT,spec_inq_menu,
			0,
		MENU_NOTIFY_PROC,handle_inquiry_proc,
		0);

	repack_menu=menu_create(MENU_STRINGS,
		"repack <N>","repack -v <v..>",0,
		MENU_NOTIFY_PROC,handle_repack_proc,
		0);

	mob_menu=menu_create(MENU_STRINGS,
		"center_vert <v>","center_point <x y>","rotate <a>*Pi",
		"Mobius <v..>","Mobius_inv <v..>",0,
		MENU_NOTIFY_PROC,handle_mob_proc,
		0);

	fix_menu=menu_create(MENU_STRINGS,
		"fix","   - angle sums","   - centers",
		"   - aims (default)","   - combinatorics","Fix", 0,
		MENU_NOTIFY_PROC,handle_fix_proc,
		0);

	misc_menu=menu_create(
		MENU_ITEM,
			MENU_STRING,"Repack",
			MENU_PULLRIGHT,repack_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Mobius transform",
			MENU_PULLRIGHT,mob_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Recompute (fix)",
			MENU_PULLRIGHT,fix_menu,
			0,
		MENU_STRINGS,
		"geom_to_s (conversion)",
		"geom_to_e (conversion)",
		"geom_to_h (conversion)",0,
		MENU_NOTIFY_PROC,handle_misc_proc,
		0);

	clr_menu=menu_create(MENU_STRINGS,
		"Clear/Repeat","Clear",0,
		MENU_NOTIFY_PROC,clr_proc,
		0);

	circles_ofs_menu=menu_create(MENU_STRINGS,
		"Open","Filled","Selected","Marked",0,
		MENU_NOTIFY_PROC,circles_ofs_proc,
		0);

	complex_ofs_menu=menu_create(MENU_STRINGS,
		"Open","Filled","Selected","Marked",0,
		MENU_NOTIFY_PROC,complex_ofs_proc,
		0);

	label_menu=menu_create(MENU_STRINGS,
		"Circles","Faces","Caption",0,
		MENU_NOTIFY_PROC,label_proc,
		0);

	output_menu=menu_create(MENU_STRINGS,
		"No action",
		"print (PostScript)",0,
		MENU_NOTIFY_PROC,output_proc,
		0);

	disp_opt_menu=menu_create(MENU_NCOLS, 1,
		MENU_ITEM,
			MENU_STRING,"Clear",
			MENU_PULLRIGHT,clr_menu, 
			0,
		MENU_ITEM,
			MENU_STRING,"Circles",
			MENU_PULLRIGHT,circles_ofs_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Complex",
			MENU_PULLRIGHT,complex_ofs_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Circles & Complex",
			MENU_NOTIFY_PROC,cir_com_proc,
			0,
		MENU_ITEM,
			MENU_STRING,"Label",
			MENU_PULLRIGHT,label_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"Path",
			MENU_NOTIFY_PROC,show_path_proc,
			0,
		MENU_ITEM,
			MENU_STRING,"Manipulations...",
			MENU_NOTIFY_PROC, show_manip_frame_proc,
			0,
		MENU_ITEM,
			MENU_STRING,"Screen Popup...",
			MENU_NOTIFY_PROC,scr_popup_proc,
			0,
		MENU_ITEM,
			MENU_STRING,"Output",
			MENU_PULLRIGHT,output_menu,
			0,
		MENU_ITEM,
			MENU_STRING,"repack/fix",
			MENU_NOTIFY_PROC, ms_repack_proc,
			0,
		MENU_ITEM,
			MENU_STRING,"quicksave -> tmp?.p",
			MENU_NOTIFY_PROC, quicksave_proc,
			0,
		0);

	screen_c_menu=menu_create(MENU_STRINGS,
		"move <v> to center","move <x y> to center",0,
		MENU_NOTIFY_PROC,handle_c_menu_proc,
		0);     /* menu for screen popups */

	cmd_menu=menu_create(MENU_NCOLS,1,MENU_STRINGS,
		"!! (repeat last)","exec select cmd",
		"print last cmd ??",0,
		MENU_NOTIFY_PROC,handle_cmd_proc,
		0);

/* ============ create big panel ============= */

	panel=(Panel)xv_create(base_frame,PANEL,
		PANEL_ITEM_Y_GAP,3,
		XV_HELP_DATA,"cp_help:Main panel",
		0);
		
/* ============= top row; action choice ==========*/

	active_pack_item=xv_create(panel,PANEL_CHOICE,
		PANEL_CHOICE_NROWS,1,
		PANEL_LAYOUT,PANEL_HORIZONTAL,
		PANEL_FEEDBACK,PANEL_INVERTED,
		PANEL_NOTIFY_PROC,active_p_proc,
		0);
		
/* ============== second row ================= */

	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Read/Write Files",
		PANEL_NEXT_ROW,-1,
		PANEL_LABEL_STRING,"Read/Write Files",
		PANEL_EVENT_PROC,pack_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:COMBINATORIC changes",
		PANEL_LABEL_STRING,"COMBINATORIC changes",
		PANEL_EVENT_PROC,Kadjust_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON, 
		XV_HELP_DATA,"cp_help:Command Line...",
		PANEL_LABEL_STRING,"Command Line  ...",
		PANEL_NOTIFY_PROC,cmd_up_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Misc Computations",
		PANEL_LABEL_STRING,"Misc Computations   ",
		PANEL_EVENT_PROC,misc_proc,
		0);
		
/* ============== third row ================= */
		
		
	(void)  xv_create(panel,PANEL_BUTTON, 
		XV_HELP_DATA,"cp_help:Open Canvases",
		PANEL_LABEL_STRING,"Open Canvases ",
		PANEL_EVENT_PROC,screen_up_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:RADIUS changes",
		PANEL_LABEL_STRING,"RADIUS changes              ",
		PANEL_EVENT_PROC,Radjust_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON, 
		XV_HELP_DATA,"cp_help:Config Window...",
		PANEL_LABEL_STRING,"Config Window  ...",
		PANEL_NOTIFY_PROC,setup_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Pack COLOR Coding",
		PANEL_LABEL_STRING,"Pack COLOR Coding  ",
		PANEL_EVENT_PROC,color_proc,
		0);  

/* ============== fourth row ================= */
	

	cmd_button_item=xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Line Commands",
		PANEL_LABEL_STRING,"Line Commands",
		PANEL_EVENT_PROC,cmd_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:ANGLE SUM changes",
		PANEL_LABEL_STRING,"ANGLE SUM changes       ",
		PANEL_EVENT_PROC,Cadjust_proc,
		0);
		
	(void)  xv_create(panel,PANEL_BUTTON, 
		XV_HELP_DATA,"cp_help:Script Window...",
		PANEL_LABEL_STRING,"Script Window   ...",
		PANEL_NOTIFY_PROC,script_up_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:PostScript Printing",
		PANEL_LABEL_STRING,"Postscript Printing     ",
		PANEL_EVENT_PROC,sel_print_proc,
		0);

/* ============== fifth row ================= */
			

	(void) 	xv_create(panel,PANEL_BUTTON, 
		XV_HELP_DATA,"cp_help:Inquiries",
		PANEL_LABEL_STRING,"Pack Inquiries   ",
		PANEL_EVENT_PROC,inquiry_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:OVERLAP ANGLE changes",
		PANEL_LABEL_STRING,"OVERLAP ANGLE changes",
		PANEL_EVENT_PROC,Oadjust_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:History Window...",
		PANEL_LABEL_STRING,"History Window ...",
		PANEL_NOTIFY_PROC,history_proc,
		0);

	(void)  xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Special Routine Calls",
		PANEL_LABEL_STRING,"Special Routine Calls ",
		PANEL_EVENT_PROC,special_proc,
		0);

/* ============== sixth row ================= */


	(void) 	xv_create(panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Help Window...",
		PANEL_LABEL_STRING,"Help Window  ...",
		PANEL_NOTIFY_PROC,help_proc,
		0);

	(void) 	xv_create(panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"QUIT",
		PANEL_NOTIFY_PROC,quit_proc,
		0);

	window_fit(panel);
	window_fit(base_frame);

} /* create_panel_sw */

create_script_frame() /* creates a popup window for running scripts */
{
	void	next_script_proc(),find_script_proc(),close_script_proc(),
		reset_script_proc(),script_sw_notify_proc();
	Panel	script_panel;
	Textsw_index pos;
	
	script_frame=(Frame)xv_create(base_frame,FRAME,
		FRAME_SHOW_LABEL,TRUE,XV_LABEL,
		"Script Window - (NONE)",
		WIN_X,500,WIN_Y,10,XV_WIDTH,600,XV_HEIGHT,30,
		0); 

	script_panel=(Panel)xv_create(script_frame,PANEL,
		XV_HELP_DATA,"cp_help:Script Window",
		0);

	(void)	xv_create(script_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Execute next cmd",
		PANEL_NOTIFY_PROC,next_script_proc,
		0);

	(void)	xv_create(script_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Highlight next cmd",
		PANEL_NOTIFY_PROC,find_script_proc,
		0);

	(void) 	xv_create(script_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Reset to top",
		PANEL_NOTIFY_PROC,reset_script_proc,
		0);

	(void) 	xv_create(script_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Close",
		PANEL_NOTIFY_PROC,close_script_proc,
		0);

	script_sw=(Textsw)xv_create(script_frame,TEXTSW,
/*		XV_FONT,basefont, */
		WIN_ROWS,20,
		WIN_WIDTH,600, 
		TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
		TEXTSW_MEMORY_MAXIMUM,200000,
/*		TEXTSW_ACTION_LOADED_FILE,TRUE, */
		0);

	pos=(Textsw_index)xv_get(script_sw,TEXTSW_INSERTION_POINT);		
	script_file_data_mark=script_file_cmd_mark=(Textsw_mark)
		textsw_add_mark(script_sw,pos,TEXTSW_MARK_DEFAULTS);
	default_textsw_notify=(void (*)())xv_get(script_sw,TEXTSW_NOTIFY_PROC);
	xv_set(script_sw,TEXTSW_NOTIFY_PROC,script_sw_notify_proc,0);

	window_fit(script_frame);

} /* create_script_frame */
	

create_config_win() /* creates popup window for setup items */
{
	void	factor_inc_proc(),eucl_factor_proc(),fill_pattern_proc(),
		handle_param_proc(),close_setup_proc(),param_proc();
	Panel setup_panel;
	int line;

	setup_frame=(Frame)xv_create(base_frame,FRAME,
		FRAME_SHOW_LABEL,TRUE,XV_LABEL,"Program Configuration Window",
		WIN_X,600,WIN_Y,10,XV_HEIGHT,200, 
		0);

	setup_panel=(Panel)xv_create(setup_frame,PANEL,
		XV_HELP_DATA,"cp_help:Program Parameters",
		0);

	xv_set(setup_panel,XV_HELP_DATA,"Program Configuration Window:",
		0);

	param_menu=menu_create(MENU_STRINGS,
		"set_cycle <n>","set_iter <n> ","set_accur <x>",
		"  (set_toler <x>)","  (set_err <x>)",
		"set_post_size <n> ","set_brush <n>",0,
		MENU_NOTIFY_PROC,handle_param_proc,
		0);
		
	line=22;
	dir_name_item=(Panel_item)xv_create(setup_panel,PANEL_TEXT,
		PANEL_LABEL_STRING," Directory path:     ",
		PANEL_VALUE_DISPLAY_LENGTH,36,
		XV_X,xv_col(setup_panel,0),
		XV_Y,10,
 		0); 

	ps_file_item=(Panel_item)xv_create(setup_panel,PANEL_TEXT, 
		PANEL_LABEL_STRING," Canvas print file: ",
		PANEL_VALUE_DISPLAY_LENGTH,36,
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*1+10,
 		0); 		/* for usual postscript screen print */

	print_file_item=(Panel_item)xv_create(setup_panel,PANEL_TEXT,
		PANEL_LABEL_STRING," Custom print file: ",
		PANEL_VALUE_DISPLAY_LENGTH,36,
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*2+10,
 		0); 		/* for postscript printing from button */

	print_com_item=(Panel_item)xv_create(setup_panel,PANEL_TEXT,
		PANEL_LABEL_STRING," Printer command: ",
		PANEL_VALUE_DISPLAY_LENGTH,36,
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*3+10,
 		0); 

/*	remote_name_item=(Panel_item)xv_create(setup_panel,PANEL_TEXT,
		PANEL_LABEL_STRING," Remote machine:  ",
		PANEL_VALUE_DISPLAY_LENGTH,36,
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*4+10,
 		0); 
*/

	radius_inc=(Panel_item)xv_create(setup_panel,PANEL_SLIDER,
		PANEL_LABEL_STRING,"  rad incr   (%): ",
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*4+10,
		PANEL_VALUE, (int)(log(inc_factor)/log(2.0)/0.01),
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_SLIDER_WIDTH, 100,
		PANEL_NOTIFY_PROC,factor_inc_proc,
		0);

	Eucl_factor=(Panel_item)xv_create(setup_panel,PANEL_SLIDER,
		PANEL_LABEL_STRING,"  eucl incr (%): ",
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*5+10,
		PANEL_VALUE, (int)(eucl_factor/0.01),
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 150,
		PANEL_SLIDER_WIDTH, 150,
		PANEL_NOTIFY_PROC,eucl_factor_proc,
		0);

	(void)	(Panel_item)xv_create(setup_panel,PANEL_BUTTON,
		XV_HELP_DATA,"cp_help:Program Parameters",
		XV_X,xv_col(setup_panel,3),
		XV_Y,line*6+10,
		PANEL_LABEL_STRING,"Program Parameters",
		PANEL_EVENT_PROC,param_proc,
		0);
		
	fill_pattern=(Panel_item)xv_create(setup_panel,PANEL_CYCLE,
		XV_HELP_DATA,"cp_help:Fill pattern",
		PANEL_LABEL_STRING,
		"  Fill pattern:",
		XV_X,xv_col(setup_panel,22),
		XV_Y,line*6+10,
		PANEL_CHOICE_STRINGS,
		"stippled (default)","solid",0,
		PANEL_VALUE,0,
		PANEL_CLIENT_DATA," 5 ",
		PANEL_NOTIFY_PROC, fill_pattern_proc,
		0);

	close_setup_item=(Panel_item)xv_create(setup_panel,PANEL_BUTTON,
		XV_X,xv_col(setup_panel,0),
		XV_Y,line*7+10,
		PANEL_LABEL_STRING,"Close",
		PANEL_NOTIFY_PROC,close_setup_proc,
		0);
		
	window_fit(setup_panel);

	frame_fit_all(setup_frame);

} /* create_config_win */

create_screen_popups() /* create popup windows for screen settings */
{
	register int p;
	void screen_toggles_proc(),screen_coord_proc(),reset_proc();
	void screen_size_proc(),screen_factor_proc(),close_popup_proc();
	void screen_c_proc(),s_display_proc();
	Panel screen_panel;

	for (p=0;p<NUM_PACKS;p++)
	 {
	   sprintf(buf,"Screen %d popup:",p);

	   screen_frame[p]=(Frame)xv_create(canvas_frame[p],FRAME,
		FRAME_LABEL,buf,
		0);

	   screen_panel=(Panel)xv_create(screen_frame[p],PANEL,
		XV_HELP_DATA,"cp_help:Screen popup",
		WIN_ROW_GAP,6,
		0);

/* ====================== first row ====================== */

	   sdp[p]=(Panel_item)xv_create(screen_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Redraw",
		PANEL_NOTIFY_PROC,s_display_proc,
		0);

	   scent[p]=(Panel_item)xv_create(screen_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Choose center",
		PANEL_EVENT_PROC,screen_c_proc,
		0);

	   ssize[p]=(Panel_item)xv_create(screen_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Do Resize",
		PANEL_NOTIFY_PROC,screen_size_proc,
		0);

/* ============================ second row ================== */

	   sfac[p]=(Panel_item)xv_create(screen_panel,PANEL_SLIDER,
		PANEL_LABEL_STRING,"Resize (%):",
		PANEL_NEXT_ROW,-1,
		PANEL_VALUE, 0,
		PANEL_MIN_VALUE, -100,
		PANEL_MAX_VALUE, 100,
		PANEL_SLIDER_WIDTH, 180,
		PANEL_NOTIFY_PROC,screen_factor_proc,
		0);

/* ============================ third row ================== */

	   sopt[p]=(Panel_item)xv_create(screen_panel,PANEL_CYCLE,
		PANEL_NEXT_ROW,-1,
		PANEL_CHOICE_STRINGS,
			"No coord axes","Show coords",0,
		PANEL_VALUE,1,
		PANEL_NOTIFY_PROC,screen_coord_proc,
		0);

	   tog[p]=(Panel_item)xv_create(screen_panel,PANEL_CYCLE,
		PANEL_CHOICE_STRINGS,
			"Draw unit circ","No unit circ",0,
		PANEL_VALUE,0,
		PANEL_NOTIFY_PROC,screen_toggles_proc,
		0);

/* ============================ fourth row ================== */

	   rset[p]=(Panel_item)xv_create(screen_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"RESET",
		PANEL_NEXT_ROW,-1,
		PANEL_NOTIFY_PROC,reset_proc,
		0);

	   clsup[p]=(Panel_item)xv_create(screen_panel,PANEL_BUTTON,
		PANEL_LABEL_STRING,"Close",	
		PANEL_NOTIFY_PROC,close_popup_proc,
		0);

	   window_fit(screen_panel); 
	   
	   window_fit(screen_frame[p]);
	 }
} /* create_screen_popups */

create_subwindows() /* creates the text subwindows */
{
	Panel cmd_panel;
	void cmd_line_proc();
	FILE *tmpfp;

	cmd_frame=(Frame)xv_create(base_frame,FRAME,
		XV_LABEL,"Command line:",
		FRAME_SHOW_HEADER,FALSE,
		0);

	cmd_panel=(Panel)xv_create(cmd_frame,PANEL,
		XV_HELP_DATA,"cp_help:Command",
		0);
	
	cmd_item=(Panel_item)xv_create(cmd_panel,PANEL_TEXT,
		PANEL_LABEL_STRING,"Command: ",
		PANEL_VALUE_DISPLAY_LENGTH,120,
		XV_X,xv_col(cmd_panel,0),
		XV_Y,xv_row(cmd_panel,0)+8,
		PANEL_NOTIFY_PROC,cmd_line_proc, 
 		0);
 
	window_fit(cmd_frame);

	msg_frame=(Frame)xv_create(base_frame,FRAME,
		XV_LABEL,"Messages/Errors:",
		0);

	msg_sw=(Textsw)xv_create(msg_frame,TEXTSW,
/*		XV_FONT,basefont, */
		WIN_ROWS,5,
		WIN_WIDTH,600,
		TEXTSW_DISABLE_CD,TRUE,
		TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
		TEXTSW_MEMORY_MAXIMUM,1000000,
		0);

	xv_set(xv_get(msg_sw,OPENWIN_NTH_VIEW,NULL),
		XV_HELP_DATA,"cp_help:Messages/Errors",
		0);
	
	window_fit(msg_frame);

	text_frame=(Frame)xv_create(base_frame,FRAME,
		XV_LABEL,"Scratch Window:",
		0); 

/*	ttfont=(Xv_Font)xv_find(text_frame,
		FONT,FONT_NAME,"lucidasans-12",NULL);
	if (!ttfont)
	 {
	 	printf("couldn't create font");
	 	ttfont=(Xv_Font)xv_get(base_frame,XV_FONT);
	 }
*/
	scratch_sw=(Textsw)xv_create(text_frame,TEXTSW,
/*		XV_FONT,ttfont, */
		TEXTSW_DISABLE_CD,TRUE,
		TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
		0);


	xv_set(scratch_sw,FONT,basefont,NULL);
	
	xv_set(xv_get(scratch_sw,OPENWIN_NTH_VIEW,NULL),
		XV_HELP_DATA,"cp_help:Scratch Window",
		0);

	window_fit(text_frame);

	history_frame=(Frame)xv_create(base_frame,FRAME,
		XV_HELP_DATA,"cp_help:History Window...",
		FRAME_SHOW_LABEL,TRUE,XV_LABEL,"History file:",
		WIN_X,630,WIN_Y,200, 
		0);

	log_sw=(Textsw)xv_create(history_frame, TEXTSW,
/*		XV_FONT,ttfont, */
		WIN_ROWS,20,WIN_COLUMNS,30,
		TEXTSW_MEMORY_MAXIMUM,200000,
		TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
		0);

	xv_set(xv_get(log_sw,OPENWIN_NTH_VIEW,NULL),
		XV_HELP_DATA,"cp_help:History file",
		0);
	
	window_fit(history_frame);

	help_frame=(Frame)xv_create(base_frame,FRAME,
		FRAME_SHOW_LABEL,TRUE,XV_LABEL,"Help file:",
		WIN_X,560,WIN_Y,400, 
		0);

	help_sw=(Textsw)xv_create(help_frame,TEXTSW,
/*		XV_FONT,basefont, */
		WIN_ROWS,15,WIN_COLUMNS,80,
		TEXTSW_DISABLE_CD,TRUE,
		TEXTSW_BROWSING,TRUE,
		0);
		
	if ((tmpfp=fopen("cp_help.info","r"))!=NULL)
	 {
		fclose(tmpfp);
		xv_set(help_sw,TEXTSW_FILE,"cp_help.info",
			0);
	 }

	xv_set(xv_get(help_sw,OPENWIN_NTH_VIEW,NULL),
		XV_HELP_DATA,"cp_help:Help file",
		0);

	window_fit(help_frame);

} /* create_subwindows */

create_canvas_frames() /* create the canvases and their frames */
{
	int p;
	extern void canvas_evt(),canvas_s_proc(),cl_pr_proc(),
		canvas_repaint_proc();

	for (p=0;p<NUM_PACKS;p++)
	 {
		canvas_frame[p]=(Frame)xv_create(base_frame,FRAME,
			FRAME_DONE_PROC,cl_pr_proc,
			FRAME_SHOW_LABEL,TRUE,
			0);

		canvas[p]=(Canvas)xv_create(canvas_frame[p],CANVAS,
			XV_HELP_DATA,"cp_help:Canvas",
			CANVAS_AUTO_SHRINK,FALSE,
			CANVAS_AUTO_EXPAND,FALSE,
			CANVAS_WIDTH,MAX_PIXEL,CANVAS_HEIGHT,MAX_PIXEL,	
			CANVAS_REPAINT_PROC, canvas_repaint_proc, 
			CANVAS_X_PAINT_WINDOW,TRUE,
			0);

		xv_set(canvas_paint_window(canvas[p]),
			WIN_CONSUME_EVENTS,WIN_NO_EVENTS,
			WIN_ASCII_EVENTS,
			WIN_MOUSE_BUTTONS,LOC_DRAG,NULL,
			0);
	
		screendata[p].xid=
		   (XID)xv_get(canvas_paint_window(canvas[p]),XV_XID);
		screendata[p].xpm=
		   XCreatePixmap(display,screendata[p].xid,
		   	MAX_PIXEL,MAX_PIXEL,depth);
		XFillRectangle(display,screendata[p].xpm,
			gc_fill,0,0,MAX_PIXEL,MAX_PIXEL);
		xv_set(canvas_paint_window(canvas[p]),
			WIN_EVENT_PROC,canvas_evt,
			NULL);
		if (p==0) xv_set(canvas_paint_window(canvas[p]),
			WIN_CURSOR,act_can_cursor,0);
		else xv_set(canvas_paint_window(canvas[p]),
			WIN_CURSOR,inact_can_cursor,0);

		window_fit(canvas_frame[p]);
	 }
	for (p=0;p<NUM_PACKS;p++) 
		xv_set(canvas_frame[p],WIN_EVENT_PROC,canvas_s_proc,0);


} /* create_canvas_frames */

create_manip_frame()
{
	int i;
	Panel panl;
	extern void manip_frame_done_proc(),manip_proc();
	
	for (i=0;i<NUM_PACKS;i++)
	 {
		sprintf(buf,"Manip, p%d",i);
		manip_frame[i]=(Frame)xv_create(canvas_frame[i],FRAME_CMD,
			FRAME_CMD_DEFAULT_PIN_STATE,FRAME_CMD_PIN_IN,
			FRAME_LABEL,buf,
			FRAME_DONE_PROC,manip_frame_done_proc,
			0);
		panl=(Panel)xv_get(manip_frame[i],FRAME_CMD_PANEL);

		xv_set(panl,XV_HELP_DATA,"cp_help:Manip",0);

		manip_item[i]=xv_create(panl,PANEL_CHOICE,
			PANEL_LAYOUT,PANEL_VERTICAL,
			PANEL_CHOICE_STRINGS,"desensitize",
			"add_circle","enfold circle","rm_circle",
			"inc_radii","dec_radii","Path:",
			"  - start","  - finish/accept",
			"show coords","project to p",0,
			PANEL_VALUE,0,
			PANEL_NOTIFY_PROC, manip_proc,
			0);
		window_fit(panl);
		window_fit(manip_frame[i]);
	 }
	
} /* create_manip_frame */

/* ================ define icon image ====================*/

unsigned short circles_bits[] = {	
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8008,0x0000,0x0400,0x0011,
	0x8008,0x0000,0x0400,0x0011,0x8004,0x07F0,0x0800,0x0009,
	0x8004,0x380E,0x0800,0x0009,0x8004,0x4001,0x0800,0x0009,
	0x8004,0x8000,0x8800,0x0009,0x8005,0x0000,0x4800,0x0009,
	0x800A,0x0000,0x2800,0x0009,0x800C,0x0000,0x1800,0x0009,
	0xC018,0x0000,0x0C00,0x0011,0xF068,0x0000,0x0C00,0x0011,
	0x9F88,0x0000,0x0A00,0x0021,0x8210,0x0000,0x0600,0x0021,
	0x8190,0x0000,0x0500,0x0041,0x8090,0x0000,0x0480,0x0081,
	0x8050,0x0000,0x0460,0x0101,0x8030,0x0000,0x0418,0x0601,
	0x8030,0x0000,0x0407,0xF001,0x8010,0x0000,0x0438,0x0E01,
	0x8018,0x0000,0x08C0,0x0181,0x8018,0x0000,0x0900,0x0041,
	0x8008,0x0000,0x0E00,0x0031,0x800C,0x0000,0x1800,0x0009,
	0x800A,0x0000,0x2800,0x0009,0x8009,0x0000,0x5000,0x0005,
	0x8008,0x8000,0xA000,0x0003,0x8010,0x4001,0x2000,0x0003,
	0x8010,0x380E,0x4000,0x0001,0x8020,0x07F0,0x4000,0x0001,
	0x8043,0xF800,0x0000,0x0001,0x80DD,0xFFFF,0xFFFF,0xF001,
	0x8161,0xFFFF,0xFFFF,0xF001,0x8681,0xFFFF,0xFFFF,0xF001,
	0xBB01,0xC000,0x0000,0x7001,0xC401,0xC782,0x0E22,0x7001,
	0x8401,0xC442,0x1124,0x7001,0x8801,0xC445,0x1128,0x7001,
	0x9001,0xC445,0x1030,0x7001,0x9001,0xC785,0x1028,0x7001,
	0xA001,0xC408,0x9024,0x7001,0xA001,0xC40F,0x9124,0x7003,
	0xA001,0xC408,0x9122,0x7003,0xC001,0xC408,0x8E22,0x7005,
	0xC001,0xC000,0x0000,0x7009,0xC001,0xFFFF,0xFFFF,0xF009,
	0xC001,0xFFFF,0xFFFF,0xF037,0xC001,0xFFFF,0xFFFF,0xF059,
	0xC000,0x0000,0x40C0,0x01E1,0xC000,0x0000,0x4038,0x0E81,
	0xA000,0x0000,0x81FF,0xF101,0xA000,0x0000,0x8603,0x0201,
	0xA000,0x0000,0x9800,0xC401,0x9000,0x0001,0x2000,0x2401,
	0x9000,0x0001,0x4000,0x1401,0x8800,0x0002,0x8000,0x0C01,
	0x8400,0x0004,0x8000,0x0C01,0x8400,0x0005,0x0000,0x0601,
	0x8300,0x0019,0x0000,0x0601,0x8080,0x0022,0x0000,0x0301,
	0x8060,0x00C2,0x0000,0x0301,0x801C,0x0702,0x0000,0x0281,
	0x8003,0xF802,0x0000,0x0261,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};

/*================ defining cursors ==================*/

/* cursor for inactive screen */
static unsigned short inact_can_bits[]={
	0x8000,0x6000,0x7F00,0x21FF,0x201E,0x2018,0x2060,0x30C0,
	0x11C0,0x13E0,0x1270,0x1C38,0x1C1C,0x180E,0x1807,0x1002

};
mpr_static(inact_cursor_pix,16,16,1,inact_can_bits);

/* cursor for active screen */
static unsigned short act_can_bits[]={
	0x8000,0x7000,0x7F00,0x7FFF,0x3FFE,0x3FF8,0x3FE0,0x3FC0,
	0x1FC0,0x1FE0,0x1E70,0x1C38,0x1C1C,0x180E,0x1807,0x1002
};
mpr_static(act_cursor_pix,16,16,1,act_can_bits);

/* cursor for when mouse is in mode for deleting circles */
static unsigned short delete_bits[]={
	0x000F,0x0038,0x0060,0x00C0,0x00C0,0x00FC,0x03FE,0x07C3,
	0x8EC3,0xDCC3,0xF866,0xF87E,0xF01C,0xF000,0xFC00,0xFE00
};
mpr_static(delete_cursor_pix,16,16,1,delete_bits);

/* cursor for locating coords */
static unsigned short axes_bits[]={
	0x0180,0x03C0,0x07E0,0x0180,0x0180,0x2184,0x6186,0xFFFF,
	0xFFFF,0x6186,0x2184,0x0180,0x0180,0x07E0,0x03C0,0x0180
};
mpr_static(axes_cursor_pix,16,16,1,axes_bits);

/* cursor for projection of faces */
static unsigned short proj_bits[]={
	0x0FFF,0x03FF,0x01FF,0x019F,0x030F,0x0707,0x0607,0x0C0F,
	0x0C3F,0x1873,0x31E1,0x2381,0x6600,0x7C00,0xF000,0xC000,
};
mpr_static(proj_cursor_pix,16,16,1,proj_bits);


/* cursor for when mouse is in mode for adding circles */
static unsigned short add_cir_bits[]={
	0x0070,0x01FC,0x038E,0x0306,0x0623,0x0673,0x0623,0x0706,
	0x078E,0x0FFC,0x8FF0,0xDE00,0xF800,0xF000,0xF800,0xFC00
};
mpr_static(add_cursor_pix,16,16,1,add_cir_bits);

/* cursor for resizing circles with mouse drag */
static unsigned short size_bits[]={
	0x07E0,0x1818,0x2004,0x5C3A,0x581A,0x9429,0x8241,0x8181,
	0x8181,0x8241,0x9429,0x581A,0x5C3A,0x2004,0x1818,0x07E0
};
mpr_static(size_cursor_pix,16,16,1,size_bits);

/* cursor for enfolding a bdry vert */
static unsigned short enfold_bits[]={
	0x0400,0x0400,0x0BE0,0x0B80,0x0BC0,0x1224,0x1214,0x101C,
	0x201C,0x207C,0x2003,0x401C,0x40E0,0xC700,0xF800,0xE000
};
mpr_static(enfold_cursor_pix,16,16,1,enfold_bits);

/* cursor for incrementing verts */
static unsigned short incr_bits[]={
	0x0100,0x0380,0x0380,0x07C0,0x07C0,0x0D60,0x0920,0x1110,
	0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100
};
mpr_static(incr_cursor_pix,16,16,1,incr_bits);

/* cursor for decrementing verts */
static unsigned short decr_bits[]={
	0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
	0x1110,0x1110,0x0920,0x0D60,0x07C0,0x0380,0x0380,0x0100
};
mpr_static(decr_cursor_pix,16,16,1,decr_bits);

/* cursor for drawing a path */
static unsigned short path_bits[]={
	0x0C00,0x1200,0x2700,0x4C80,0x9840,0xB020,0x6010,0x2010,
	0x1038,0x0878,0x04FC,0x03FC,0x00FE,0x003E,0x000F,0x0003
};
mpr_static(path_cursor_pix,16,16,1,path_bits);

/* cursor for locking a pack */
static unsigned short lock_bits[]={
	0xC7E0,0x9FF8,0x381C,0x300C,0x700E,0x6006,0x6006,0xFFFF,
	0xFE7F,0xFC3F,0xF81F,0xFC3F,0xFE7F,0xFE7F,0xFE7F,0xFFFF
};

mpr_static(lock_cursor_pix,16,16,1,lock_bits);

/*================ installing cursors ==================*/

create_cursors() /* creates the various cursors to use */
{
	Server_image circles_image;
	Icon icon;

	circles_image=(Server_image)xv_create((int)NULL,SERVER_IMAGE,
		XV_WIDTH,64,
		XV_HEIGHT,64,
		SERVER_IMAGE_BITS,	circles_bits,
		NULL);

	icon = (Icon)xv_create(base_frame, ICON,
        ICON_IMAGE,             circles_image,
        XV_X,                   0,
        XV_Y,                   0,
        NULL);

	xv_set(base_frame, ICON_IMAGE,circles_image,FRAME_ICON, icon, NULL);


	inact_can_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, 
	   &inact_cursor_pix,0);

	act_can_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, 
	   &act_cursor_pix,0);

	delete_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, 
	   &delete_cursor_pix,0);
		cursor_set(delete_cursor,CURSOR_XHOT,0,CURSOR_YHOT,15,0);

	axes_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &axes_cursor_pix,0);
		cursor_set(axes_cursor,CURSOR_XHOT,7,CURSOR_YHOT,7,0);

	proj_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &proj_cursor_pix,0);
		cursor_set(proj_cursor,CURSOR_XHOT,15,CURSOR_YHOT,0,0);

	add_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &add_cursor_pix,0);
		cursor_set(add_cursor,CURSOR_XHOT,0,CURSOR_YHOT,15,0);

	size_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &size_cursor_pix,0);
		cursor_set(size_cursor,CURSOR_XHOT,7,CURSOR_YHOT,7,0);

	enfold_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE,
	   &enfold_cursor_pix,0);
		cursor_set(enfold_cursor,CURSOR_XHOT,0,CURSOR_YHOT,15,0);

	incr_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &incr_cursor_pix,0);
		cursor_set(incr_cursor,CURSOR_XHOT,7,CURSOR_YHOT,0,0);

	decr_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &decr_cursor_pix,0);
		cursor_set(decr_cursor,CURSOR_XHOT,7,CURSOR_YHOT,15,0);

	path_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &path_cursor_pix,0);
		cursor_set(path_cursor,CURSOR_XHOT,15,CURSOR_YHOT,15,0);

	lock_cursor=(Xv_Cursor)cursor_create(CURSOR_IMAGE, &lock_cursor_pix,0);
		cursor_set(lock_cursor,CURSOR_XHOT,0,CURSOR_YHOT,0,0);


} /* create_cursors() */
