/*
 * $Id: mysql.c,v 1.22 1998/09/27 11:03:26 ch Exp $
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Hints: see http://www.turbolift.com/mysql/chapter4.html
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include "mysql.h"
#include "libch.h"

MYSQL           ch_mysql_con;

void ch_mysql_open(char *name) {
	if (!mysql_connect(&ch_mysql_con,"localhost","ch","")) {
		ch_panic("error opening mysql connection");
        }
        if (mysql_select_db(&ch_mysql_con,name) != 0) {
		ch_panic("error selecting mysql database");
        }             
}

void ch_mysql_close() {
	mysql_close(&ch_mysql_con);
}

char *ch_mysql_error() {
	return mysql_error(&ch_mysql_con);
}

void ch_mysql_query(char *query) {
	if (mysql_query(&ch_mysql_con, query)) {
		ch_panic("ch_mysql_query: ERROR at %s:\n%s\n",
			query,mysql_error(&ch_mysql_con));
	}
} 

int ch_mysql_quiet_query(char *query) {
	if (mysql_query(&ch_mysql_con, query)) return 1;
	return 0; 
} 

int ch_mysql_num_rows(MYSQL_RES *res) {
	return mysql_num_rows(res);
}

MYSQL_RES *ch_mysql_store_result() {
	return mysql_store_result(&ch_mysql_con);
}

MYSQL_ROW ch_mysql_fetch_row(MYSQL_RES *result) {
	return mysql_fetch_row(result);
}

void ch_mysql_free_result(MYSQL_RES *result) {
	mysql_free_result(result);
}
	
