#ifndef __py_config_hh__
#define __py_config_hh__
// Macros to deal with deficiencies in compilers
#define COMPILER_SUPPORTS_NAMESPACES 1

#if COMPILER_SUPPORTS_NAMESPACES
#define NAMESPACE_BEGIN(name) namespace name {
#define NAMESPACE_END }
#define STD std
#define USING(phrase) using phrase;
#define STANDARD_HEADER(name) <name>
#else
#define NAMESPACE_BEGIN(name)
#define NAMESPACE_END
#define STD
#define USING(phrase) 
#define CXX_QUOTE(thing) #thing
#define STANDARD_HEADER(name) CXX_QUOTE(name.h)
#endif

#endif                          // __py_config_hh__

