.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutInit 3GLUT "3.6" "GLUT" "GLUT"
.SH NAME
glutInit - initialize the GLUT library. 
.SH SYNTAX
.nf
.LP
void glutInit(int *argcp, char **argv);
.fi
.SH ARGUMENTS
.IP \fIargcp\fP 1i
A pointer to the program's unmodified argc variable from main.
Upon return, the value pointed to by argcp will be updated,
because glutInit extracts any command line options intended
for the GLUT library. 
.IP \fIargv\fP 1i
The program's unmodified argv variable from main. Like
argcp, the data for argv will be updated because glutInit
extracts any command line options understood by the GLUT
library. 
.SH DESCRIPTION
glutInit will initialize the GLUT library and negotiate a session with
the window system. During this process, glutInit may cause the
termination of the GLUT program with an error message to the user if
GLUT cannot be properly initialized.  Examples of this situation include
the failure to connect to the window system, the lack of window system
support for OpenGL, and invalid command line options. 
.LP
glutInit also processes command line options, but the specific options
parse are window system dependent. 
.SH X IMPLEMENTATION NOTES
The X Window System specific options parsed by glutInit are as
follows:
.TP 8
.B \-display \fIDISPLAY\fP
Specify the X server to connect to. If not specified, the value of the
DISPLAY environment variable is used. 
.TP 8
.B \-geometry \fIWxH+X+Y\fP
Determines where window's should be created on the screen. The
parameter following -geometry should be formatted as a
standard X geometry specification.  The effect of using this option
is to change the GLUT initial size and initial position the same as
if glutInitWindowSize or glutInitWindowPosition were
called directly. 
.TP 8
.B \-iconic
Requests all top-level windows be created in an iconic state. 
.TP 8
.B \-indirect
Force the use of indirect OpenGL rendering contexts. 
.TP 8
.B \-direct
Force the use of direct OpenGL rendering contexts (not all GLX
implementations support direct rendering contexts). A fatal error
is generated if direct rendering is not supported by the OpenGL
implementation. 

If neither -indirect or -direct are used to force a particular
behavior, GLUT will attempt to use direct rendering if possible
and otherwise fallback to indirect rendering. 
.TP 8
.B \-gldebug
After processing callbacks and/or events, check if there are any
OpenGL errors by calling glGetError.  If an error is reported,
print out a warning by looking up the error code with
gluErrorString.  Using this option is helpful in detecting  
OpenGL run-time errors. 
.TP 8
.B \-sync
Enable synchronous X protocol transactions.  This option makes it
easier to track down potential   X protocol errors. 
.SH SEE ALSO
glutCreateWindow,
glutInitWindowPosition,
glutInitWindowSize,
glutMainLoop
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
