/*****************             Electirc Eyes           ***********************/
/* This software is Copyright (C) 1998 but The Rasterman (Carsten Haitzler). */
/* This software falls under the GNU Public License. Please read the COPYING */
/* file for more information                                                 */
/*****************************************************************************/

#include <ee_toolbar.h>
#include "functions.h"
#include <stdio.h>
#include <stdlib.h>

/* major hack */
#include "gnome-stock-menu-first.xpm"
#include "gnome-stock-menu-last.xpm"

GtkWidget          *
ee_toolbar_new(void)
{
  GtkWidget *w, *icon;

  w = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_QUIT);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Exit", 
			  "Exit Electric Eyes",
			  "Exit Electric Eyes",
			  icon,
			  func_exit,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_OPEN);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Open", 
			  "Open a new file",
			  "Open a new file",
			  icon,
			  func_open_image,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_SAVE);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Save", 
			  "Save as original filename",
			  "Save as original filename",
			  icon,
			  func_save_image_only,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_SAVE_AS);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Save As", 
			  "Save as new file",
			  "Save as new file",
			  icon,
			  func_save_image,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_PRINT);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Print", 
			  "Print image",
			  "Print image",
			  icon,
			  func_print_image,
			  NULL);
  icon = gnome_pixmap_new_from_xpm_d(gnome_stock_menu_first_xpm);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "First", 
			  "View the first image in the list",
			  "View the first image in the list",
			  icon,
			  func_first,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_BACK);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Previous", 
			  "View the previous image in the list",
			  "View the previous image in the list",
			  icon,
			  func_prev,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_FORWARD);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Next", 
			  "View the next image in the list",
			  "View the next image in the list",
			  icon,
			  func_next,
			  NULL);
  icon = gnome_pixmap_new_from_xpm_d(gnome_stock_menu_last_xpm);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Last", 
			  "View the last image in the list",
			  "View the last image in the list",
			  icon,
			  func_last,
			  NULL);
  icon = gnome_stock_pixmap_widget(w, GNOME_STOCK_MENU_CUT);
  gtk_toolbar_append_item(GTK_TOOLBAR(w), 
			  "Crop", 
			  "Crop the current selection",
			  "Crop the current selection",
			  icon,
			  func_crop_image,
			  NULL);
  return w;
}

