#include "header.h"

implementActionCallback(MyDialog)
implementFieldEditorCallback(MyDialog)

MyDialog::MyDialog(Style *s, TestMenu *m, Glyph *g) : Dialog(g, s) {
        WidgetKit& kit = *WidgetKit::instance();
        DialogKit& dkit = *DialogKit::instance();

        my_menu = m;
        pushaction = new ActionCallback(MyDialog)
                    (this,&MyDialog::ok_button);
        Resource::ref(pushaction);
        FieldEditorAction *fieldaction =  new FieldEditorCallback(MyDialog)
               (this, &MyDialog::field_accept,
                &MyDialog::field_cancel);
        editor = dkit.field_editor("Beeblebrox", kit.style(), fieldaction);
        Resource::ref(editor);
        body(CreateGlyph(kit));
        append_input_handler(editor);
        next_focus();
}

MyDialog::~MyDialog() {
        Resource::unref(editor);
        Resource::unref(pushaction);
}

FieldEditor* MyDialog::get_editor() {
        return editor;
}

MonoGlyph* MyDialog::CreateGlyph(WidgetKit &kit) {
        LayoutKit& l = *LayoutKit::instance();

        Glyph *v1 = l.vglue(25.0,40.0,10.0);
        Glyph *v2 = l.vglue(15.0,30.0,5.0);
        Glyph *h1 = l.hglue(25.0,100.0,10.0);

        PolyGlyph *label_box =
          l.hbox(h1, kit.outset_frame(
                     kit.fancy_label("Enter Name:")), h1);

        PolyGlyph *enter_box =
          l.hbox(h1, kit.outset_frame(editor), h1);

        PolyGlyph *exit_button =
          l.hbox(h1, kit.push_button("OK",pushaction), h1);

        MonoGlyph *my_all = kit.outset_frame(
          l.vbox(v1, label_box, v2, enter_box,
                               v2,exit_button,v1));

        return my_all;
}

void MyDialog::ok_button() {
        field_accept(editor);
}

void MyDialog::field_accept(FieldEditor *f) {
        const char* text;
        text = f->text()->string();
        cerr<<"Field editor accepted input.\n";
        my_menu->delete_dialogbox(text);
        dismiss(1);
}

void MyDialog::field_cancel(FieldEditor *f) {
        const char* text;
        text = f->text()->string();

        cerr<<"Field Editor was canceled.\n";
        my_menu->delete_dialogbox(text);
        dismiss(0);
}
