// Usage:  client -i <stringified IOR>
//         client <COSNaming compound name (e.g. x/y/echo.obj)>


#include <stdlib.h>
#include <iostream.h>
#include <common/common.h>
#include <echo.hh>

void hello(CORBA::Object_ptr obj);

CORBA::Boolean
comm_exc(void*, CORBA::ULong retries,const CORBA::COMM_FAILURE& ex)
{
  cerr << ">>> Comm Failure exception handler (" 
       << retries 
       << " retries)" 
       << endl;
  throw ex;

#ifdef NEED_DUMMY_RETURN
  return 0;
#endif
}

int
main (int argc, char **argv) 
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
        CosNaming::Name use_name = string_to_name(argv[1]);
        obj = getObjectReference(orb,use_name);
      }
      catch (...) {
        obj = CORBA::Object::_nil(); 
	cerr << "Caught an exception in getObjectReference." << endl;
	  }
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot resolve compound name to an object reference."
				  << endl;
	    return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	    cerr << "Cannot convert stringified IOR to an object reference."
	          << endl;
	    return 1;
      }
      break;
    }
  default:
    cerr << "usage: client -i <stringified IOR>" << endl;
    cerr << "       client <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }


  omniORB::traceLevel = 15;
  omniORB::installCommFailureExceptionHandler(0,comm_exc);

  CORBA::Boolean cont = 1;
  CORBA::ULong nth = 0;
  while (cont) {
    try {
      hello(obj);
    }
    catch(omniORB::fatalException& ex) {
      cerr << "Caught omniORB2 fatalException. This indicates a bug is caught "
	   << "within omniORB2.\nPlease send a bug report.\n"
	   << "The exception was thrown in file: " << ex.file() << "\n"
	   << "                            line: " << ex.line() << "\n"
	   << "The error message is: " << ex.errmsg() << endl;
      cont = 0;
    }
    catch(CORBA::SystemException &ex) {
      cerr << "Caught a system exception." << endl;
      cont = 0;
    }
    omni_thread::sleep(0,500000000);
  }
  return 0;
}


void
hello(CORBA::Object_ptr obj)
{
  Echo_var e = Echo::_narrow(obj);

  if (CORBA::is_nil(e)) {
    cerr << "hello: cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  CORBA::String_var src = (const char*) "Hello!"; // String literals are not
                                                  // const char*. Must do
                                                  // explicit casting to 
                                                  // force the use of the copy
                                                  // operator=(). 
  CORBA::String_var dest;

  dest = e->echoString(src);

  cerr << "I said,\"" << (char*)src << "\"."
       << " The Object said,\"" << (char*)dest <<"\"" << endl;
}

