// usage: tombstone [-i <target object stringified IOR>]
//        tombstone <tombstone obj name> <attribute obj name> <shutdown obj name> [<target obj: read from this name>]
//                   Names are COSNaming compound names (e.g. x/y/test.obj)

#include <iostream.h>
#include <attrObjRef.hh>
#include <shutdown.hh>
#include <reDirect.h>
#include <common/common.h>

CORBA::BOA_ptr boa;

class attrObjRef_i : public virtual _sk_attrObjRef {
public:
  attrObjRef_i (reDirect* tombstone) : stone(tombstone) {}
  virtual CORBA::Object_ptr  obj ();
  virtual void obj (CORBA::Object_ptr  _value);
private:
  reDirect* stone;
};

CORBA::Object_ptr
attrObjRef_i::obj ()
{
  return stone->forwardReference();
}

void
attrObjRef_i::obj (CORBA::Object_ptr  _value)
{
  stone->forwardReference(CORBA::Object::_duplicate(_value));
}

class Shutdown_i : public virtual _sk_Shutdown {
public:
  Shutdown_i() {}
  ~Shutdown_i() {}
  void off() { boa->impl_shutdown(); }
};

int
main(int argc, char** argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name tomb_name;
  CosNaming::Name attr_name;
  CosNaming::Name shutdown_name;

  CORBA::Object_var target_obj;

  switch (argc) {
  case 5:
    try {
      tomb_name = string_to_name(argv[1]);
      attr_name = string_to_name(argv[2]);
      shutdown_name = string_to_name(argv[3]);
      CosNaming::Name target_name = string_to_name(argv[4]);
      target_obj = getObjectReference(orb,target_name);
      break;
    }
    catch (...) {
      cerr << argv[1] << " or " << argv[2] << " or " << argv[3] 
	   << " or " << argv[4] 
	   << " is not a valid COS Naming compound name." << endl;
      return 1;      
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      target_obj = orb->string_to_object(argv[2]);
      break;
    }
  default:
    cerr << "usage: tombstone -i <target object stringified IOR>\n"
	 << "       tombstone <tombstone obj name> <attribute obj name> <shutdown obj name> <target obj: read from this name>\n"
	 << "       Names are COSNaming compound names (e.g. x/y/test.obj)"
	 << endl;
    return 1;
  }

  if (CORBA::is_nil(target_obj)) {
    cerr << "Cannot forward to a nil object." << endl;
    return 1;
  }

  reDirect* tombstone = new reDirect(target_obj);
  tombstone->_obj_is_ready(boa);

  {
    CORBA::Object_var objref = tombstone->_this();
    if (tomb_name.length()) {
      if (!bindObjectToName(orb,objref,tomb_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(objref);
      cerr << "Tombstone Object : " << (char*)p << endl;
    }
  }

  attrObjRef_i *myattr = new attrObjRef_i(tombstone);
  myattr->_obj_is_ready(boa);
  {
    attrObjRef_var myobjRef = myattr->_this();
    if (attr_name.length()) {
      if (!bindObjectToName(orb,myobjRef,attr_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Attribute Object : " << (char*)p << endl;
    }
  }

  Shutdown_i *myswitch = new Shutdown_i;
  myswitch->_obj_is_ready(boa);
  {
    CORBA::Object_var myobjRef = myswitch->_this();
    if (shutdown_name.length()) {
      if (!bindObjectToName(orb,myobjRef,shutdown_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Offswitch object: " << (char*)p << endl;
    }
  }
  
  boa->impl_is_ready();
  myattr->_dispose();
  myswitch->_dispose();
  tombstone->_dispose();
  boa->destroy();

  return 0;
}
