#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <iostream.h>

#ifdef __WIN32__
#include <sys/types.h>
#include <sys/timeb.h>
#elif __atmos__
#include <kernel.h>
#elif defined(__VMS)
#include <sys/types.h>
#include <sys/timeb.h>
#else
#include <sys/time.h>
#include <unistd.h>
#endif


#include <fcntl.h>
#include <ctype.h>
#include <stdio.h>
#include <echo.hh>
#include <common/common.h>

int
main (int argc, char **argv) {
  try {  
    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

    CORBA::Object_var obj;

    switch (argc) {
    case 2:
      {
	try {
	  CosNaming::Name use_name = string_to_name(argv[1]);
	  obj = getObjectReference(orb,use_name);
	}
	catch (...) {
	  obj = CORBA::Object::_nil();
	}
	if (CORBA::is_nil(obj)) {
	  cerr << "Cannot resolve compound name to an object reference."
	       << endl;
	  return 1; 
	}
	break;
      }
    case 3:
      if (strcmp(argv[1],"-i") == 0) {
	obj = orb->string_to_object(argv[2]);
	if (CORBA::is_nil(obj)) {
	  cerr << "Cannot convert stringified IOR to an object reference."
	       << endl;
	  return 1;
	}
	break;
      }
    default:
      cerr << "usage: nullecho -i <stringified IOR>" << endl;
      cerr << "       nullecho <COSNaming compound name (e.g. x/y/echo.obj)>"
	   << endl;
      return 1;
    }

    Echo_ptr e = Echo::_narrow(obj);

    if (CORBA::is_nil(e))
      {
	cerr << "Can't create proxy.\n" << endl;
	return(1);
      }

    char *srcstr = "";
    char *echostr;
    int size;

#if !defined(__WIN32__) && !defined(__VMS_VER) || __VMS_VER >= 70000000
    struct timeval st,et;
#else
# ifdef __WIN32__
    struct _timeb  st,et;
# else
    struct timeb  st,et;
# endif
#endif
    int callcount = 10000;

    echostr = e->echoString(srcstr);
    CORBA::string_free(echostr);

#if !defined(__WIN32__) && !defined(__VMS_VER) || __VMS_VER >= 70000000
    gettimeofday(&st,0);
#else
# ifdef __WIN32__
    _ftime(&st);
# else
    ftime(&st);
# endif
#endif
    while (callcount--) {
      echostr = e->echoString(srcstr);
      CORBA::string_free(echostr);
    }

#if !defined(__WIN32__) && !defined(__VMS_VER) || __VMS_VER >= 70000000
    gettimeofday(&et,0);
    et.tv_usec += (et.tv_sec - st.tv_sec) * 1000000;
    et.tv_usec -= st.tv_usec;
    cout << "Completed " << 10000 << " calls at " << et.tv_usec / 10000 << " usec per call." << endl; 
#else
# ifdef __WIN32__
    _ftime(&et);
# else
    ftime(&et);
# endif
    et.millitm += (et.time - st.time) * 1000;
    et.millitm -= st.millitm;
    cout << "Completed " << 10000 << " calls at " << (et.millitm*1000) / 10000 << " usec per call." << endl; 
#endif
  
    CORBA::release(e);
  
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  catch (const omniORB::fatalException &ex) {
    cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
    cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
    cerr << "main thread exited." << endl;
  }
  return 0;
}

