;;; -*- Mode: Lisp; Package: System -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;;

(in-package "SYSTEM")

;;; when you've edited this file remove this:
(format t ";;; *** Don't forget to edit /var/lib/cmucl/site-init.lisp! ***~%")

;;; Put your site name here...
(setq *short-site-name* "Unknown")
(setq *long-site-name* "Site name not initialized")

;;; We would appreciate it if each site establishes a local maintainer who can
;;; filter bug reports from novice users to make sure that they really have
;;; found a bug.  Fill in the maintainer's address here..
(rplaca
 (cdr (member :bugs *herald-items*))
 '("Send bug reports and questions to your local CMU CL maintainer, " terpri
   "or to " 
   "pvaneynd@debian.org" terpri
   "or to " 
   "cmucl-help@cons.org. (prefered)" terpri terpri
   "type (help) for help, (quit) to exit, and (demo) to see the demos" terpri
   terpri
   "Loaded subsystems:" terpri))

;;; If you have sources installed on your system, un-comment the following form
;;; and change it to point to the source location.  This will allow the Hemlock
;;; "Edit Definition" command and the debugger to find sources for functions in
;;; the core.
(setf (ext:search-list "target:")
      '(
        "/usr/src/cmucl/cmucl/x86/"      ; object dir
; place stuff there, get if from below
        "/usr/src/cmucl/cmucl/src/"    ; x86 port
        ))

(setf (ext:search-list "library:") '("/usr/lib/cmucl/"))
;;; for safety...

;;; optional extentions to the lisp image: delete if you
;;; don't like them :-).
(in-package :common-lisp-user)

(defvar hs-index (make-hash-table))

(defun read-hyperspec-index ()
  (with-open-file (table
		   "/usr/doc/cmucl/HyperSpec/HyperSpec/Data/Symbol-Table.text"
		   :direction :input
		   :if-does-not-exist nil)
    (if (not table)
	(format t "I can't find the symbol table of the Hyperspec,~%Are you sure it's installed?~%")
	(progn
	  (loop
	   (let* ((symbol (read table nil :einde))
		  (section (read-line table nil :einde)))
	     (if (or (eq symbol :einde)
		     (eq section :einde))
		 (return))
	     (setf (gethash symbol hs-index)
		   section)))))))

(defun lookup-in-hyperspec (key)
  (if (not (gethash 'nil hs-index))
      (read-hyperspec-index))
  (concatenate 'string "/usr/doc/cmucl/HyperSpec/HyperSpec/Data/"
	       (gethash key hs-index)))

(defun show-hs (symbol)
  (when (not (gethash 'nil hs-index))
    (read-hyperspec-index))
  (if (not (gethash symbol hs-index))
      (format t "Symbol ~A not found in hyperspec, sorry~%"
	      symbol)
      ;; stupid but works: if there isn't a window open
      ;; the remote will fail, so we try to start a new
      ;; window :-)
      (unless (=
	       0
	       (process-exit-code
		(run-program "netscape"
			     (list "-remote" (format
					      nil "openURL(file:~A)"
					      (lookup-in-hyperspec symbol)))
			     :env *ENVIRONMENT-LIST*
			     :wait t
			     :input nil
			     :output nil
			     :error nil)))
	(run-program "netscape"
		     (list (format nil "file:~A"
				   (lookup-in-hyperspec symbol)))
		     :env *ENVIRONMENT-LIST*
		     :wait nil
		     :input nil
		     :output nil
		     :error nil))))

;;; newbie functions, delete if you don't like them, but
;;; also modify the *herald-items* above

#-hemlock
(defun ed ()
  (format t "Sorry, you haven't loaded the hemlock package.~%~
Configure it in by executing /usr/lib/cmucl/config~
, or do: ~%(load ~Clibrary:subsystems/hemlock-library~C)~%~
Note that this library depends on CLX, so load it too. (load ~Csubsystems/clx-library~C)~%"
 #\" #\" #\" #\"))

(defun help ()
  (format t "~
Welcome to CMUCL for Linux.

If you aren't running this with ilisp in emacs,
or aren't intending to use hemlock then you
deserve to lose.

Read the documentation in /usr/doc/cmucl and
/usr/info/.

Create your own personal image with
/usr/lib/cmucl/config

(quit) is to quit.
(ed) starts hemlock (if installed)
(demo) shows a list of demos
(describe 'progn) gives information about progn
(inspect '*a*) interactively displays *a*
"))

(defun demo ()
  (format t "~
The demo's are in the source package, because
demos without source is like a cafe without beer.

Replace slartibartfast.org with your hostname
(the output of \"uname -n\")

General demos:
CLX demos:
 if you have loaded clx you can do:
 (load \"/usr/src/18f/src/clx/demo/hello\")
 (xlib::hello-world \"slartibartfast.org\")
 (load \"/usr/src/18f/src/clx/demo/menu\")
 (xlib::just-say-lisp \"slartibartfast.org\")
 (xlib::pop-up \"slartibartfast.org\"
	       '(\"Linux\" \"FreeBSD\" \"OpenBSD\"))
  exit by pressing control+C followed by a keypress.

Clue demos:
 if you have clue loaded you can do:
 (load \"/usr/src/clio-clue/clue/examples/menu\")
 (clue-examples::beatlemenuia \"slartibartfast.org\")
 (clue-examples::pick-one \"slartibartfast.org\"
			  \"One\"
			  \"Two\"
			  \"Three\")
 (clue-examples::just-say-lisp \"slartibartfast.org\")

Clio demos:
 if you have clio loaded you can do:
 (load \"/usr/src/clio-clue/clio/examples/defsystem\")
 (load-clio-examples :host nil
		     :directory \"/usr/src/clio-clue/clio/examples\"
		     :compile-p nil)
(clio-examples::sketch :host  \"slartibartfast.org\")

Pictures demos:
 don't work with me.

Tk demos:
 if you have lisp-tk loaded you can do:
 (tk::tkconnect)
 (load \"/usr/src/tk/demo/load-all\")
 the gc monitor doesn't work yet.

"))

;(setf *batch-mode* t)

