#define GOOD_TRIG

#if defined(GOOD_TRIG)
#define FHT_SWAP(a,b,t) {(t)=(a);(a)=(b);(b)=(t);}

#define TRIG_VARS	long t_lam=0;

#define TRIG_INIT(k, c, s)				        \
	{							\
		long i;						\
		for (i=2 ; i<=k ; i++)				\
			{coswrk[i]=costab[i];sinwrk[i]=sintab[i];}	\
		t_lam = 0;					\
		c = 1.0f;					\
		s = 0.0f;					\
	}

#define TRIG_NEXT(k,c,s)					\
	{							\
		long i,j;	                                \
		(t_lam)++;					\
		for (i=0 ; !((1L<<i)&t_lam) ; i++);		\
			i = k-i;				\
			s = sinwrk[i];				\
			c = coswrk[i];				\
			if (i>1)	{			\
			  for (j=k-i+2 ; (1L<<j)&t_lam ; j++);	\
			  j = k - j;				\
			  sinwrk[i] = halsec[i] * (sinwrk[i-1] + sinwrk[j]);\
			  coswrk[i] = halsec[i] * (coswrk[i-1] + coswrk[j]);\
			}					\
	}
#endif

#if defined(FAST_TRIG)
#define TRIG_VARS	float t_c,t_s;

#define TRIG_INIT(k,c,s)				\
	{						\
		t_c = costab[k];			\
		t_s = sintab[k];			\
		c = 1;					\
		s = 0;					\
	}

#define TRIG_NEXT(k,c,s)				\
	{						\
		float t = c;				\
		c   = t*t_c - s*t_s;			\
		s   = t*t_s + s*t_c;			\
	}
#endif

#define SQRT2_2		(0.70710678118654752440084436210484f)
#define SQRT2		(2.0f * 0.70710678118654752440084436210484f)

static float halsec[20]=
    {
     0.0f,
     0.0f,
     .54119610014619698439972320536638942006107206337801f,
     .50979557910415916894193980398784391368261849190893f,
     .50241928618815570551167011928012092247859337193963f,
     .50060299823519630134550410676638239611758632599591f,
     .50015063602065098821477101271097658495974913010340f,
     .50003765191554772296778139077905492847503165398345f,
     .50000941253588775676512870469186533538523133757983f,
     .50000235310628608051401267171204408939326297376426f,
     .50000058827484117879868526730916804925780637276181f,
     .50000014706860214875463798283871198206179118093251f,
     .50000003676714377807315864400643020315103490883972f,
     .50000000919178552207366560348853455333939112569380f,
     .50000000229794635411562887767906868558991922348920f,
     .50000000057448658687873302235147272458812263401372f
    };
static float costab[20]=
    {
     .00000000000000000000000000000000000000000000000000f,
     .70710678118654752440084436210484903928483593768847f,
     .92387953251128675612818318939678828682241662586364f,
     .98078528040323044912618223613423903697393373089333f,
     .99518472667219688624483695310947992157547486872985f,
     .99879545620517239271477160475910069444320361470461f,
     .99969881869620422011576564966617219685006108125772f,
     .99992470183914454092164649119638322435060646880221f,
     .99998117528260114265699043772856771617391725094433f,
     .99999529380957617151158012570011989955298763362218f,
     .99999882345170190992902571017152601904826792288976f,
     .99999970586288221916022821773876567711626389934930f,
     .99999992646571785114473148070738785694820115568892f,
     .99999998161642929380834691540290971450507605124278f,
     .99999999540410731289097193313960614895889430318945f,
     .99999999885102682756267330779455410840053741619428f
    };
static float sintab[20]=
    {
     1.0000000000000000000000000000000000000000000000000f,
     .70710678118654752440084436210484903928483593768846f,
     .38268343236508977172845998403039886676134456248561f,
     .19509032201612826784828486847702224092769161775195f,
     .09801714032956060199419556388864184586113667316749f,
     .04906767432741801425495497694268265831474536302574f,
     .02454122852291228803173452945928292506546611923944f,
     .01227153828571992607940826195100321214037231959176f,
     .00613588464915447535964023459037258091705788631738f,
     .00306795676296597627014536549091984251894461021344f,
     .00153398018628476561230369715026407907995486457522f,
     .00076699031874270452693856835794857664314091945205f,
     .00038349518757139558907246168118138126339502603495f,
     .00019174759731070330743990956198900093346887403385f,
     .00009587379909597734587051721097647635118706561284f,
     .00004793689960306688454900399049465887274686668768f
    };
static float coswrk[20]=
    {
     .00000000000000000000000000000000000000000000000000f,
     .70710678118654752440084436210484903928483593768847f,
     .92387953251128675612818318939678828682241662586364f,
     .98078528040323044912618223613423903697393373089333f,
     .99518472667219688624483695310947992157547486872985f,
     .99879545620517239271477160475910069444320361470461f,
     .99969881869620422011576564966617219685006108125772f,
     .99992470183914454092164649119638322435060646880221f,
     .99998117528260114265699043772856771617391725094433f,
     .99999529380957617151158012570011989955298763362218f,
     .99999882345170190992902571017152601904826792288976f,
     .99999970586288221916022821773876567711626389934930f,
     .99999992646571785114473148070738785694820115568892f,
     .99999998161642929380834691540290971450507605124278f,
     .99999999540410731289097193313960614895889430318945f,
     .99999999885102682756267330779455410840053741619428f
    };
static float sinwrk[20]=
    {
     1.0000000000000000000000000000000000000000000000000f,
     .70710678118654752440084436210484903928483593768846f,
     .38268343236508977172845998403039886676134456248561f,
     .19509032201612826784828486847702224092769161775195f,
     .09801714032956060199419556388864184586113667316749f,
     .04906767432741801425495497694268265831474536302574f,
     .02454122852291228803173452945928292506546611923944f,
     .01227153828571992607940826195100321214037231959176f,
     .00613588464915447535964023459037258091705788631738f,
     .00306795676296597627014536549091984251894461021344f,
     .00153398018628476561230369715026407907995486457522f,
     .00076699031874270452693856835794857664314091945205f,
     .00038349518757139558907246168118138126339502603495f,
     .00019174759731070330743990956198900093346887403385f,
     .00009587379909597734587051721097647635118706561284f,
     .00004793689960306688454900399049465887274686668768f
    };
