/* interface MIDI routines by G.Maldonado */
/*
 * $Id: midi_cs_gab_linux.cc,v 1.3 1998/11/30 19:40:17 nicb Exp $
 *
 * This file contains the porting of what is essentially Win95/NT code
 * to linux
 *
 * FIXME: this is not done yet, just kidding to make csound link...:-))
 *        TODO: build classes WinMIDI_IN and WinMIDI_OUT that work under
 *	  linux and have the methods used by these function calls; after
 *	  that we'll be able to make this file run - for now it's just
 *	  a bunch of useless stubs...
 *					[nicb@axnet]
 */
#include "GabWinMIDI.h"

#if defined(WIN32)
WinMIDI_IN *midi_in_port;
WinMIDI_OUT *midi_out_port;
#endif /* defined(WIN32) */

extern "C"
{
	int midi_in_p_num=-1;
	int midi_out_p_num=-1;
	extern unsigned long MIDIINbufIndex;
	extern int  MIDIINBUFMAX;
	extern MIDIMESSAGE MIDIINbuffer2[];	/* see midiops2.c */
	extern int MIDIoutDONE;
}

extern "C" void setport_num(int num) 
{
 	midi_in_p_num = num;
}

extern "C" void set_out_port_num(int num)
{
	midi_out_p_num = num;
}

extern "C" void gab_midi_init()
{
#if defined(WIN32)
	if (midi_in_p_num ==-1)	{
		midi_in_port = new 	WinMIDI_IN;
		midi_in_p_num  = midi_in_port->port_num;
	}
	else 					midi_in_port = new  WinMIDI_IN(midi_in_p_num);
#endif /* defined(WIN32) */
}


extern "C" void gab_midi_out_init()
{
#if defined(WIN32)
	if (midi_out_p_num ==-1) {
		midi_out_port = new WinMIDI_OUT;
		midi_out_p_num  = midi_out_port->port_num;
	}
	else 					 midi_out_port = new WinMIDI_OUT(midi_out_p_num);
#endif /* defined(WIN32) */
	MIDIoutDONE=1;
}


extern "C" int readmidi(char *mbuf, int size)  /* GAB */
{
#if defined(WIN32)
    if (!midi_in_port->nextMessageInt()) return 0;
	else {
    	register MIDIMESSAGE  *message = (MIDIMESSAGE *) mbuf; 
		register int temp;
		*message = MIDIINbuffer2[MIDIINbufIndex++ % MIDIINBUFMAX] = midi_in_port->GetMidiMessage();
		/*returns the MIDI message number of bytes  */
		if ( (temp  =   midi_in_port->getType()) != MD_PROGRAMCHANGE && 
		      temp 								 !=	MD_CHANNELPRESSURE )		
				return 3; 
		else	return 2;
	}
#endif /* defined(WIN32) */
}


#if defined(WIN32)
extern "C" void send_midi_message(int status, int data1, int data2){
	midi_out_port->sendShortMessage(status + (data1 << 8) + (data2 << 16));
}

extern "C" void note_on(int chan, int num, int vel){
	midi_out_port->sendShortMessage((0x90 | chan) + (num << 8) + (vel << 16));
}

extern "C" void note_off(int chan, int num, int vel){
	midi_out_port->sendShortMessage((0x80 | chan) + (num << 8) + (vel << 16));
}

extern "C" void control_change(int chan, int num, int value) {
	midi_out_port->sendShortMessage((0xB0 | chan) + (num << 8) + (value << 16));
}

extern "C" void after_touch(int chan, int value){
	midi_out_port->sendShortMessage((0xD0 | chan) + (value << 8));
}

extern "C" void poly_after_touch(int chan, int note_num, int value){
	midi_out_port->sendShortMessage((0xA0 | chan) + (note_num << 8) + (value << 16));
}

extern "C" void program_change(int chan, int num) {
	midi_out_port->sendShortMessage((0xC0 | chan) + (num << 8));
}

extern "C" void pitch_bend(int chan, int msb, int lsb) {
	midi_out_port->sendShortMessage((0xE0 | chan) + (lsb << 8) + (msb << 16));
}
#endif /* defined(WIN32) */
