/* filter.h */

/* Author: Michael A. Casey
 * Language: C
 * Copyright (C) 1997 Michael A. Casey, MIT Media Lab, All Rights Reserved 
 *
 */


#ifndef __filter_h
#define __filter_h

#define MAXZEROS 50 /* Allow up to 50th-order digital filters */
#define MAXPOLES 50

/* Csound structure for FILTER opcode */

typedef struct {
  OPDS h;
  
  float *out;       /* output signal */
  float *in;        /* input signal */
  float *nb, *na;   /* filter-order input arguments */
  float *coeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient input arguments */
  float *d1,*d2;    /* These allow ZFILTER to access FILTER routines */
 
  int numa;         /* i-var p-time storage registers */
  int numb;

  double dcoeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient double arguments */
  AUXCH delay;     /* delay-line state memory base pointer */  
  double* currPos;  /* delay-line current position pointer */ /* >>Was float<< */
  int   ndelay;    /* length of delay line (i.e. filter order) */
} FILTER;

typedef struct {
  OPDS h;
  
  float *out;       /* output signal */
  float *in;        /* input signal */
  float *kmagf, *kphsf; /* magnitude and phase pole nudging factors */
  float *nb, *na;   /* filter-order input arguments */
  float *coeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient input arguments */
  
  int numa;         /* i-var p-time storage registers */
  int numb;

  double dcoeffs[MAXPOLES+MAXZEROS+1]; /* filter-coefficient double arguments */
  AUXCH delay;     /* delay-line state memory base pointer */  
  double* currPos;  /* delay-line current position pointer */ /* >>Was float<< */
  int   ndelay;    /* length of delay line (i.e. filter order) */
  AUXCH roots;     /* pole roots memory for zfilter */
} ZFILTER;

/* filter opcode function prototypes */

double  readFilter(FILTER*,int);   /* delay-line access routine */ /* >>>wasw float<<<*/
void insertFilter(FILTER*,double); /* delay-line update routine */

#endif
