/************************************************************************/
/* Module : xutil.c					                */
/* Purpose: Misc X routines              	                        */
/* By     : Keith R. Davis					        */
/* Date   : 7/24/98					                */
/* Notes  : Copyright(c) 1996-98 Mutiny Bay Software			*/
/************************************************************************/

#include <Xm/Xm.h>			/* motif lib header		*/
#include <Xm/PrimitiveP.h>              /* motif primitive widget head. */
#include <X11/cursorfont.h>             /* X cursors                    */

static void focusTO(void *data, XtIntervalId *id);
static void focusCB(Widget w, XtPointer data, XtPointer calldata);

/************************************************************************/
/* Function: XUTIL_BeginWait                                            */
/* Purpose : Grabs input events & displays watch cursor                 */
/* Params  : w : widget to receive wait state                           */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void XUTIL_BeginWait(Widget w)
{ 
  XDefineCursor(XtDisplay(w),
		XtWindow(w),
		XCreateFontCursor(XtDisplay(w),XC_watch));

  XmUpdateDisplay(w);

  XtGrabButton(w,
	       AnyButton,
	       AnyModifier,
	       TRUE,
	       ButtonPressMask|ButtonMotionMask|ButtonReleaseMask|
	       LeaveWindowMask|EnterWindowMask|FocusChangeMask,
	       GrabModeAsync,
	       GrabModeAsync,
	       None,
	       None);
}

/************************************************************************/
/* Function: XUTIL_EndWait                                              */
/* Purpose : UnGrabs input events                                       */
/* Params  : w : widget to have wait state removed                      */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void XUTIL_EndWait(Widget w)
{
  XtUngrabButton(w, AnyButton, AnyModifier);
  XUndefineCursor(XtDisplay(w),XtWindow(w));
  XmUpdateDisplay(w);
}

/************************************************************************/
/* Function: XUTIL_SetFocus                                             */
/* Purpose : set focus to the specified widget                          */
/* Params  : parent : parent widget                                     */
/*         : w      : widget to get focus                               */
/* Returns : nothing                                                    */
/* Notes   : this fixes the bug with setting widget focus in dlgs       */
/************************************************************************/

void XUTIL_SetFocus(Widget parent, Widget w)
{
  XtAddCallback(parent, XmNfocusCallback, focusCB, w);
}

/************************************************************************/
/* misc. support functions for XUTIL_SetFocus                           */
/************************************************************************/

static void focusTO(void *data, XtIntervalId *id)
{
  XmProcessTraversal((Widget) data, XmTRAVERSE_CURRENT);
}

static void focusCB(Widget w, XtPointer data, XtPointer calldata) 
{
  XtRemoveCallback(w, XmNfocusCallback, focusCB, data);
  XtAppAddTimeOut(XtWidgetToApplicationContext(w), 0, focusTO, data);
}
