.TH systems 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
systems  - a collection of dynamical system 
.SH CALLING SEQUENCE
.nf
[]=systems()
.fi
.SH DESCRIPTION
A call to this function will load into Scilab a set of macros which
describes dynamical systems. Their parameters can be initiated by 
calling the routine tdinit().
.SH BIOREACT
.nf
[ydot]=biorecat(t,x)
.fi
a bioreactor model, 
.TP 
x(1)
is the biomass concentration
.TP
x(2)
is the sugar concentration
.nf
                    xdot(1)=mu_td(x(2))*x(1)- debit*x(1);
                    xdot(2)=-k*mu_td(x(2))*x(1)-debit*x(2)+debit*x2in;
.fi
where mu_td is given by 
.nf
                    mu_td(x)=x/(1+x);
.fi
.SH COMPET
.nf
[xdot]=compet(t,x [,u])
.fi
a competition model. \fVx(1),x(2)\fR stands for two populations which 
grows on a same resource. \fV1/u\fR is the level of that resource (
1 is the default value).
.nf 
xdot=0*ones(2,1);
xdot(1) = ppr*x(1)*(1-x(1)/ppk) - u*ppa*x(1)*x(2) ,
xdot(2) = pps*x(2)*(1-x(2)/ppl) - u*ppb*x(1)*x(2) ,
.fi
.IP "The macro \fV[xe]=equilcom(ue)\fR"
computes an equilibrium point of the competition model and a fixed 
level of the resource ue ( default value is 1)
.IP "The macro \fV[f,g,h,linsy]=lincomp([ue])\fR"
gives the linearisation of the competition model ( with output y=x)
around the equilibrium point xe=equilcom(ue).
This macro returns [f,g,h] the three matrices of the linearised system.
and linsy which is a Scilab macro [ydot]=linsy(t,x) which computes the 
dynamics of the linearised system
.SH CYCLlIM
.nf
[xdot]=cycllim(t,x)
.fi
a model with a limit cycle 
.nf
  xdot=a*x+qeps(1-||x||**2)x
.fi
.SH LINEAR
.nf
[xdot]=linear(t,x)
.fi
a linear system 
.SH BLINPER
.nf
[xdot]=linper(t,x)
.fi
a linear system with quadratic perturbations.
.SH POP
.nf
[xdot]=pop(t,x)
.fi
a fish population model
.nf
xdot= 10*x*(1-x/K)- peche(t)*x
.fi
.SH PROIE
a Predator prey model with external insecticide.
.nf
[xdot]=p_p(t,x,[u]
.fi 
.TP
x(1) 
The prey ( that we want to kill ) 
.TP
x(2) 
the predator ( that we want to preserve ) 
.TP
u
mortality rate due to insecticide which 
destroys both prey and predator
( default value u=0)
.nf
xdot(1) = ppr*x(1)*(1-x(1)/ppk) - ppa*x(1)*x(2) - u*x(1);
xdot(2) = -ppm*x(2)             + ppb*x(1)*x(2) - u*x(2);
.fi

The macro \fV[xe]=equilpp([ue])\fR computes the equilibrium point of
the \fVp_p\fR system for the value \fVue\fR of the command. The
default value for \fVue\fR is 0.
.nf 
                    xe(1) =  (ppm+ue)/ppb;
                    xe(2) =  (ppr*(1-xe(1)/ppk)-ue)/ppa;
.fi
.SH LINCOM
.nf 
[xdot]=lincom(t,x,k)
.fi
linear system with a feedback 
.nf
	xdot= a*x +b*(-k*x)
.fi
.SH SEE ALSO
tdinit









