.TH save_graph 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
save_graph - saves a graph
.SH CALLING SEQUENCE
.nf
save_graph(g,path)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 5
name
: string, the path of the graph to save
.SH DESCRIPTION
\fVsave_graph\fR saves the graph \fVg\fR in a graph file.
\fVpath\fR is the name of the graph file where the graph will be saved.
\fVpath\fR can be the name or the pathname of the file; if the 
\fV"graph"\fR extension is missing in \fVpath\fR, it is assumed.
If \fVpath\fR is the name of a directory, the name of the graph is
used as the name of the file.
.SH EXAMPLE
.nf
g=load_graph(SCI+'/demos/metanet/mesh100');
show_graph(g);
unix('rm mymesh100.graph')
save_graph(g,'mymesh100.graph');
g=load_graph('mymesh100');
show_graph(g,'new');
.fi
.SH SEE ALSO
load_graph
