.TH find_path 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
find_path - finds a path between two nodes
.SH CALLING SEQUENCE
.nf
p = find_path(i,j,g)
.fi
.SH PARAMETERS
.TP 2
i
: integer, number of start node
.TP 2
j
: integer, number of end node
.TP 2
g
: graph list
.TP 2
p
: row vector of integer numbers of the arcs of the path if it exists
.SH DESCRIPTION
\fVfind_path\fR returns a path \fVp\fR from node number \fVi\fR to
node number \fVj\fR if one exists, and the empty vector \fV[]\fR otherwise.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
p=find_path(1,14,g);
edgecolor=1*ones(ta); edgecolor(p)=11*ones(p); g('edge_color')=edgecolor;
show_graph(g); show_arcs(p);
.fi
.SH SEE ALSO
nodes_2_path, shortest_path
