.TH xsegs 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
xsegs - draw unconnected segments
.SH CALLING SEQUENCE
.nf
xsegs(nx,ny,[style])
.fi
.SH PARAMETERS 
.TP 15
nx,ny 
: two matrices of the same size \fV2*n\fR
.TP
style
: a matrix of size \fVn\fR or a scalar. If \fVstyle\fR is a positive scalar 
it gives the dash style to use for all segments, if it is a negative scalar 
then current dash style is used, if it is a vector \fVstyle[i]\fR
gives the style to use for segment \fVi\fR.
.SH DESCRIPTION
this function draws a set of unconnected segments given by \fVnx,ny\fR
which are internally considered as vectors ( using the Fortran storage convention). 
The coordinates of the two points defining a segment
are given by two consecutive values of \fVnx\fR and \fVny\fR.
.LP
\fV(nx[i],ny[i])-->(nx[i+1],nx[i+2])\fR
.LP
Using matrices of size (2,.) the segments can be defined by 
.nf
nx=[ xi_1,xi_
     xf_1,xf_2,...  ]

ny=[ yi_1,yi_2,.....;
    yf_1,yf_2,...  ]
.fi
the segments are then \fV(xi_k,yi_k)->(xf_k,yf_k)\fR
.SH EXAMPLE
.nf
x=2*%pi*(0:9)/8;
x1=[sin(x);9*sin(x)];
y1=[cos(x);9*cos(x)];
plot2d([-10,10],[-10,10],[-1,-1],"022");
xset('clipgrf')
xsegs(x1,y1,1:10);
xset('clipoff')
.fi
.SH AUTHOR
C. J.Ph


