/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecPair (const char String[], const char Delim[], int Type,
                 void *Val1, void *Val2)

Purpose:
  Decode a data specification for a pair of numeric values

Description:
  This routine decodes a string specifying a pair of integer values.  The pair
  is specified as "V", "V1:", ":V2", or "V1:V2", for example "-23 : 45".  The
  delimiter is shown as ":" in the example, but a general delimiter string can
  be specified in the argument list.  Optional white-space (as defined by
  isspace) can surround the values.

Parameters:
  <-  int STdecPair
      Return code, negative for errors.
      0 - Single value (no delimiter) found (returned as Val1)
      1 - Left value followed by delimiter found
      2 - Right value preceded by delimiter found
      3 - Both values separated by delimiter found
   -> const char String[]
      Input string
   -> const char Delim[];
      Delimiter string.  This value is used in STfindToken to separate the
      two values.
   -> int Type
      Code for the data type, 'D' for double, 'F' for float, 'I' for int, 'L'
      for long int.
  <-  void *Val1
      First value
  <-  void *Val2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/31 02:09:08 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecPair.c 1.6 1997/10/31 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/nucleus.h>

#define MAXC	80


int
STdecPair (String, Delim, Type, Val1, Val2)

     const char String[];
     const char Delim[];
     int Type;
     void *Val1;
     void *Val2;

{
  char *token;
  int nc;
  const char *p;
  int status;
  char cbuf[MAXC+1];

/* Allocate temporary string space */
  nc = strlen (String);
  if (nc > MAXC)
    token = (char *) UTmalloc (nc + 1);
  else
    token = cbuf;

/* Decode the first value of the pair */
  p = STfindToken (String, Delim, "", token, 1, nc);

/* Notes:
  p == NULL indicates that there was no delimiter.
    - decode token (if it is of zero length, STdec1val will print a message)
  p != NULL delimiter present
    - token zero length, skip the first value
    - second value is p, if this is zero length, skip this value
*/
  status = 0;
  if (p == NULL) {
    if (STdec1val (token, Type, Val1))		/* No delimiter */
      status = -1;
  }
  else {					/* Delimiter */
    if (token[0] != '\0') {
      status = 1;				/* First value present */
      if (STdec1val (token, Type, Val1))
	status = -1;
    }

    /* Decode the second value of the pair */
    if (status >= 0 && *p != '\0') {
      status += 2;				/* Second value present */
      if (STdec1val (p, Type, Val2))
	status = -2;
    }
  }
    
  if (token != cbuf)
    UTfree ((void *) token);

  return status;
}
