/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLextName (const char Fname[], char Ext[])

Purpose:
  Return the extension component of a file name

Description:
  This routine takes a filename and returns the filename extension.  The
  extension is the part of the last component of the path name beginning with
  (and including) a period.  The extension for the path name "/abc/def.ghi" is
  ".ghi".

Parameters:
  <-  int FLextName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the file name
  <-  char Ext[]
      Output string with the extension.  This string is at most FILENAME_MAX
      characters long including the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.5 $  $Date: 1997/10/14 14:39:42 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLextName.c 1.5 1997/10/14 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */


int
FLextName (Fname, Ext)

     const char Fname[];
     char Ext[];

{
  char Bname[FILENAME_MAX];
  char *p;
  int n;

  FLbaseName (Fname, Bname);
  p = strchr (Bname, '.');
  if (p != NULL)
    n = STcopyMax (p, Ext, FILENAME_MAX-1);
  else {
    Ext[0] = '\0';
    n = 0;
  }

  return n;
}
